/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsclient;

import com.sun.messaging.AdministeredObject;
import com.sun.messaging.jmq.jmsclient.ExceptionHandler;
import com.sun.messaging.jmq.jmsclient.MessageImpl;
import com.sun.messaging.jmq.jmsclient.Traceable;
import com.sun.messaging.jmq.jmsclient.ValueConvert;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.PrintStream;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Map;
import java.util.Set;
import java.util.Vector;
import javax.jms.JMSException;
import javax.jms.MapMessage;
import javax.jms.MessageFormatException;

public class MapMessageImpl
extends MessageImpl
implements MapMessage,
Traceable {
    private Map mapMessage = new HashMap();
    private byte[] messageBody = null;
    private byte[] defaultBytes = new byte[32];
    private ByteArrayOutputStream byteArrayOutputStream = null;
    private ObjectOutputStream objectOutputStream = null;
    private ByteArrayInputStream byteArrayInputStream = null;
    private ObjectInputStream objectInputStream = null;

    protected MapMessageImpl() throws JMSException {
        this.setPacketType(3);
    }

    protected void setMessageBodyToPacket() throws JMSException {
        try {
            this.byteArrayOutputStream = new ByteArrayOutputStream();
            this.objectOutputStream = new ObjectOutputStream(this.byteArrayOutputStream);
            this.objectOutputStream.writeObject(this.mapMessage);
            this.objectOutputStream.flush();
            this.messageBody = this.byteArrayOutputStream.toByteArray();
            this.objectOutputStream.close();
            this.byteArrayOutputStream.close();
            this.setMessageBody(this.messageBody);
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4014");
        }
    }

    protected void getMessageBodyFromPacket() throws JMSException {
        try {
            this.messageBody = this.getMessageBody();
            this.byteArrayInputStream = new ByteArrayInputStream(this.messageBody);
            this.objectInputStream = new ObjectInputStream(this.byteArrayInputStream);
            this.mapMessage = (Map)this.objectInputStream.readObject();
        }
        catch (Exception exception) {
            ExceptionHandler.handleException(exception, "C4015");
        }
    }

    public void clearBody() throws JMSException {
        this.mapMessage.clear();
        this.setMessageReadMode(false);
    }

    public boolean getBoolean(String string) throws JMSException {
        return ValueConvert.toBoolean(this.mapMessage.get(string));
    }

    public byte getByte(String string) throws JMSException {
        return ValueConvert.toByte(this.mapMessage.get(string));
    }

    public short getShort(String string) throws JMSException {
        return ValueConvert.toShort(this.mapMessage.get(string));
    }

    public char getChar(String string) throws JMSException {
        return ValueConvert.toChar(this.mapMessage.get(string));
    }

    public int getInt(String string) throws JMSException {
        return ValueConvert.toInt(this.mapMessage.get(string));
    }

    public long getLong(String string) throws JMSException {
        return ValueConvert.toLong(this.mapMessage.get(string));
    }

    public float getFloat(String string) throws JMSException {
        return ValueConvert.toFloat(this.mapMessage.get(string));
    }

    public double getDouble(String string) throws JMSException {
        return ValueConvert.toDouble(this.mapMessage.get(string));
    }

    public String getString(String string) throws JMSException {
        return ValueConvert.toString(this.mapMessage.get(string));
    }

    public byte[] getBytes(String string) throws JMSException {
        Object v = this.mapMessage.get(string);
        if (v == null) {
            return null;
        }
        if (v instanceof byte[]) {
            return (byte[])v;
        }
        String string2 = AdministeredObject.cr.getKString("C4017");
        MessageFormatException messageFormatException = new MessageFormatException(string2, "C4017");
        ExceptionHandler.throwJMSException(messageFormatException);
        return null;
    }

    public Object getObject(String string) throws JMSException {
        return this.mapMessage.get(string);
    }

    public Enumeration getMapNames() throws JMSException {
        Set set = this.mapMessage.keySet();
        return new Vector(set).elements();
    }

    public void setBoolean(String string, boolean bl) throws JMSException {
        this.checkMessageAccess();
        this.checkName(string);
        this.mapMessage.put(string, new Boolean(bl));
    }

    public void setByte(String string, byte by) throws JMSException {
        this.checkMessageAccess();
        this.checkName(string);
        this.mapMessage.put(string, new Byte(by));
    }

    public void setShort(String string, short s) throws JMSException {
        this.checkMessageAccess();
        this.checkName(string);
        this.mapMessage.put(string, new Short(s));
    }

    public void setChar(String string, char c) throws JMSException {
        this.checkMessageAccess();
        this.checkName(string);
        this.mapMessage.put(string, new Character(c));
    }

    public void setInt(String string, int n) throws JMSException {
        this.checkMessageAccess();
        this.checkName(string);
        this.mapMessage.put(string, new Integer(n));
    }

    public void setLong(String string, long l) throws JMSException {
        this.checkMessageAccess();
        this.checkName(string);
        this.mapMessage.put(string, new Long(l));
    }

    public void setFloat(String string, float f) throws JMSException {
        this.checkMessageAccess();
        this.checkName(string);
        this.mapMessage.put(string, new Float(f));
    }

    public void setDouble(String string, double d) throws JMSException {
        this.checkMessageAccess();
        this.checkName(string);
        this.mapMessage.put(string, new Double(d));
    }

    public void setString(String string, String string2) throws JMSException {
        this.checkMessageAccess();
        this.checkName(string);
        this.mapMessage.put(string, string2);
    }

    public void setBytes(String string, byte[] byArray) throws JMSException {
        this.checkMessageAccess();
        this.checkName(string);
        this.mapMessage.put(string, byArray);
    }

    public void setBytes(String string, byte[] byArray, int n, int n2) throws JMSException {
        this.checkMessageAccess();
        this.checkName(string);
        byte[] byArray2 = new byte[n2];
        System.arraycopy(byArray, n, byArray2, 0, n2);
        this.mapMessage.put(string, byArray2);
    }

    public void setObject(String string, Object object) throws JMSException {
        this.checkMessageAccess();
        this.checkName(string);
        this.checkValidObjectType(object);
        this.mapMessage.put(string, object);
    }

    private void checkValidObjectType(Object object) throws MessageFormatException {
        if (!(object instanceof Boolean || object instanceof Byte || object instanceof Short || object instanceof Character || object instanceof Integer || object instanceof Long || object instanceof Float || object instanceof Double || object instanceof String || object instanceof byte[])) {
            String string = AdministeredObject.cr.getKString("C4017");
            throw new MessageFormatException(string, "C4017");
        }
    }

    private void checkName(String string) throws IllegalArgumentException {
        if (string == null || string.length() == 0) {
            throw new IllegalArgumentException("Name MUST NOT be null or empty.");
        }
    }

    public boolean itemExists(String string) throws JMSException {
        return this.mapMessage.containsKey(string);
    }

    public void dump(PrintStream printStream) {
        printStream.println("------ MapMessageImpl dump ------");
        super.dump(printStream);
    }

    public String toString() {
        return super.toString();
    }
}

