/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.util.pool;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.util.pool.ThreadPool;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.JMQTimer;
import com.sun.messaging.jmq.util.timer.JMQTimerTask;
import java.util.Hashtable;

public abstract class BasicRunnable
implements Runnable {
    public static boolean DEBUG = false;
    public static final int B_STAY_RUNNING = 0;
    public static final int B_TIMEOUT_THREAD = 1;
    public static final int B_DESTROY_THREAD = 2;
    protected int behavior = 0;
    public static final int RUN_STARTING = 0;
    public static final int RUN_READY = 1;
    public static final int RUN_PREASSIGNED = 2;
    public static final int RUN_ASSIGNED = 3;
    public static final int RUN_SUSPENDED = 4;
    public static final int RUN_CRITICAL = 5;
    public static final int RUN_DESTROYING = 6;
    public static final int RUN_DESTROYED = 7;
    protected int state = 0;
    boolean suspended = false;
    public static long DEFAULT_TIMEOUT;
    private static long timeout;
    private ThreadExpiration expr = null;
    protected Logger logger = Globals.getLogger();
    protected ThreadPool tctrl;
    protected int id;

    public BasicRunnable(int n, ThreadPool threadPool) {
        this(n, threadPool, 0);
    }

    public BasicRunnable(int n, ThreadPool threadPool, int n2) {
        if (DEBUG) {
            this.logger.log(4, "BasicRunnable: created BasicRunnable {0}:{1}", (Object)String.valueOf(n), threadPool.toString());
        }
        this.tctrl = threadPool;
        this.id = n;
        this.setThreadBehavior(n2);
    }

    public String toString() {
        String string = "BasicRunnable[" + this.id + " , " + BasicRunnable.behaviorToString(this.behavior) + " ," + this.stateToString(this.state) + "]";
        return string;
    }

    public Hashtable getDebugState() {
        Hashtable<String, Object> hashtable = new Hashtable<String, Object>();
        hashtable.put("state", this.stateToString(this.state));
        hashtable.put("behavior", BasicRunnable.behaviorToString(this.behavior));
        hashtable.put("suspended", new Boolean(this.suspended));
        hashtable.put("id", new Integer(this.id));
        return hashtable;
    }

    protected String stateToString(int n) {
        switch (n) {
            case 0: {
                return "RUN_STARTING";
            }
            case 1: {
                if (this.suspended) {
                    return "RUN_READY(suspended)";
                }
                return "RUN_READY ";
            }
            case 2: {
                if (this.suspended) {
                    return "RUN_PREASSIGNED(suspended)";
                }
                return "RUN_PREASSIGNED ";
            }
            case 3: {
                if (this.suspended) {
                    return "RUN_ASSIGNED(suspended)";
                }
                return "RUN_ASSIGNED ";
            }
            case 5: {
                if (this.suspended) {
                    return "RUN_CRITICAL(suspended)";
                }
                return "RUN_CRITICAL ";
            }
            case 6: {
                return "RUN_DESTROYING ";
            }
            case 7: {
                return "RUN_DESTROYED";
            }
        }
        return "RUN_UNKNOWN(" + n + ")";
    }

    protected static String behaviorToString(int n) {
        switch (n) {
            case 0: {
                return "B_STAY_RUNNING";
            }
            case 1: {
                return "B_TIMEOUT_THREAD";
            }
            case 2: {
                return "B_DESTROY_THREAD";
            }
        }
        return "B_UNKNOWN(" + n + ")";
    }

    public synchronized boolean available() {
        return this.state == 1;
    }

    public boolean hasBeenDestroyed() {
        return this.state == 7;
    }

    public synchronized boolean waitOnDestroy(long l) {
        if (this.state >= 7) {
            return true;
        }
        if (this.state < 6) {
            this.destroy();
        }
        while (this.state == 5) {
            try {
                this.wait();
            }
            catch (InterruptedException interruptedException) {
                break;
            }
        }
        return this.hasBeenDestroyed();
    }

    public void suspend() {
        this.suspended = true;
    }

    public void resume() {
        this.suspended = false;
    }

    public synchronized void setState(int n) {
        if (this.state == n) {
            return;
        }
        if (this.state >= 7) {
            return;
        }
        if (this.state >= 6 && n < 6) {
            return;
        }
        if (this.behavior == 1) {
            if (n == 1) {
                this.startTimeout();
            } else {
                this.cancelTimeout();
            }
        }
        this.state = n;
        if (this.state >= 6 || this.state == 3) {
            this.notify();
        }
    }

    public void setThreadBehavior(int n) {
        if (this.behavior == n) {
            return;
        }
        int n2 = this.behavior;
        this.behavior = n;
        if (n2 == 1) {
            this.cancelTimeout();
        } else if (n == 1 && this.state == 1) {
            this.startTimeout();
        } else if (n == 2) {
            this.destroy();
        }
    }

    public synchronized void startTimeout() {
        if (this.behavior != 1) {
            throw new ArrayIndexOutOfBoundsException(Globals.getBrokerResources().getString("B4117", "trying to timeout a non-TIMEOUT thread"));
        }
        if (this.expr != null) {
            this.cancelTimeout();
        }
        JMQTimer jMQTimer = Globals.getTimer();
        this.expr = new ThreadExpiration(this);
        long l = timeout * 1000L;
        try {
            jMQTimer.scheduleAtFixedRate((JMQTimerTask)this.expr, l, l);
        }
        catch (IllegalStateException illegalStateException) {
            this.logger.log(8, "Timer shutting down ", illegalStateException);
        }
    }

    public synchronized void setTimeout(long l) {
    }

    private synchronized void cancelTimeout() {
        if (this.expr == null) {
            return;
        }
        try {
            this.expr.cancel();
        }
        catch (IllegalStateException illegalStateException) {
            this.logger.log(8, "Timer shutting down ", illegalStateException);
        }
        this.expr = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void checkExpiration() {
        BasicRunnable basicRunnable = this;
        synchronized (basicRunnable) {
            if (this.state < 2) {
                this.cancelTimeout();
                this.destroy();
            } else if (this.state > 5) {
                this.cancelTimeout();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void destroy() {
        this.tctrl.runnableDestroying(this.id);
        BasicRunnable basicRunnable = this;
        synchronized (basicRunnable) {
            if (this.state >= 6) {
                return;
            }
            this.setState(6);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void release() {
        BasicRunnable basicRunnable = this;
        synchronized (basicRunnable) {
            this.setState(1);
        }
        this.tctrl.releaseRunnable(this);
    }

    protected synchronized void assigned() {
        this.setState(3);
        this.notify();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilAssigned() {
        BasicRunnable basicRunnable = this;
        synchronized (basicRunnable) {
            while (this.state < 3) {
                try {
                    this.wait();
                }
                catch (InterruptedException interruptedException) {}
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void waitUntilDestroyed(long l) {
        BasicRunnable basicRunnable = this;
        synchronized (basicRunnable) {
            if (this.isCritical()) {
                try {
                    this.wait(l);
                }
                catch (InterruptedException interruptedException) {
                    // empty catch block
                }
            }
        }
    }

    protected boolean isDestroyed() {
        return this.state == 7;
    }

    protected boolean isBusy() {
        return this.state >= 2 && this.state <= 5;
    }

    protected boolean isCritical() {
        return this.state == 5;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void setCritical(boolean bl) {
        this.setState(bl ? 5 : 3);
        if (!bl) {
            BasicRunnable basicRunnable = this;
            synchronized (basicRunnable) {
                this.notify();
            }
        }
    }

    protected abstract void process() throws Exception;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void run() {
        boolean bl = false;
        BasicRunnable basicRunnable = this;
        synchronized (basicRunnable) {
            if (this.state < 1) {
                this.setState(1);
            }
        }
        while (this.state < 6) {
            if (this.suspended) {
                if (DEBUG) {
                    this.logger.log(4, "BasicRunnable: suspending Thread [ {0} ]", String.valueOf(this.id));
                }
                basicRunnable = this;
                synchronized (basicRunnable) {
                    if (this.suspended && this.tctrl.isSuspended()) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            if (this.behavior >= 2 || this.state >= 6) break;
            if (this.state < 3) {
                basicRunnable = this;
                synchronized (basicRunnable) {
                    if (this.state < 3) {
                        try {
                            this.wait();
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                    }
                }
            }
            try {
                this.process();
            }
            catch (Exception exception) {
                if (this.state < 6) {
                    this.tctrl.handleException(exception);
                    break;
                }
                this.logger.log(4, "Exiting", exception);
                break;
            }
        }
        if (this.state < 6) {
            this.destroy();
        }
        basicRunnable = this;
        synchronized (basicRunnable) {
            this.state = 7;
            this.tctrl.runnableExit(this.id);
            this.notify();
        }
    }

    public int getId() {
        return this.id;
    }

    public int hashCode() {
        return this.id;
    }

    public boolean equals(Object object) {
        if (!(object instanceof BasicRunnable)) {
            return false;
        }
        return ((BasicRunnable)object).id == this.id;
    }

    static {
        timeout = DEFAULT_TIMEOUT = (long)Globals.getConfig().getIntProperty("imq.thread.expiration.timeout", 120);
    }

    class ThreadExpiration
    extends JMQTimerTask {
        BasicRunnable hr = null;

        public ThreadExpiration(BasicRunnable basicRunnable2) {
            this.hr = basicRunnable2;
        }

        public void run() {
            this.hr.checkExpiration();
        }
    }
}

