/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service.imq.group;

import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.net.Protocol;
import com.sun.messaging.jmq.jmsserver.service.Service;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQConnection;
import com.sun.messaging.jmq.jmsserver.service.imq.IMQService;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupNotificationInfo;
import com.sun.messaging.jmq.jmsserver.service.imq.group.GroupRunnableFactory;
import com.sun.messaging.jmq.jmsserver.service.imq.group.MapList;
import com.sun.messaging.jmq.jmsserver.service.imq.group.SelectThread;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.pool.RunnableFactory;
import com.sun.messaging.jmq.jmsserver.util.pool.ThreadPool;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.IOException;
import java.io.PrintStream;
import java.util.ArrayList;
import java.util.Hashtable;
import java.util.List;

public class GroupService
extends IMQService {
    public static boolean DEBUG = false;
    private List waitingNewSockets = new ArrayList();
    static MapList serviceReadSelectors = new MapList();
    static MapList serviceWriteSelectors = new MapList();
    static Class readSelectorClass = null;
    static Class writeSelectorClass = null;
    private static final String pkgname = "com.sun.messaging.jmq.jmsserver.service.imq.group.";
    public static int UNLIMITED;
    private static int limit;

    Logger getLogger() {
        return this.logger;
    }

    public GroupService(String string, Protocol protocol, int n, PacketRouter packetRouter, int n2, int n3) {
        super(string, protocol, n, packetRouter, n2, n3);
        this.logger.log(4, "Running Group Service");
        serviceReadSelectors.initializeService(this, n2 / 2 + n2 % 2, limit, readSelectorClass, 1);
        serviceWriteSelectors.initializeService(this, n2 / 2, limit, writeSelectorClass, 4);
    }

    public Hashtable getDebugState() {
        Hashtable hashtable = super.getDebugState();
        hashtable.put("readState", this.getDebugState(true));
        hashtable.put("writeState", this.getDebugState(false));
        return hashtable;
    }

    public void acceptConnection(IMQConnection iMQConnection) throws IOException, BrokerException {
        if (DEBUG) {
            this.logger.log(4, "Adding new Connection {0} ", iMQConnection.toString());
        }
        GroupService.addConnection(this, iMQConnection);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void addConnection(GroupService groupService, IMQConnection iMQConnection) throws IOException {
        Class clazz = GroupService.class;
        synchronized (clazz) {
            SelectThread selectThread = serviceReadSelectors.findThread(groupService);
            SelectThread selectThread2 = serviceWriteSelectors.findThread(groupService);
            if (selectThread == null || selectThread2 == null) {
                throw new IOException(Globals.getBrokerResources().getKString("B3100", " No threads allocated for " + (selectThread == null ? (selectThread2 == null ? "both" : "read") : "write") + " selector thread on service " + groupService + " closing connection " + iMQConnection));
            }
            GroupNotificationInfo groupNotificationInfo = new GroupNotificationInfo();
            groupNotificationInfo.targetThreads(selectThread, selectThread2);
            iMQConnection.attach(groupNotificationInfo);
            selectThread.addNewConnection(iMQConnection);
            selectThread2.addNewConnection(iMQConnection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void destroyService(Service service) {
        Class clazz = GroupService.class;
        synchronized (clazz) {
            serviceReadSelectors.destroy(service);
            serviceWriteSelectors.destroy(service);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void dump(PrintStream printStream) {
        Class clazz = GroupService.class;
        synchronized (clazz) {
        }
    }

    public RunnableFactory getRunnableFactory() {
        return new GroupRunnableFactory();
    }

    ThreadPool getPool() {
        return this.pool;
    }

    public Hashtable getDebugState(boolean bl) {
        if (bl) {
            if (serviceReadSelectors == null) {
                Hashtable<String, String> hashtable = new Hashtable<String, String>();
                hashtable.put("serviceReadSelectors", "null");
                return hashtable;
            }
            return serviceReadSelectors.getDebugState(this);
        }
        if (serviceWriteSelectors == null) {
            Hashtable<String, String> hashtable = new Hashtable<String, String>();
            hashtable.put("serviceWriteSelectors", "null");
            return hashtable;
        }
        return serviceWriteSelectors.getDebugState(this);
    }

    static {
        try {
            readSelectorClass = Class.forName("com.sun.messaging.jmq.jmsserver.service.imq.group.ReadThread");
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(32, "B3100", "unable to create class for handling READ selectors.", (Throwable)exception);
        }
        try {
            writeSelectorClass = Class.forName("com.sun.messaging.jmq.jmsserver.service.imq.group.WriteThread");
        }
        catch (Exception exception) {
            Globals.getLogger().logStack(32, "B3100", "unable to create class for handling WRITE selectors.", (Throwable)exception);
        }
        UNLIMITED = -1;
        limit = Globals.getConfig().getIntProperty("imq.shared.connectionMonitor_limit", 64);
    }
}

