/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.service;

import com.sun.messaging.jmq.io.MQAddress;
import com.sun.messaging.jmq.io.PortMapperEntry;
import com.sun.messaging.jmq.io.PortMapperTable;
import com.sun.messaging.jmq.jmsserver.Broker;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerStatus;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterListener;
import com.sun.messaging.jmq.jmsserver.cluster.ClusterManager;
import com.sun.messaging.jmq.jmsserver.cluster.ClusteredBroker;
import com.sun.messaging.jmq.jmsserver.cluster.ha.HAClusteredBroker;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.data.AutoRollbackType;
import com.sun.messaging.jmq.jmsserver.data.PacketRouter;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.data.handlers.TransactionHandler;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverLockException;
import com.sun.messaging.jmq.jmsserver.persist.TakeoverStoreInfo;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.JMQXid;
import com.sun.messaging.jmq.util.UID;
import com.sun.messaging.jmq.util.log.Logger;
import com.sun.messaging.jmq.util.timer.JMQTimer;
import com.sun.messaging.jmq.util.timer.JMQTimerTask;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.Socket;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.WeakHashMap;

public class HAMonitorService
implements ClusterListener {
    private Logger logger = Globals.getLogger();
    private int MAX_MONITOR = Globals.getConfig().getIntProperty("imq.cluster.monitor.threshold", 2);
    private int monitorTimeout = Globals.getConfig().getIntProperty("imq.cluster.monitor.interval", 30) * 1000;
    private int reaperTimeout = Globals.getConfig().getIntProperty("imq.cluster.reaptime", 300) * 1000;
    ClusterManager clusterconfig = null;
    String mybrokerid = null;
    private HAMonitorTask haMonitor = null;
    Map indoubtBrokers = Collections.synchronizedMap(new LinkedHashMap());
    Runnable takeoverRunnable = null;

    public HAMonitorService(String string, MQAddress mQAddress) throws IllegalStateException, BrokerException, IllegalAccessException {
        Object object;
        Object object2;
        Object object3;
        Object object4;
        Object object5;
        this.clusterconfig = Globals.getClusterManager();
        this.clusterconfig.addEventListener(this);
        this.mybrokerid = this.clusterconfig.getLocalBroker().getBrokerName();
        this.logger.log(8, "B1206", (Object)this.mybrokerid, mQAddress);
        if (!string.equals(this.clusterconfig.getClusterId())) {
            this.logger.log(32, "B3201", (Object)string, this.clusterconfig.getClusterId());
            throw new IllegalStateException("Bad Cluster ID " + string);
        }
        HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)this.clusterconfig.getLocalBroker();
        MQAddress mQAddress2 = hAClusteredBroker.getBrokerURL();
        if (!mQAddress2.equals(mQAddress)) {
            this.logger.log(8, "B1207", (Object)this.mybrokerid, mQAddress);
            try {
                object5 = String.valueOf(101) + "\n";
                object4 = new PortMapperTable();
                object3 = new Socket(mQAddress2.getHostName(), mQAddress2.getPort());
                object2 = ((Socket)object3).getInputStream();
                object = ((Socket)object3).getOutputStream();
                try {
                    ((OutputStream)object).write(((String)object5).getBytes());
                    ((OutputStream)object).flush();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
                ((PortMapperTable)object4).read((InputStream)object2);
                ((InputStream)object2).close();
                ((OutputStream)object).close();
                ((Socket)object3).close();
                PortMapperEntry portMapperEntry = ((PortMapperTable)object4).get("portmapper");
                String string2 = portMapperEntry.getProperty("brokerid");
                if (this.mybrokerid.equals(string2)) {
                    this.logger.log(32, "B3202", this.mybrokerid);
                    Broker.getBroker().exit(1, Globals.getBrokerResources().getKString("B3202", this.mybrokerid), 2);
                }
            }
            catch (IOException iOException) {
                this.logger.log(4, "Unable to reach old remote broker associated with " + this.mybrokerid);
            }
            hAClusteredBroker.setBrokerURL(mQAddress);
        }
        object5 = hAClusteredBroker.getState();
        object4 = hAClusteredBroker.getTakeoverBroker();
        if ((object5 == BrokerState.FAILOVER_STARTED || object5 == BrokerState.FAILOVER_PENDING) && object4 != null && ((String)object4).trim().length() != 0) {
            this.logger.log(16, "B2134", (Object)this.mybrokerid, object4);
            object5 = hAClusteredBroker.getState();
            do {
                this.logger.log(8, "B1208");
                try {
                    Thread.currentThread();
                    Thread.sleep(10000L);
                }
                catch (InterruptedException interruptedException) {
                    break;
                }
            } while ((object5 = hAClusteredBroker.getState()) == BrokerState.FAILOVER_STARTED || object5 == BrokerState.FAILOVER_PENDING);
        }
        object3 = this.clusterconfig.getConfigBrokers();
        while (object3.hasNext()) {
            object2 = (HAClusteredBroker)object3.next();
            object = object2.getTakeoverBroker();
            if (object == null || !((String)object).equals(this.mybrokerid) || object2.getState() != BrokerState.FAILOVER_STARTED) continue;
            this.logger.log(8, "B1209", object2.getBrokerName());
            object2.setState(BrokerState.FAILOVER_COMPLETE);
        }
        hAClusteredBroker.setState(BrokerState.OPERATING);
        this.haMonitor = new HAMonitorTask();
        try {
            new HATimerThread("HAMonitor", this.haMonitor, this.monitorTimeout, this.monitorTimeout);
        }
        catch (Exception exception) {
            this.logger.log(16, "B3100", (Object)"Unable to start monitor Timeout", (Throwable)exception);
        }
    }

    public int getMonitorInterval() {
        return this.monitorTimeout / 1000;
    }

    public UID getStoreSession() {
        return ((HAClusteredBroker)this.clusterconfig.getLocalBroker()).getStoreSessionUID();
    }

    public String toString() {
        return "HAMonitorService[" + this.clusterconfig.getLocalBroker() + "]";
    }

    public void monitor() {
        Object object;
        Object object2;
        HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)this.clusterconfig.getLocalBroker();
        this.logger.log(4, "HAMonitor is updating timestamp state of [" + this.mybrokerid + "]");
        try {
            hAClusteredBroker.updateHeartbeat();
        }
        catch (BrokerException brokerException) {
            this.logger.log(32, "B3203", brokerException);
            Broker.getBroker().exit(Globals.getBrokerStateHandler().getRestartCode(), Globals.getBrokerResources().getKString("B3203"), 1);
        }
        try {
            object2 = hAClusteredBroker.getState();
            if (object2 == BrokerState.QUIESCE_STARTED || object2 == BrokerState.QUIESCE_COMPLETED || object2 == BrokerState.FAILOVER_PENDING || object2 == BrokerState.FAILOVER_FAILED || object2 == BrokerState.SHUTDOWN_STARTED || object2 == BrokerState.SHUTDOWN_FAILOVER || object2 == BrokerState.SHUTDOWN_COMPLETE) {
                return;
            }
        }
        catch (BrokerException brokerException) {
            this.logger.logStack(16, "B3100", "unable to access state", (Throwable)brokerException);
        }
        if (this.indoubtBrokers.size() > 0) {
            this.logger.log(8, "B1210", String.valueOf(this.indoubtBrokers.size()));
        }
        object2 = null;
        HashSet hashSet = new HashSet(this.indoubtBrokers.keySet());
        Iterator iterator = hashSet.iterator();
        while (iterator.hasNext()) {
            object = iterator.next();
            indoubtData indoubtData2 = (indoubtData)this.indoubtBrokers.get(object);
            try {
                HAClusteredBroker hAClusteredBroker2 = (HAClusteredBroker)this.clusterconfig.getBroker(indoubtData2.brokerid);
                long l = hAClusteredBroker2.getHeartbeat();
                if (hAClusteredBroker2.getState() == BrokerState.SHUTDOWN_COMPLETE) {
                    this.logger.log(8, "B1211", indoubtData2.brokerid);
                    hAClusteredBroker2.setBrokerIsUp(false, null);
                    this.indoubtBrokers.remove(object);
                    iterator.remove();
                    continue;
                }
                if (hAClusteredBroker2.getState() == BrokerState.FAILOVER_STARTED || hAClusteredBroker2.getState() == BrokerState.FAILOVER_COMPLETE) {
                    this.logger.log(8, "B1212", indoubtData2.brokerid);
                    hAClusteredBroker2.setBrokerIsUp(false, null);
                    this.indoubtBrokers.remove(object);
                    iterator.remove();
                    continue;
                }
                if (l > indoubtData2.lastts && hAClusteredBroker2.getState() != BrokerState.FAILOVER_PENDING) {
                    this.logger.log(8, "B1213", hAClusteredBroker2.getBrokerName());
                    hAClusteredBroker2.setBrokerInDoubt(false, null);
                    this.indoubtBrokers.remove(object);
                    iterator.remove();
                    continue;
                }
                ++indoubtData2.monitorCnt;
                if (indoubtData2.monitorCnt > this.MAX_MONITOR || hAClusteredBroker2.getState() == BrokerState.SHUTDOWN_FAILOVER) {
                    this.logger.log(8, "B1214", hAClusteredBroker2.getBrokerName());
                    if (object2 == null) {
                        object2 = new ArrayList();
                    }
                    ((ArrayList)object2).add(hAClusteredBroker2);
                    hAClusteredBroker2.setBrokerIsUp(false, null);
                    iterator.remove();
                    this.indoubtBrokers.remove(object);
                    continue;
                }
                this.logger.log(8, "B1215", hAClusteredBroker2.getBrokerName());
            }
            catch (Exception exception) {
                this.logger.logStack(8, "B3100", "Unable to monitor broker " + indoubtData2.brokerid, (Throwable)exception);
            }
        }
        if (object2 != null && this.takeoverRunnable == null) {
            this.takeoverRunnable = new TakeoverThread((ArrayList)object2);
            object = new Thread(this.takeoverRunnable, "Takeover");
            ((Thread)object).start();
        } else if (this.takeoverRunnable != null) {
            this.logger.log(4, "Pausing to takeover broker until  previous broker takeover completes");
        }
    }

    public void brokerDown(BrokerAddress brokerAddress) throws BrokerException {
        this.logger.log(4, "Processing brokerDown for " + brokerAddress);
        List list = Globals.getTransactionList().getRemoteBrokers(brokerAddress);
        if (list == null) {
            this.logger.log(4, "XXX - No txns to process " + brokerAddress);
            return;
        }
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            TransactionUID transactionUID = (TransactionUID)iterator.next();
            this.logger.log(4, "Processing tuid " + transactionUID + " from " + brokerAddress);
            TransactionState transactionState = Globals.getStore().getTransactionState(transactionUID);
            switch (transactionState.getState()) {
                case 0: 
                case 1: 
                case 2: 
                case 3: 
                case 4: 
                case 7: {
                    Globals.getTransactionList().rollbackRemoteTxn(transactionUID);
                    break;
                }
                case 5: {
                    break;
                }
                case 6: {
                    Globals.getTransactionList().commitRemoteTxn(transactionUID);
                }
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void watchBroker(String string) throws BrokerException {
        Map map = this.indoubtBrokers;
        synchronized (map) {
            if (this.indoubtBrokers.get(string) != null) {
                return;
            }
            indoubtData indoubtData2 = new indoubtData();
            indoubtData2.brokerid = string;
            indoubtData2.lastts = ((HAClusteredBroker)this.clusterconfig.getBroker(string)).getHeartbeat();
            indoubtData2.monitorCnt = 0;
            this.indoubtBrokers.put(string, indoubtData2);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void stopWatchingBroker(String string) {
        Map map = this.indoubtBrokers;
        synchronized (map) {
            this.indoubtBrokers.remove(string);
        }
    }

    public void clusterPropertyChanged(String string, String string2) {
    }

    public void brokerAdded(ClusteredBroker clusteredBroker, UID uID) {
    }

    public void brokerRemoved(ClusteredBroker clusteredBroker, UID uID) {
    }

    public void masterBrokerChanged(ClusteredBroker clusteredBroker, ClusteredBroker clusteredBroker2) {
    }

    public void brokerStatusChanged(String string, int n, int n2, UID uID, Object object) {
        this.logger.log(4, "brokerStatusChanged " + string + ":" + "\n\t" + BrokerStatus.toString(n) + "\n\t" + BrokerStatus.toString(n2) + "\n\t" + object);
        if (BrokerStatus.getBrokerInDoubt(n2) && BrokerStatus.getBrokerIsUp(n2)) {
            ClusteredBroker clusteredBroker = this.clusterconfig.getBroker(string);
            if (clusteredBroker.isLocalBroker()) {
                return;
            }
            try {
                if (clusteredBroker.getState() == BrokerState.SHUTDOWN_COMPLETE || clusteredBroker.getState() == BrokerState.FAILOVER_COMPLETE) {
                    this.logger.log(8, "B1213", clusteredBroker.getBrokerName());
                    clusteredBroker.setBrokerIsUp(false, null);
                    return;
                }
                this.logger.log(8, "B1214", string);
                this.watchBroker(string);
            }
            catch (Exception exception) {
                this.logger.logStack(8, "B3100", "Unable to monitor broker " + string, (Throwable)exception);
            }
        } else if (BrokerStatus.getBrokerInDoubt(n) && BrokerStatus.getBrokerIsUp(n2)) {
            this.stopWatchingBroker(string);
        }
    }

    public void brokerStateChanged(String string, BrokerState brokerState, BrokerState brokerState2) {
        ClusteredBroker clusteredBroker = this.clusterconfig.getBroker(string);
        if (clusteredBroker.isLocalBroker() && (brokerState2 == BrokerState.SHUTDOWN_COMPLETE || brokerState2 == BrokerState.SHUTDOWN_FAILOVER)) {
            this.haMonitor.cancel();
            this.clusterconfig.removeEventListener(this);
        }
    }

    public void brokerVersionChanged(String string, int n, int n2) {
    }

    public void brokerURLChanged(String string, MQAddress mQAddress, MQAddress mQAddress2) {
    }

    class TakeoverThread
    implements Runnable {
        ArrayList downBkrs = null;

        public TakeoverThread(ArrayList arrayList) {
            this.downBkrs = arrayList;
        }

        public void run() {
            Iterator iterator = this.downBkrs.iterator();
            while (iterator.hasNext()) {
                Object object;
                Object object2;
                Object object3;
                HAClusteredBroker hAClusteredBroker = (HAClusteredBroker)iterator.next();
                HAMonitorService.this.logger.log(8, "B1216", hAClusteredBroker.getBrokerName());
                try {
                    Object object4;
                    boolean bl;
                    Object object5;
                    Object object6;
                    TakeoverStoreInfo takeoverStoreInfo = hAClusteredBroker.takeover(false);
                    HAMonitorService.this.logger.log(8, "B1217", hAClusteredBroker.getBrokerName());
                    object3 = takeoverStoreInfo.getDestinationList();
                    object2 = takeoverStoreInfo.getMessageList();
                    object = takeoverStoreInfo.getTransactionList();
                    HAMonitorService.this.logger.log(8, "B1218", (Object)hAClusteredBroker.getBrokerName(), String.valueOf(object == null ? 0 : object.size()));
                    ArrayList<Object> arrayList = new ArrayList<Object>();
                    Iterator iterator2 = object.iterator();
                    while (iterator2.hasNext()) {
                        Object[] objectArray;
                        object6 = Globals.getPacketRouter(0);
                        object5 = (TransactionHandler)((PacketRouter)object6).getHandler(48);
                        bl = false;
                        object4 = (TransactionUID)iterator2.next();
                        JMQXid jMQXid = Globals.getTransactionList().UIDToXid((TransactionUID)object4);
                        TransactionState transactionState = Globals.getStore().getTransactionState((TransactionUID)object4);
                        if (transactionState == null) {
                            iterator2.remove();
                            continue;
                        }
                        AutoRollbackType autoRollbackType = transactionState.getType();
                        int n = transactionState.getState();
                        if (transactionState.getState() == 7) {
                            HAMonitorService.this.logger.log(8, "XXX - DEBUG Rolling back  transaction " + object4);
                            arrayList.add(object4);
                            continue;
                        }
                        if (transactionState.getState() == 6) {
                            HAMonitorService.this.logger.log(8, "XXX - DEBUG Committing  transaction " + object4);
                            arrayList.add(object4);
                            continue;
                        }
                        if (transactionState.getType() == AutoRollbackType.ALL) {
                            Object[] objectArray2 = new String[3];
                            objectArray2[0] = hAClusteredBroker.getBrokerName();
                            objectArray2[1] = String.valueOf(((UID)object4).longValue());
                            objectArray2[2] = TransactionState.toString(transactionState.getState());
                            objectArray = objectArray2;
                            HAMonitorService.this.logger.log(8, "B1220", objectArray);
                            transactionState.setState(7);
                            try {
                                Globals.getStore().updateTransactionState((TransactionUID)object4, transactionState, Destination.PERSIST_SYNC);
                            }
                            catch (IOException iOException) {
                                throw new BrokerException(null, iOException);
                            }
                            arrayList.add(object4);
                            continue;
                        }
                        if (transactionState.getType() != AutoRollbackType.NOT_PREPARED || transactionState.getState() >= 5) continue;
                        String[] stringArray = new String[3];
                        stringArray[0] = hAClusteredBroker.getBrokerName();
                        stringArray[1] = String.valueOf(((UID)object4).longValue());
                        stringArray[2] = TransactionState.toString(transactionState.getState());
                        objectArray = stringArray;
                        HAMonitorService.this.logger.log(8, "B1219", objectArray);
                        transactionState.setState(7);
                        try {
                            Globals.getStore().updateTransactionState((TransactionUID)object4, transactionState, Destination.PERSIST_SYNC);
                        }
                        catch (IOException iOException) {
                            throw new BrokerException(null, iOException);
                        }
                        arrayList.add(object4);
                    }
                    object6 = new TakeoverReaper(hAClusteredBroker.getBrokerName(), arrayList, (List)object3);
                    object5 = Globals.getTransactionList().loadTakeoverTxns((List)object);
                    HAMonitorService.this.logger.log(8, "B1221", (Object)hAClusteredBroker.getBrokerName(), String.valueOf(object2 == null ? 0 : object2.size()));
                    Destination.loadTakeoverMsgs((List)object2, (List)object, (Map)object5);
                    bl = ((TakeoverReaper)object6).processTxns();
                    HAMonitorService.this.logger.log(8, "B1222", (Object)hAClusteredBroker.getBrokerName(), String.valueOf(object3 == null ? 0 : object3.size()));
                    object4 = Globals.getTimer();
                    try {
                        if (!bl) {
                            ((JMQTimer)object4).schedule((JMQTimerTask)object6, HAMonitorService.this.reaperTimeout, (long)HAMonitorService.this.reaperTimeout);
                        }
                    }
                    catch (IllegalStateException illegalStateException) {
                        illegalStateException.printStackTrace();
                        HAMonitorService.this.logger.log(16, "B3100", (Object)"Unable to start reaper", (Throwable)illegalStateException);
                    }
                    hAClusteredBroker.setBrokerIsUp(false, null);
                    hAClusteredBroker.setState(BrokerState.FAILOVER_COMPLETE);
                    Logger logger = HAMonitorService.this.logger;
                    HAMonitorService.this.logger;
                    logger.log(8, "B1223", hAClusteredBroker.getBrokerName());
                    iterator.remove();
                }
                catch (Exception exception) {
                    if (exception instanceof TakeoverLockException) {
                        object3 = null;
                        object2 = null;
                        object = ((TakeoverLockException)exception).getBrokerInfo();
                        if (object == null) {
                            try {
                                object3 = hAClusteredBroker.getState();
                                object2 = hAClusteredBroker.getTakeoverBroker();
                            }
                            catch (BrokerException brokerException) {}
                        } else {
                            object3 = BrokerState.getState(((HABrokerInfo)object).getState());
                            object2 = ((HABrokerInfo)object).getTakeoverBrokerID();
                        }
                        if (object3 == BrokerState.FAILOVER_STARTED || object3 == BrokerState.FAILOVER_PENDING || object3 == BrokerState.FAILOVER_COMPLETE) {
                            HAMonitorService.this.logger.log(8, "XXX Unable to takeover broker " + hAClusteredBroker.getBrokerName() + ", broker is being taken over or was taken over by " + (String)object2);
                        } else {
                            HAMonitorService.this.logger.log(8, "XXX Unable to takeover broker " + hAClusteredBroker.getBrokerName() + " due to takeover lock error (state=" + object3 + ", takeoverBroker=" + (String)object2 + ")");
                        }
                        try {
                            hAClusteredBroker.setState(BrokerState.FAILOVER_FAILED);
                        }
                        catch (Exception exception2) {
                            HAMonitorService.this.logger.logStack(32, "XXX Internal Error:", exception2);
                        }
                    } else if (exception instanceof BrokerException && ((BrokerException)exception).getStatusCode() == 409) {
                        HAMonitorService.this.logger.log(8, exception.getMessage());
                    } else {
                        HAMonitorService.this.logger.logStack(32, "XXX Internal Error: Unable to takeover broker " + hAClusteredBroker.getBrokerName(), exception);
                    }
                    hAClusteredBroker.setBrokerIsUp(false, null);
                }
            }
            HAMonitorService.this.takeoverRunnable = null;
        }
    }

    class TakeoverReaper
    extends JMQTimerTask {
        List txns = null;
        List dsts = null;
        Map dstttl = null;
        String id = null;
        long time = 0L;

        public TakeoverReaper(String string, List list, List list2) {
            this.txns = list;
            this.dsts = list2;
            this.id = string;
            this.dstttl = new WeakHashMap();
            try {
                Logger logger = HAMonitorService.this.logger;
                HAMonitorService.this.logger;
                logger.log(4, "monitoring " + list.size() + " transactions");
                Logger logger2 = HAMonitorService.this.logger;
                HAMonitorService.this.logger;
                logger2.log(4, "monitoring " + list2.size() + " destinations");
                this.dstttl = new WeakHashMap();
                Iterator iterator = list2.iterator();
                while (iterator.hasNext()) {
                    Destination destination = (Destination)iterator.next();
                    long l = Globals.getStore().getDestinationConnectedTime(destination);
                    this.dstttl.put(destination, new Long(l));
                }
            }
            catch (Exception exception) {
                HAMonitorService.this.logger.logStack(16, "B3100", "reaping destinations", (Throwable)exception);
            }
        }

        public void run() {
            boolean bl = this.processTxns();
            if (bl) {
                this.cancel();
            }
        }

        public boolean processTxns() {
            Logger logger = HAMonitorService.this.logger;
            HAMonitorService.this.logger;
            logger.log(8, "B1224", this.id);
            try {
                Serializable serializable;
                Iterator iterator = this.txns.iterator();
                while (iterator.hasNext()) {
                    Object object;
                    serializable = (TransactionUID)iterator.next();
                    TransactionState transactionState = null;
                    try {
                        transactionState = Globals.getStore().getTransactionState((TransactionUID)serializable);
                    }
                    catch (BrokerException brokerException) {
                        Globals.getTransactionList().removeTransactionAck((TransactionUID)serializable);
                        Globals.getTransactionList().removeTransactionID((TransactionUID)serializable);
                        iterator.remove();
                        continue;
                    }
                    int n = transactionState.getState();
                    int n2 = 0;
                    int n3 = 0;
                    try {
                        object = Globals.getStore().getTransactionUsageInfo((TransactionUID)serializable);
                        n2 = object[0];
                        n3 = object[1];
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                    if (n != 7 && n != 5 && n != 6 || n2 == 0 && n3 == 0) {
                        HAMonitorService.this.logger.log(4, "Removing finished transaction " + serializable);
                        object = (TransactionHandler)Globals.getPacketRouter(0).getHandler(48);
                        ((TransactionHandler)object).doRollback((TransactionUID)serializable, null, null, transactionState, null, null);
                        iterator.remove();
                        continue;
                    }
                    if (n != 7) continue;
                }
                iterator = this.dsts.iterator();
                while (iterator.hasNext()) {
                    serializable = (Destination)iterator.next();
                    long l = Globals.getStore().getDestinationConnectedTime((Destination)serializable);
                    Long l2 = (Long)this.dstttl.get(serializable);
                    if (l2 != null && l2 == l) {
                        Globals.getStore().removeDestination((Destination)serializable, true);
                    }
                    iterator.remove();
                }
                Logger logger2 = HAMonitorService.this.logger;
                HAMonitorService.this.logger;
                logger2.log(8, "B1225", this.id);
            }
            catch (Exception exception) {
                HAMonitorService.this.logger.logStack(16, "B3100", "removing reaped destinations", (Throwable)exception);
            }
            return this.dsts.size() == 0 && this.txns.size() == 0;
        }
    }

    class HATimerThread
    implements Runnable {
        long nexttime = 0L;
        long repeatItr = 0L;
        Thread thr = null;
        Runnable child = null;

        public HATimerThread(String string, Runnable runnable, int n, int n2) {
            this.nexttime = (long)n + System.currentTimeMillis();
            this.repeatItr = n2;
            this.child = runnable;
            this.thr = new Thread((Runnable)this, string);
            this.thr.setPriority(10);
            this.thr.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void run() {
            while (true) {
                long l = System.currentTimeMillis();
                HATimerThread hATimerThread = this;
                synchronized (hATimerThread) {
                    if (l < this.nexttime) {
                        try {
                            this.wait(this.nexttime - l);
                        }
                        catch (InterruptedException interruptedException) {
                            // empty catch block
                        }
                        continue;
                    }
                    this.child.run();
                }
                if (this.repeatItr == 0L) break;
                this.nexttime += this.repeatItr;
            }
        }
    }

    class HAMonitorTask
    implements Runnable {
        boolean valid = true;

        public void cancel() {
            this.valid = false;
        }

        public void run() {
            if (!this.valid) {
                return;
            }
            HAMonitorService.this.monitor();
        }
    }

    class indoubtData {
        String brokerid;
        long lastts = 0L;
        int monitorCnt = 0;

        indoubtData() {
        }
    }
}

