/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.ConsumerStateDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.MessageDAOImpl;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import java.io.ByteArrayOutputStream;
import java.io.DataOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.sql.Blob;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;

class OracleMessageDAOImpl
extends MessageDAOImpl {
    OracleMessageDAOImpl() throws BrokerException {
        this.insertSQL = new StringBuffer(128).append("INSERT INTO ").append(this.tableName).append(" ( ").append("ID").append(", ").append("MESSAGE_SIZE").append(", ").append("BROKER_ID").append(", ").append("DESTINATION_ID").append(", ").append("TRANSACTION_ID").append(", ").append("CREATED_TS").append(", ").append("SYSMESSAGE_ID").append(", ").append("MESSAGE").append(") VALUES ( ?, ?, ?, ?, ?, ?, ?, EMPTY_BLOB() )").toString();
        this.updateDestinationSQL = new StringBuffer(128).append("UPDATE ").append(this.tableName).append(" SET ").append("DESTINATION_ID").append(" = ?, ").append("MESSAGE_SIZE").append(" = ? ").append(" WHERE ").append("ID").append(" = ?").toString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void insert(Connection connection, Packet packet, ConsumerUID[] consumerUIDArray, int[] nArray, String string, long l, boolean bl) throws BrokerException {
        block21: {
            PreparedStatement preparedStatement;
            block19: {
                DBManager dBManager;
                boolean bl2;
                block17: {
                    block20: {
                        block18: {
                            bl2 = false;
                            preparedStatement = null;
                            try {
                                dBManager = DBManager.getDBManager();
                                if (dBManager.isOracleDriver()) break block17;
                                super.insert(connection, packet, consumerUIDArray, nArray, string, l, bl);
                                if (!bl2) break block18;
                            }
                            catch (Throwable throwable) {
                                if (bl2) {
                                    Util.close(null, preparedStatement, connection);
                                } else {
                                    Util.close(null, preparedStatement, null);
                                }
                                throw throwable;
                            }
                            Util.close(null, preparedStatement, connection);
                            break block20;
                        }
                        Util.close(null, preparedStatement, null);
                    }
                    return;
                }
                if (connection == null) {
                    connection = dBManager.getConnection(false);
                    bl2 = true;
                }
                SysMessageID sysMessageID = packet.getSysMessageID();
                String string2 = sysMessageID.getUniqueName();
                String string3 = DestinationUID.getUniqueString(packet.getDestination(), packet.getIsQueue());
                int n = packet.getPacketSize();
                long l2 = packet.getTransactionID();
                if (bl) {
                    if (this.hasMessage(connection, string2)) {
                        throw new BrokerException(this.br.getKString("B3008", string2));
                    }
                    dBManager.getDAOFactory().getDestinationDAO().checkDestination(connection, string3);
                }
                if (string == null) {
                    string = dBManager.getBrokerID();
                }
                String string4 = this.insertSQL;
                try {
                    ByteArrayOutputStream byteArrayOutputStream = new ByteArrayOutputStream(32);
                    DataOutputStream dataOutputStream = new DataOutputStream(byteArrayOutputStream);
                    sysMessageID.writeID(dataOutputStream);
                    dataOutputStream.flush();
                    byteArrayOutputStream.flush();
                    byte[] byArray = byteArrayOutputStream.toByteArray();
                    dataOutputStream.close();
                    byteArrayOutputStream.close();
                    preparedStatement = connection.prepareStatement(string4);
                    preparedStatement.setString(1, string2);
                    preparedStatement.setInt(2, n);
                    preparedStatement.setString(3, string);
                    preparedStatement.setString(4, string3);
                    Util.setLong(preparedStatement, 5, l2 == 0L ? -1L : l2);
                    preparedStatement.setLong(6, l);
                    preparedStatement.setBytes(7, byArray);
                    preparedStatement.executeUpdate();
                    preparedStatement.close();
                    string4 = this.selectForUpdateSQL;
                    preparedStatement = connection.prepareStatement(string4);
                    preparedStatement.setString(1, string2);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    resultSet.next();
                    Blob blob = resultSet.getBlob(1);
                    resultSet.close();
                    preparedStatement.close();
                    OutputStream outputStream = Util.OracleBLOB_getBinaryOutputStream(blob);
                    packet.writePacket(outputStream);
                    outputStream.close();
                    if (consumerUIDArray != null) {
                        dBManager.getDAOFactory().getConsumerStateDAO().insert(connection, sysMessageID, consumerUIDArray, nArray, false);
                    }
                    if (bl2) {
                        connection.commit();
                    }
                }
                catch (Exception exception) {
                    try {
                        if (connection != null && !connection.getAutoCommit()) {
                            connection.rollback();
                        }
                    }
                    catch (SQLException sQLException) {
                        this.logger.log(32, "B4080", sQLException);
                    }
                    if (exception instanceof BrokerException) {
                        throw (BrokerException)exception;
                    }
                    Exception exception2 = exception instanceof IOException ? DBManager.wrapIOException("[" + this.insertSQL + "]", (IOException)exception) : (exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.insertSQL + "]", (SQLException)exception) : exception);
                    throw new BrokerException(this.br.getKString("B4004", string2), exception2);
                }
                if (!bl2) break block19;
                Util.close(null, preparedStatement, connection);
                break block21;
            }
            Util.close(null, preparedStatement, null);
        }
    }

    public void moveMessage(Connection connection, Packet packet, DestinationUID destinationUID, DestinationUID destinationUID2, ConsumerUID[] consumerUIDArray, int[] nArray) throws IOException, BrokerException {
        block19: {
            PreparedStatement preparedStatement;
            block17: {
                DBManager dBManager;
                String string;
                boolean bl;
                int n;
                String string2;
                SysMessageID sysMessageID;
                block15: {
                    block18: {
                        block16: {
                            sysMessageID = (SysMessageID)packet.getSysMessageID().clone();
                            string2 = sysMessageID.getUniqueName();
                            n = packet.getPacketSize();
                            bl = false;
                            preparedStatement = null;
                            string = this.selectForUpdateSQL;
                            dBManager = DBManager.getDBManager();
                            if (dBManager.isOracleDriver()) break block15;
                            super.moveMessage(connection, packet, destinationUID, destinationUID2, consumerUIDArray, nArray);
                            if (!bl) break block16;
                            Util.close(null, preparedStatement, connection);
                            break block18;
                        }
                        Util.close(null, preparedStatement, null);
                    }
                    return;
                }
                try {
                    if (connection == null) {
                        connection = dBManager.getConnection(false);
                        bl = true;
                    }
                    preparedStatement = connection.prepareStatement(string);
                    preparedStatement.setString(1, string2);
                    ResultSet resultSet = preparedStatement.executeQuery();
                    if (!resultSet.next()) {
                        throw new BrokerException(this.br.getKString("B3007", string2), 404);
                    }
                    Blob blob = resultSet.getBlob(1);
                    resultSet.close();
                    preparedStatement.close();
                    OutputStream outputStream = Util.OracleBLOB_getBinaryOutputStream(blob);
                    packet.writePacket(outputStream);
                    outputStream.close();
                    string = this.updateDestinationSQL;
                    preparedStatement = connection.prepareStatement(string);
                    preparedStatement.setString(1, destinationUID2.toString());
                    preparedStatement.setInt(2, n);
                    preparedStatement.setString(3, string2);
                    preparedStatement.executeUpdate();
                    ConsumerStateDAO consumerStateDAO = dBManager.getDAOFactory().getConsumerStateDAO();
                    consumerStateDAO.deleteByMessageID(connection, sysMessageID);
                    if (consumerUIDArray != null || nArray != null) {
                        consumerStateDAO.insert(connection, sysMessageID, consumerUIDArray, nArray, false);
                    }
                    if (bl) {
                        connection.commit();
                    }
                    if (!bl) break block17;
                }
                catch (Exception exception) {
                    try {
                        try {
                            if (connection != null && !connection.getAutoCommit()) {
                                connection.rollback();
                            }
                        }
                        catch (SQLException sQLException) {
                            this.logger.log(32, "B4080", sQLException);
                        }
                        if (exception instanceof BrokerException) {
                            throw (BrokerException)exception;
                        }
                        Exception exception2 = exception instanceof SQLException ? DBManager.wrapSQLException("[" + this.updateDestinationSQL + "]", (SQLException)exception) : exception;
                        Object[] objectArray = new Object[]{string2, destinationUID, destinationUID2};
                        throw new BrokerException(this.br.getKString("B4187", objectArray), exception2);
                    }
                    catch (Throwable throwable) {
                        if (bl) {
                            Util.close(null, preparedStatement, connection);
                        } else {
                            Util.close(null, preparedStatement, null);
                        }
                        throw throwable;
                    }
                }
                Util.close(null, preparedStatement, connection);
                break block19;
            }
            Util.close(null, preparedStatement, null);
        }
    }
}

