/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.persist.jdbc;

import com.sun.messaging.jmq.Version;
import com.sun.messaging.jmq.io.Packet;
import com.sun.messaging.jmq.io.SysMessageID;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.cluster.BrokerState;
import com.sun.messaging.jmq.jmsserver.config.BrokerConfig;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.data.TransactionAcknowledgement;
import com.sun.messaging.jmq.jmsserver.data.TransactionState;
import com.sun.messaging.jmq.jmsserver.data.TransactionUID;
import com.sun.messaging.jmq.jmsserver.persist.HABrokerInfo;
import com.sun.messaging.jmq.jmsserver.persist.Store;
import com.sun.messaging.jmq.jmsserver.persist.StoreManager;
import com.sun.messaging.jmq.jmsserver.persist.file.FileStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BaseDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.BrokerDAO;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DAOFactory;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConnectionPool;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBConstants;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.DBManager;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.JDBCStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeHAStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.UpgradeStore;
import com.sun.messaging.jmq.jmsserver.persist.jdbc.Util;
import com.sun.messaging.jmq.jmsserver.resources.BrokerResources;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.util.StringUtil;
import com.sun.messaging.jmq.util.log.Logger;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStreamReader;
import java.sql.Connection;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;

public class DBTool
implements DBConstants {
    static final String SQLFILEDIR_PROP = "imq.persist.jdbcsqlfile.dirpath";
    static final String SQLFILENAME_PROP = "imq.persist.jdbcsqlfile.name";
    private static int EXTRA_CMD_SPECIFIED = 0;
    private static int BAD_CMD_ARG = 1;
    private static int BAD_OPT = 2;
    private static int BAD_OPT_ARG = 3;
    private static int MISSING_OPT_ARG = 4;
    private static int MISSING_CMD_ARG = 5;
    private static String CMD_NAME = "dbmgrcmd";
    private static String CREATE_ALL_CMD = "createall";
    private static String CREATE_TBL_CMD = "createtbl";
    private static String DELETE_TBL_CMD = "deletetbl";
    private static String RECREATE_TBL_CMD = "recreatetbl";
    private static String REMOVE_BKR_CMD = "removebkr";
    private static String DUMP_CMD = "dump";
    private static String DROPTBL_CMD = "droptbl";
    private static String RESET_CMD = "reset";
    private static String BACKUP_CMD = "backup";
    private static String RESTORE_CMD = "restore";
    private static String UPGRADE_STORE_CMD = "upgradestore";
    private static String UPGRADE_HASTORE_CMD = "upgradehastore";
    private static String QUERY_CMD = "query";
    private static String ARG_NAME = "dbmgrarg";
    private static String CREATE_CMD_STR = "create";
    private static String DELETE_CMD_STR = "delete";
    private static String RECREATE_CMD_STR = "recreate";
    private static String REMOVE_CMD_STR = "remove";
    private static String UPGRADE_CMD_STR = "upgrade";
    private static String ARGU_ALL = "all";
    private static String ARGU_TBL = "tbl";
    private static String ARGU_BKR = "bkr";
    private static String ARGU_OLDTBL = "oldtbl";
    private static String ARGU_LCK = "lck";
    private static String ARGU_STORE = "store";
    private static String ARGU_HASTORE = "hastore";
    private static String OPT_H = "-h";
    private static String OPT_LH = "-help";
    private static String OPT_V = "-v";
    private static String OPT_LV = "-version";
    private static String OPT_B = "-b";
    private static String OPT_N = "-n";
    private static String OPT_U = "-u";
    private static String OPT_P = "-p";
    private static String OPT_PW = "-pw";
    private static String OPT_PASSFILE = "-passfile";
    private static String OPT_D = "-D";
    private static String OPT_VARHOME = "-varhome";
    private static String OPT_VERBOSE = "-verbose";
    private static String OPT_DEBUG = "-debug";
    private static String OPT_DIR = "-dir";
    private static String OPT_FORCE = "-f";
    private static BrokerResources br = Globals.getBrokerResources();
    private static BrokerConfig config;
    private static Logger logger;
    private Version version = new Version();
    private DBManager dbmgr = null;
    private boolean standalone = true;
    private boolean cliPasswdSpecified = false;
    private boolean debugSpecified = false;
    private boolean forceSpecified = false;

    DBTool(boolean bl) {
        this.standalone = bl;
    }

    private void doCreate(boolean bl) throws BrokerException {
        Connection connection = null;
        try {
            if (bl) {
                connection = this.dbmgr.connectToCreate();
                connection.setAutoCommit(true);
            } else {
                connection = this.dbmgr.newConnection(true);
            }
            boolean bl2 = false;
            int n = this.dbmgr.checkStoreExists(connection);
            if (n > 0) {
                throw new BrokerException(br.getKString("B3210"));
            }
            if (n < 0) {
                bl2 = true;
            }
            DBTool.createTables(connection, bl2);
            if (this.standalone) {
                if (Globals.getHAEnabled()) {
                    System.out.println(br.getString("B1165", Globals.getClusterID()));
                } else {
                    System.out.println(br.getString("B1046"));
                }
            }
        }
        catch (Throwable throwable) {
            String string = bl ? this.dbmgr.getCreateDBURL() : this.dbmgr.getOpenDBURL();
            logger.logStack(32, "B3073", string, throwable);
            throw new BrokerException(br.getKString("B3073", string, throwable));
        }
        finally {
            if (!bl && connection != null) {
                try {
                    connection.close();
                }
                catch (SQLException sQLException) {
                    throw new BrokerException(Globals.getBrokerResources().getKString("B3100", "Unable to close JDBC resources", sQLException));
                }
            }
        }
    }

    static void createTables(Connection connection) throws BrokerException {
        DBTool.createTables(connection, false);
    }

    static void createTables(Connection connection, boolean bl) throws BrokerException {
        BaseDAO baseDAO;
        DBManager dBManager = DBManager.getDBManager();
        DAOFactory dAOFactory = dBManager.getDAOFactory();
        Iterator iterator = dAOFactory.getAllDAOs().iterator();
        while (iterator.hasNext()) {
            baseDAO = (BaseDAO)iterator.next();
            try {
                baseDAO.createTable(connection);
            }
            catch (BrokerException brokerException) {
                if (dBManager.checkStoreExists(connection) > 0) {
                    Globals.getLogger().log(16, "B3073", Globals.getBrokerResources().getString("B3210"));
                    bl = true;
                    break;
                }
                if (bl) {
                    Globals.getLogger().log(16, brokerException.toString(), brokerException.getCause());
                    continue;
                }
                throw brokerException;
            }
        }
        baseDAO = dAOFactory.getVersionDAO();
        if (bl) {
            int n = baseDAO.getStoreVersion(connection);
            if (n != 400) {
                baseDAO.insert(connection, 400);
            }
        } else {
            baseDAO.insert(connection, 400);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doReset() throws BrokerException {
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            DBManager.lockTables(connection, false);
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doDelete(String string) throws BrokerException {
        boolean bl = false;
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            if (string == null || string.length() == 0) {
                boolean bl2 = false;
                int n = this.dbmgr.checkStoreExists(connection);
                if (n > 0) {
                    if (Globals.getHAEnabled() && this.dbmgr.isHAClusterActive(connection)) {
                        throw new BrokerException(br.getKString("B3209", this.dbmgr.getClusterID()));
                    }
                    try {
                        if (!this.forceSpecified) {
                            DBManager.lockTables(connection, true);
                        }
                    }
                    catch (BrokerException brokerException) {
                        if (brokerException.getStatusCode() != 404) throw brokerException;
                        bl2 = true;
                    }
                } else {
                    if (n >= 0) throw new BrokerException(br.getKString("B3211"));
                    bl2 = true;
                }
                bl = DBTool.dropTables(connection, null, bl2);
            } else if (string.equals(ARGU_OLDTBL)) {
                int n = -1;
                if (DBTool.checkVersion(connection, "IMQSV37" + this.dbmgr.getBrokerID())) {
                    n = 370;
                } else {
                    if (!DBTool.checkVersion(connection, "IMQSV35" + this.dbmgr.getBrokerID())) throw new BrokerException("Old persistent store (version 370) not found");
                    n = 350;
                }
                bl = DBTool.dropTables(connection, this.dbmgr.getTableNames(n));
            }
            if (!this.standalone) return;
            if (!bl) return;
            if (Globals.getHAEnabled()) {
                System.out.println(br.getString("B1166", Globals.getClusterID()));
                return;
            }
            System.out.println(br.getString("B1051"));
            return;
        }
        catch (BrokerException brokerException) {
            logger.log(32, "B3075", (Object)this.dbmgr.getOpenDBURL(), (Throwable)brokerException);
            throw new BrokerException(br.getKString("B3075", this.dbmgr.getOpenDBURL()), brokerException);
        }
        catch (SQLException sQLException) {
            logger.log(32, "B3075", (Object)this.dbmgr.getOpenDBURL(), (Throwable)sQLException);
            throw new BrokerException(br.getKString("B3075", this.dbmgr.getOpenDBURL()), sQLException);
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    static boolean dropTables(Connection connection, String[] stringArray) throws SQLException, BrokerException {
        return DBTool.dropTables(connection, stringArray, false);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean dropTables(Connection connection, String[] stringArray, boolean bl) throws SQLException, BrokerException {
        boolean bl2 = false;
        try {
            if (stringArray != null && stringArray.length > 0) {
                Statement statement = null;
                try {
                    statement = connection.createStatement();
                    int n = stringArray.length;
                    for (int i = 0; i < n; ++i) {
                        String string = stringArray[i];
                        Globals.getLogger().logToAll(8, br.getString("B1164", string));
                        statement.executeUpdate("DROP TABLE " + string);
                    }
                }
                finally {
                    Util.close(null, statement, null);
                }
            } else {
                DAOFactory dAOFactory = DBManager.getDBManager().getDAOFactory();
                Iterator iterator = dAOFactory.getAllDAOs().iterator();
                while (iterator.hasNext()) {
                    BaseDAO baseDAO = (BaseDAO)iterator.next();
                    try {
                        baseDAO.dropTable(connection);
                    }
                    catch (BrokerException brokerException) {
                        if (bl) {
                            Globals.getLogger().log(16, brokerException.toString(), brokerException.getCause());
                            continue;
                        }
                        throw brokerException;
                    }
                }
            }
            bl2 = true;
        }
        catch (SQLException sQLException) {
            Globals.getLogger().log(32, "B3075", (Object)sQLException.toString(), (Throwable)sQLException);
            throw sQLException;
        }
        catch (BrokerException brokerException) {
            Globals.getLogger().log(32, "B3075", (Object)brokerException.toString(), (Throwable)brokerException);
            throw brokerException;
        }
        return bl2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static boolean checkVersion(Connection connection, String string) throws BrokerException {
        String string2 = "SELECT * FROM " + string;
        Statement statement = null;
        ResultSet resultSet = null;
        try {
            statement = connection.createStatement();
            resultSet = statement.executeQuery(string2);
        }
        catch (SQLException sQLException) {
            boolean bl;
            try {
                bl = false;
            }
            catch (Throwable throwable) {
                Util.close(resultSet, statement, null);
                throw throwable;
            }
            Util.close(resultSet, statement, null);
            return bl;
        }
        Util.close(resultSet, statement, null);
        return true;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private void doRecreate() throws BrokerException {
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            boolean bl = false;
            boolean bl2 = false;
            int n = this.dbmgr.checkStoreExists(connection);
            if (n > 0) {
                if (Globals.getHAEnabled() && this.dbmgr.isHAClusterActive(connection)) {
                    throw new BrokerException(br.getKString("B3209", this.dbmgr.getClusterID()));
                }
                try {
                    if (!this.forceSpecified) {
                        DBManager.lockTables(connection, true);
                    }
                }
                catch (BrokerException brokerException) {
                    if (brokerException.getStatusCode() != 404) throw brokerException;
                    bl2 = true;
                }
            } else if (n < 0) {
                bl2 = true;
            } else {
                bl = true;
            }
            if (!bl) {
                DBTool.dropTables(connection, null, bl2);
            }
            DBTool.createTables(connection, false);
            if (!this.standalone) return;
            if (Globals.getHAEnabled()) {
                System.out.println(br.getString("B1165", Globals.getClusterID()));
                return;
            }
            System.out.println(br.getString("B1046"));
            return;
        }
        catch (Throwable throwable) {
            logger.log(32, "B3076", (Object)this.dbmgr.getOpenDBURL(), throwable);
            throw new BrokerException(br.getKString("B3076", this.dbmgr.getOpenDBURL()), throwable);
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doRemoveBkr() throws BrokerException {
        String string;
        String string2;
        block16: {
            string2 = Globals.getBrokerID();
            Connection connection = null;
            string = null;
            try {
                connection = this.dbmgr.getConnection(true);
                DBManager.lockTables(connection, true);
                try {
                    DAOFactory dAOFactory = this.dbmgr.getDAOFactory();
                    BrokerDAO brokerDAO = dAOFactory.getBrokerDAO();
                    BrokerState brokerState = brokerDAO.getState(connection, string2);
                    if (brokerState == null) {
                        string = br.getString("B3169", string2);
                        string = br.getString("B3182", string2, string);
                        break block16;
                    }
                    if (!brokerState.isActiveState()) {
                        try {
                            connection.setAutoCommit(false);
                            brokerDAO.delete(connection, string2);
                            dAOFactory.getDestinationDAO().deleteAll(connection);
                            dAOFactory.getMessageDAO().deleteAll(connection);
                            dAOFactory.getConsumerStateDAO().deleteAll(connection);
                            dAOFactory.getTransactionDAO().deleteAll(connection);
                            connection.commit();
                            break block16;
                        }
                        finally {
                            connection.setAutoCommit(true);
                        }
                    }
                    string = br.getString("B3182", string2, "broker is still active - " + brokerState);
                }
                finally {
                    DBManager.lockTables(connection, false);
                }
            }
            catch (Exception exception) {
                logger.log(32, "B3183", (Object)string2, (Throwable)exception);
                throw new BrokerException(br.getKString("B3183", string2), exception);
            }
            finally {
                Util.close(null, null, connection);
            }
        }
        if (this.standalone) {
            if (string == null) {
                System.out.println(br.getString("B1167", string2));
            } else {
                System.out.println(string);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doUpgrade(boolean bl) throws BrokerException {
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            if (bl) {
                new UpgradeHAStore().upgradeStore(connection);
            } else {
                JDBCStore jDBCStore = (JDBCStore)StoreManager.getStore();
                int n = -1;
                if (jDBCStore.checkOldStoreVersion(connection, "IMQSV37" + this.dbmgr.getBrokerID(), "STOREVERSION", 370)) {
                    n = 370;
                } else if (jDBCStore.checkOldStoreVersion(connection, "IMQSV35" + this.dbmgr.getBrokerID(), "STOREVERSION", 350)) {
                    n = 350;
                } else {
                    throw new BrokerException("Old persistent store (version 370) not found");
                }
                new UpgradeStore(jDBCStore, n).upgradeStore(connection);
            }
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doDump(String string) throws SQLException, BrokerException {
        int n = 400;
        if (string != null) {
            try {
                n = Integer.parseInt(string);
            }
            catch (NumberFormatException numberFormatException) {
                n = 0;
            }
        }
        String[] stringArray = null;
        if (n != 400 && ((stringArray = this.dbmgr.getTableNames(n)) == null || stringArray.length == 0)) {
            throw new BrokerException("version " + string + " not supported");
        }
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            DBTool.doDump(connection, stringArray);
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    static void doDump(Connection connection, String[] stringArray) throws BrokerException, SQLException {
        if (stringArray != null && stringArray.length > 0) {
            Statement statement = null;
            try {
                statement = connection.createStatement();
                for (int i = 0; i < stringArray.length; ++i) {
                    ResultSet resultSet = null;
                    String string = stringArray[i];
                    String string2 = "SELECT COUNT(*) FROM " + string;
                    try {
                        resultSet = statement.executeQuery(string2);
                        if (resultSet.next()) {
                            System.out.println(string + ": number of row=" + resultSet.getInt(1));
                        }
                        resultSet.close();
                        continue;
                    }
                    catch (SQLException sQLException) {
                        SQLException sQLException2 = DBManager.wrapSQLException("[" + string2 + "]", sQLException);
                        logger.log(32, "failed to dump tables", sQLException2);
                    }
                }
            }
            finally {
                Util.close(null, statement, null);
            }
        } else {
            DAOFactory dAOFactory = DBManager.getDBManager().getDAOFactory();
            Iterator iterator = dAOFactory.getAllDAOs().iterator();
            while (iterator.hasNext()) {
                BaseDAO baseDAO = (BaseDAO)iterator.next();
                System.out.println(baseDAO.getDebugInfo(connection).toString());
            }
        }
    }

    private void doDropTablesByPattern(String string) throws BrokerException {
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            Map map = this.dbmgr.getTableNamesFromDB(connection, string);
            String[] stringArray = map.values().toArray(new String[0]);
            if (stringArray == null || stringArray.length == 0) {
                System.out.println("There were no tables that match the name pattern 'MQ*" + string + "'.");
                return;
            }
            System.out.println("Tables matching the name pattern 'MQ*" + string + "':");
            int n = stringArray.length;
            for (int i = 0; i < n; ++i) {
                System.out.println("\t" + stringArray[i]);
            }
            if (!this.forceSpecified) {
                System.out.println("Remove all tables that match 'MQ*" + string + "'.\nDo you wish to proceed? [y/n] ");
                System.out.flush();
                String string2 = new BufferedReader(new InputStreamReader(System.in)).readLine();
                if (!"y".equalsIgnoreCase(string2) && !"yes".equalsIgnoreCase(string2)) {
                    return;
                }
            }
            DBTool.dropTables(connection, stringArray, true);
        }
        catch (Exception exception) {
            System.err.println("Failed to drop tables by name pattern: " + exception.getMessage());
            throw new BrokerException(br.getKString("B3075", "table name pattern '" + string + "'"), exception);
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    private void doBackup() throws BrokerException {
        Destination[] destinationArray = null;
        Properties properties = System.getProperties();
        Store store = null;
        FileStore fileStore = null;
        if (Globals.getHAEnabled()) {
            try {
                store = StoreManager.getStore();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            throw new BrokerException(br.getKString("B1230", this.dbmgr.getBrokerID()));
        }
        fileStore = new FileStore((String)properties.get("imq.backupdir"), false);
        ((Store)fileStore).clearAll(false);
        try {
            TransactionAcknowledgement[] transactionAcknowledgementArray;
            Object[] objectArray;
            Iterator iterator;
            int n;
            int n2;
            HashMap hashMap = store.getAllBrokerInfos();
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                HABrokerInfo hABrokerInfo = (HABrokerInfo)hashMap.get(iterator2.next());
                ((Store)fileStore).addBrokerInfo(hABrokerInfo.getId(), hABrokerInfo.getTakeoverBrokerID(), hABrokerInfo.getUrl(), BrokerState.getState(hABrokerInfo.getState()), hABrokerInfo.getVersion(), hABrokerInfo.getSessionID(), hABrokerInfo.getHeartbeat());
            }
            destinationArray = store.getAllDestinations();
            for (n2 = 0; n2 < destinationArray.length; ++n2) {
                ((Store)fileStore).storeDestination(destinationArray[n2], false);
            }
            for (n2 = 0; n2 < destinationArray.length; ++n2) {
                Enumeration enumeration = store.messageEnumeration(destinationArray[n2]);
                while (enumeration.hasMoreElements()) {
                    ((Store)fileStore).storeMessage(destinationArray[n2].getDestinationUID(), (Packet)enumeration.nextElement(), false);
                }
            }
            Consumer[] consumerArray = store.getAllInterests();
            for (n = 0; n < consumerArray.length; ++n) {
                ((Store)fileStore).storeInterest(consumerArray[n], false);
            }
            for (n = 0; n < destinationArray.length; ++n) {
                iterator = store.messageEnumeration(destinationArray[n]);
                while (iterator.hasMoreElements()) {
                    objectArray = (Packet)iterator.nextElement();
                    transactionAcknowledgementArray = objectArray.getSysMessageID();
                    DestinationUID destinationUID = destinationArray[n].getDestinationUID();
                    ConsumerUID[] consumerUIDArray = store.getConsumerUIDs(destinationUID, (SysMessageID)transactionAcknowledgementArray);
                    int[] nArray = new int[consumerUIDArray.length];
                    for (int i = 0; i < consumerUIDArray.length; ++i) {
                        nArray[i] = store.getInterestState(destinationUID, (SysMessageID)transactionAcknowledgementArray, consumerUIDArray[i]);
                    }
                    if (consumerUIDArray.length == 0) continue;
                    ((Store)fileStore).storeInterestStates(destinationUID, (SysMessageID)transactionAcknowledgementArray, consumerUIDArray, nArray, false);
                }
            }
            HashMap hashMap2 = store.getAllTransactionStates();
            iterator = hashMap2.keySet().iterator();
            while (iterator.hasNext()) {
                objectArray = iterator.next();
                ((Store)fileStore).storeTransaction((TransactionUID)objectArray, (TransactionState)hashMap2.get(objectArray), false);
            }
            iterator = hashMap2.keySet().iterator();
            while (iterator.hasNext()) {
                objectArray = iterator.next();
                transactionAcknowledgementArray = store.getTransactionAcks((TransactionUID)objectArray);
                for (int i = 0; i < transactionAcknowledgementArray.length; ++i) {
                    ((Store)fileStore).storeTransactionAck((TransactionUID)objectArray, transactionAcknowledgementArray[i], false);
                }
            }
            objectArray = store.getAllConfigRecords();
            for (int i = 0; i < ((ArrayList)objectArray[0]).size(); ++i) {
                ((Store)fileStore).storeConfigChangeRecord((Long)((ArrayList)objectArray[0]).get(i), (byte[])((ArrayList)objectArray[1]).get(i), false);
            }
            String[] stringArray = store.getPropertyNames();
            for (int i = 0; i < stringArray.length; ++i) {
                ((Store)fileStore).updateProperty(stringArray[i], store.getProperty(stringArray[i]), false);
            }
        }
        catch (Exception exception) {
            throw new BrokerException(br.getString("B3124"));
        }
    }

    private void doRestore() throws BrokerException {
        Properties properties = System.getProperties();
        Store store = null;
        Store store2 = null;
        Destination[] destinationArray = null;
        System.out.println("Backup dir : " + properties.get("imq.backupdir"));
        if (Globals.getHAEnabled()) {
            try {
                store2 = new FileStore((String)properties.get("imq.backupdir"), false);
                this.doRecreate();
                store = StoreManager.getStore();
            }
            catch (Exception exception) {
                exception.printStackTrace();
            }
        } else {
            throw new BrokerException(br.getKString("B1230", this.dbmgr.getBrokerID()));
        }
        try {
            TransactionAcknowledgement[] transactionAcknowledgementArray;
            Object[] objectArray;
            Iterator iterator;
            int n;
            int n2;
            HashMap hashMap = store2.getAllBrokerInfos();
            Iterator iterator2 = hashMap.keySet().iterator();
            while (iterator2.hasNext()) {
                HABrokerInfo hABrokerInfo = (HABrokerInfo)hashMap.get(iterator2.next());
                store.addBrokerInfo(hABrokerInfo.getId(), hABrokerInfo.getUrl(), BrokerState.getState(hABrokerInfo.getState()), hABrokerInfo.getVersion(), hABrokerInfo.getSessionID(), hABrokerInfo.getHeartbeat());
                store.updateBrokerInfo(hABrokerInfo.getId(), hABrokerInfo.getTakeoverBrokerID(), hABrokerInfo.getUrl(), hABrokerInfo.getVersion(), BrokerState.getState(hABrokerInfo.getState()), hABrokerInfo.getSessionID());
            }
            destinationArray = store2.getAllDestinations();
            for (n2 = 0; n2 < destinationArray.length; ++n2) {
                store.storeDestination(destinationArray[n2], false);
            }
            for (n2 = 0; n2 < destinationArray.length; ++n2) {
                Enumeration enumeration = store2.messageEnumeration(destinationArray[n2]);
                while (enumeration.hasMoreElements()) {
                    store.storeMessage(destinationArray[n2].getDestinationUID(), (Packet)enumeration.nextElement(), false);
                }
            }
            Consumer[] consumerArray = store2.getAllInterests();
            for (n = 0; n < consumerArray.length; ++n) {
                store.storeInterest(consumerArray[n], false);
            }
            for (n = 0; n < destinationArray.length; ++n) {
                iterator = store2.messageEnumeration(destinationArray[n]);
                while (iterator.hasMoreElements()) {
                    objectArray = (Packet)iterator.nextElement();
                    transactionAcknowledgementArray = objectArray.getSysMessageID();
                    DestinationUID destinationUID = destinationArray[n].getDestinationUID();
                    ConsumerUID[] consumerUIDArray = store2.getConsumerUIDs(destinationUID, (SysMessageID)transactionAcknowledgementArray);
                    int[] nArray = new int[consumerUIDArray.length];
                    for (int i = 0; i < consumerUIDArray.length; ++i) {
                        nArray[i] = store2.getInterestState(destinationUID, (SysMessageID)transactionAcknowledgementArray, consumerUIDArray[i]);
                    }
                    if (consumerUIDArray.length == 0) continue;
                    store.storeInterestStates(destinationUID, (SysMessageID)transactionAcknowledgementArray, consumerUIDArray, nArray, false);
                }
            }
            HashMap hashMap2 = store2.getAllTransactionStates();
            iterator = hashMap2.keySet().iterator();
            while (iterator.hasNext()) {
                objectArray = iterator.next();
                store.storeTransaction((TransactionUID)objectArray, (TransactionState)hashMap2.get(objectArray), false);
            }
            iterator = hashMap2.keySet().iterator();
            while (iterator.hasNext()) {
                objectArray = iterator.next();
                transactionAcknowledgementArray = store2.getTransactionAcks((TransactionUID)objectArray);
                for (int i = 0; i < transactionAcknowledgementArray.length; ++i) {
                    store.storeTransactionAck((TransactionUID)objectArray, transactionAcknowledgementArray[i], false);
                }
            }
            objectArray = store2.getAllConfigRecords();
            for (int i = 0; i < ((ArrayList)objectArray[0]).size(); ++i) {
                store.storeConfigChangeRecord((Long)((ArrayList)objectArray[0]).get(i), (byte[])((ArrayList)objectArray[1]).get(i), false);
            }
            String[] stringArray = store2.getPropertyNames();
            for (int i = 0; i < stringArray.length; ++i) {
                store.updateProperty(stringArray[i], store2.getProperty(stringArray[i]), false);
            }
        }
        catch (Exception exception) {
            throw new BrokerException(br.getString("B3124"));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void doQuery() throws BrokerException {
        Connection connection = null;
        try {
            connection = this.dbmgr.getConnection(true);
            if (Globals.getHAEnabled()) {
                System.out.println(br.getString("B1202", Globals.getBrokerID(), Globals.getClusterID()));
            } else {
                System.out.println(br.getString("B1042"));
            }
            int n = this.dbmgr.checkStoreExists(connection);
            if (n == 0) {
                System.out.println(br.getString("B3132"));
            } else if (n > 0) {
                System.out.println(br.getString("B3210"));
            } else {
                System.out.println(br.getString("B3213"));
            }
        }
        finally {
            Util.close(null, null, connection);
        }
    }

    private boolean printHelp(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(OPT_H) && !stringArray[i].equals(OPT_LH)) continue;
            return true;
        }
        return false;
    }

    private boolean printVersion(String[] stringArray) {
        for (int i = 0; i < stringArray.length; ++i) {
            if (!stringArray[i].equals(OPT_V) && !stringArray[i].equals(OPT_LV)) continue;
            return true;
        }
        return false;
    }

    private void checkArg(String string, String string2, int n, int n2) throws ParserException {
        if (n >= n2) {
            ParserException parserException;
            if (string != null) {
                parserException = new ParserException(MISSING_CMD_ARG);
                parserException.cmd = string;
            } else {
                parserException = new ParserException(MISSING_OPT_ARG);
                parserException.opt = string2;
            }
            throw parserException;
        }
    }

    private void throwParserException(int n, String string, String string2, String string3, String string4) throws ParserException {
        ParserException parserException = new ParserException(n);
        parserException.cmd = string;
        parserException.cmdarg = string2;
        parserException.opt = string3;
        parserException.optarg = string4;
        throw parserException;
    }

    private void handleParserException(ParserException parserException) {
        if (parserException.reason == MISSING_CMD_ARG) {
            System.out.println(br.getString("B3083", parserException.cmd));
        } else if (parserException.reason == MISSING_OPT_ARG) {
            System.out.println(br.getString("B3080", parserException.opt));
        } else if (parserException.reason == BAD_CMD_ARG) {
            System.out.println(br.getString("B3078", parserException.cmd, parserException.cmdarg));
        } else if (parserException.reason == BAD_OPT) {
            if (parserException.opt.equals(OPT_P)) {
                System.out.println(br.getString("B3217", parserException.opt));
            } else {
                System.out.println(br.getString("B3079", parserException.opt));
            }
        } else if (parserException.reason == BAD_OPT_ARG) {
            System.out.println(br.getString("B3081", parserException.opt, parserException.optarg));
        } else if (parserException.reason == EXTRA_CMD_SPECIFIED) {
            System.out.println(br.getString("B3077", parserException.cmd));
        }
    }

    private Properties parseArgs(String[] stringArray) throws ParserException {
        Properties properties = System.getProperties();
        boolean bl = false;
        for (int i = 0; i < stringArray.length; ++i) {
            if (stringArray[i].equals(CREATE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_ALL)) {
                    properties.put(CMD_NAME, CREATE_ALL_CMD);
                    continue;
                }
                if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, CREATE_TBL_CMD);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, CREATE_CMD_STR, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(DELETE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, DELETE_TBL_CMD);
                    continue;
                }
                if (stringArray[i].equals(ARGU_OLDTBL)) {
                    properties.put(CMD_NAME, DELETE_TBL_CMD);
                    properties.put(ARG_NAME, ARGU_OLDTBL);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, DELETE_CMD_STR, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(RECREATE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_TBL)) {
                    properties.put(CMD_NAME, RECREATE_TBL_CMD);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, RECREATE_CMD_STR, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(REMOVE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_BKR)) {
                    properties.put(CMD_NAME, REMOVE_BKR_CMD);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, REMOVE_CMD_STR, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(DUMP_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                properties.put(CMD_NAME, DUMP_CMD);
                properties.put(ARG_NAME, stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(DROPTBL_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                properties.put(CMD_NAME, DROPTBL_CMD);
                properties.put(ARG_NAME, stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(RESET_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_LCK)) {
                    properties.put(CMD_NAME, RESET_CMD);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, RESET_CMD, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(BACKUP_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(OPT_DIR)) {
                    properties.put(CMD_NAME, BACKUP_CMD);
                    this.checkArg(stringArray[i], null, ++i, stringArray.length);
                    properties.put("imq.backupdir", stringArray[i]);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, BACKUP_CMD, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(RESTORE_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(OPT_DIR)) {
                    properties.put(CMD_NAME, RESTORE_CMD);
                    this.checkArg(stringArray[i], null, ++i, stringArray.length);
                    properties.put("imq.backupdir", stringArray[i]);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, RESTORE_CMD, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(UPGRADE_CMD_STR)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                this.checkArg(stringArray[i], null, ++i, stringArray.length);
                if (stringArray[i].equals(ARGU_STORE)) {
                    properties.put(CMD_NAME, UPGRADE_STORE_CMD);
                    continue;
                }
                if (stringArray[i].equals(ARGU_HASTORE)) {
                    properties.put(CMD_NAME, UPGRADE_HASTORE_CMD);
                    continue;
                }
                this.throwParserException(BAD_CMD_ARG, UPGRADE_CMD_STR, stringArray[i], null, null);
                continue;
            }
            if (stringArray[i].equals(QUERY_CMD)) {
                if (bl) {
                    this.throwParserException(EXTRA_CMD_SPECIFIED, stringArray[i], null, null, null);
                } else {
                    bl = true;
                }
                properties.put(CMD_NAME, QUERY_CMD);
                continue;
            }
            if (stringArray[i].equals(OPT_B)) {
                this.checkArg(null, OPT_B, ++i, stringArray.length);
                properties.put("imq.instancename", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(OPT_N)) {
                this.checkArg(null, OPT_N, ++i, stringArray.length);
                properties.put("imq.brokerid", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(OPT_U)) {
                this.checkArg(null, OPT_U, ++i, stringArray.length);
                properties.put("imq.persist.jdbc.user", stringArray[i]);
                continue;
            }
            if (stringArray[i].equals(OPT_PW)) {
                this.checkArg(null, OPT_PW, ++i, stringArray.length);
                properties.put("imq.persist.jdbc.password", stringArray[i]);
                this.cliPasswdSpecified = true;
                continue;
            }
            if (stringArray[i].equals(OPT_PASSFILE)) {
                this.checkArg(null, OPT_PASSFILE, ++i, stringArray.length);
                File file = null;
                try {
                    file = new File(stringArray[i]).getCanonicalFile();
                }
                catch (Exception exception) {
                    this.throwParserException(BAD_OPT, null, null, stringArray[i], null);
                }
                properties.put("imq.passfile.enabled", "true");
                properties.put("imq.passfile.dirpath", file.getParent());
                properties.put("imq.passfile.name", file.getName());
                continue;
            }
            if (stringArray[i].equals(OPT_VERBOSE)) continue;
            if (stringArray[i].equals(OPT_DEBUG)) {
                this.debugSpecified = true;
                continue;
            }
            if (stringArray[i].equals(OPT_FORCE)) {
                this.forceSpecified = true;
                continue;
            }
            if (stringArray[i].equals(OPT_VARHOME)) {
                ++i;
                continue;
            }
            if (stringArray[i].startsWith(OPT_D)) {
                int n = 0;
                String string = null;
                String string2 = "";
                n = stringArray[i].indexOf(61);
                if (stringArray[i].length() <= 2) continue;
                if (n < 0) {
                    string = stringArray[i].substring(2);
                } else if (n == stringArray[i].length() - 1) {
                    string = stringArray[i].substring(2, n);
                } else {
                    string = stringArray[i].substring(2, n);
                    string2 = stringArray[i].substring(n + 1);
                }
                properties.put(string, string2);
                if (!Store.DEBUG) continue;
                logger.log(4, "added sys prop: " + string + "=" + string2);
                continue;
            }
            this.throwParserException(BAD_OPT, null, null, stringArray[i], null);
        }
        return properties;
    }

    private void parsePassfile() throws FileNotFoundException {
        Properties properties;
        String string = null;
        String string2 = null;
        String string3 = null;
        string3 = config.getProperty("imq.passfile.enabled");
        if (string3 == null || !string3.equalsIgnoreCase(Boolean.TRUE.toString())) {
            return;
        }
        string = config.getProperty("imq.passfile.dirpath");
        string2 = string != null ? (string = StringUtil.expandVariables(string, config)) : config.getProperty("imq.etchome") + File.separator + "security";
        String string4 = string2 + File.separator + config.getProperty("imq.passfile.name");
        File file = new File(string4);
        if (file.exists()) {
            properties = new Properties();
            try {
                FileInputStream fileInputStream = new FileInputStream(string4);
                properties.load(fileInputStream);
            }
            catch (IOException iOException) {
                logger.log(32, br.getKString("B4023"), iOException);
            }
        } else {
            logger.log(32, br.getKString("B3020", string4));
            throw new FileNotFoundException(br.getKString("B3020", string4));
        }
        config.putAll((Map)properties);
    }

    private void exit(int n) {
        if (this.standalone) {
            DBConnectionPool.reset();
            System.exit(n);
        }
    }

    void doCommand(String[] stringArray) throws SQLException, BrokerException, FileNotFoundException {
        String string;
        String string2;
        String string3;
        if (stringArray.length == 0) {
            System.out.println(this.version.getBanner(true));
            System.out.println(br.getString("B0011"));
            this.exit(0);
        }
        if (this.printHelp(stringArray)) {
            System.out.println(br.getString("B0011"));
            this.exit(0);
        }
        if (this.printVersion(stringArray)) {
            System.out.println(this.version.getBanner(true));
            System.out.println(br.getString("B1003") + System.getProperty("java.version") + " " + System.getProperty("java.vendor") + " " + System.getProperty("java.home"));
            System.out.println(br.getString("B1054") + System.getProperty("java.class.path"));
            this.exit(0);
        }
        Properties properties = null;
        try {
            properties = this.parseArgs(stringArray);
        }
        catch (ParserException parserException) {
            this.handleParserException(parserException);
            this.exit(1);
        }
        properties.setProperty("imq.persist.jdbcconnection.limit", "2");
        if (this.cliPasswdSpecified) {
            System.err.println(br.getString("B2088", OPT_PW));
            System.err.println("");
        }
        if ((string3 = properties.getProperty("imq.instancename")) != null && string3.length() > 0) {
            Globals.pathinit(null);
            string2 = Globals.JMQ_INSTANCES_HOME + File.separator + string3;
            if (!new File(string2).exists()) {
                System.err.println(br.getString("B3119", string3));
                System.exit(1);
            }
        }
        Globals.init(properties, false);
        config = Globals.getConfig();
        logger = Globals.getLogger();
        this.parsePassfile();
        string2 = config.getProperty("imq.persist.jdbc.dbVendor");
        String string4 = "imq.persist.jdbc." + string2;
        String string5 = properties.getProperty("imq.persist.jdbc.user");
        if (string5 != null && string5.length() > 0) {
            config.put(string4 + ".user", string5);
        }
        if ((string = properties.getProperty("imq.persist.jdbc.password")) != null && string.length() > 0) {
            config.put(string4 + ".password", string);
        }
        this.dbmgr = DBManager.getDBManager();
        String string6 = properties.getProperty(CMD_NAME);
        String string7 = this.dbmgr.getBrokerID();
        String string8 = CREATE_ALL_CMD.equals(string6) ? this.dbmgr.getCreateDBURL() : this.dbmgr.getOpenDBURL();
        if (string8 == null) {
            string8 = "not specified";
        }
        if ((string5 = this.dbmgr.getUser()) == null) {
            string5 = "not specified";
        }
        Object[] objectArray = new String[]{String.valueOf(400), string7, string8, string5};
        logger.logToAll(8, br.getString("B1067", objectArray));
        if (CREATE_ALL_CMD.equals(string6)) {
            this.doCreate(true);
        } else if (CREATE_TBL_CMD.equals(string6)) {
            this.doCreate(false);
        } else if (DELETE_TBL_CMD.equals(string6)) {
            this.doDelete(properties.getProperty(ARG_NAME));
        } else if (RECREATE_TBL_CMD.equals(string6)) {
            this.doRecreate();
        } else if (REMOVE_BKR_CMD.equals(string6)) {
            this.doRemoveBkr();
        } else if (DUMP_CMD.equals(string6)) {
            String string9 = properties.getProperty(ARG_NAME);
            this.doDump(string9);
        } else if (DROPTBL_CMD.equals(string6)) {
            String string10 = properties.getProperty(ARG_NAME);
            this.doDropTablesByPattern(string10);
        } else if (RESET_CMD.equals(string6)) {
            this.doReset();
        } else if (BACKUP_CMD.equals(string6)) {
            this.doBackup();
        } else if (RESTORE_CMD.equals(string6)) {
            this.doRestore();
        } else if (UPGRADE_STORE_CMD.equals(string6)) {
            this.doUpgrade(false);
        } else if (UPGRADE_HASTORE_CMD.equals(string6)) {
            this.doUpgrade(true);
        } else if (QUERY_CMD.equals(string6)) {
            this.doQuery();
        } else if (string6 == null) {
            System.out.println(br.getString("B3105"));
        } else {
            System.out.println(br.getString("B3104", string6));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] stringArray) {
        int n = 0;
        DBTool dBTool = new DBTool(true);
        try {
            dBTool.doCommand(stringArray);
        }
        catch (Exception exception) {
            if (dBTool.debugSpecified) {
                exception.printStackTrace();
            }
            n = 1;
        }
        finally {
            if (dBTool.dbmgr != null) {
                dBTool.dbmgr.close();
            }
        }
        System.exit(n);
    }

    private static class ParserException
    extends Exception {
        String cmd;
        String cmdarg;
        String opt;
        String optarg;
        int reason;

        ParserException(int n) {
            this.reason = n;
        }
    }
}

