/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker.raptor.handlers;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterDestInfo;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.GPacketHandler;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.RaptorProtocol;
import com.sun.messaging.jmq.util.DestType;
import java.util.Hashtable;

public class DestinationUpdateHandler
extends GPacketHandler {
    public static boolean DEBUG = false;

    public DestinationUpdateHandler(RaptorProtocol raptorProtocol) {
        super(raptorProtocol);
    }

    public void handle(BrokerAddress brokerAddress, GPacket gPacket) {
        if (gPacket.getType() == 13) {
            this.handleUpdateDestination(brokerAddress, gPacket);
        } else if (gPacket.getType() == 15) {
            this.handleRemDestination(brokerAddress, gPacket);
        } else if (gPacket.getType() == 14 || gPacket.getType() == 16) {
            this.handleReply(brokerAddress, gPacket);
        } else {
            this.logger.log(16, "DestinationUpdateHandler Internal error : Cannot handle this packet :" + gPacket.toLongString());
        }
    }

    public void handleUpdateDestination(BrokerAddress brokerAddress, GPacket gPacket) {
        ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(gPacket);
        DestinationUID destinationUID = clusterDestInfo.getDestUID();
        try {
            Hashtable hashtable = clusterDestInfo.getDestProps();
            Destination destination = Destination.getDestination(destinationUID);
            if (destination == null) {
                destination = Destination.createDestination(clusterDestInfo.getDestName(), clusterDestInfo.getDestType(), !DestType.isTemporary(clusterDestInfo.getDestType()), false, this.selfAddress);
                destination.setDestinationProperties(hashtable);
                this.cbDispatcher.notifyCreateDestination(destination);
            } else {
                this.cbDispatcher.notifyUpdateDestination(destinationUID, hashtable);
            }
        }
        catch (Exception exception) {
            this.logger.logStack(8, "Internal Exception, unable to process message " + gPacket, exception);
            return;
        }
    }

    public void handleRemDestination(BrokerAddress brokerAddress, GPacket gPacket) {
        ClusterDestInfo clusterDestInfo = ClusterDestInfo.newInstance(gPacket);
        DestinationUID destinationUID = clusterDestInfo.getDestUID();
        this.cbDispatcher.notifyDestroyDestination(destinationUID);
    }

    public void handleReply(BrokerAddress brokerAddress, GPacket gPacket) {
    }
}

