/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.multibroker;

import com.sun.messaging.jmq.io.GPacket;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.core.BrokerAddress;
import com.sun.messaging.jmq.jmsserver.core.Consumer;
import com.sun.messaging.jmq.jmsserver.core.ConsumerUID;
import com.sun.messaging.jmq.jmsserver.core.Destination;
import com.sun.messaging.jmq.jmsserver.core.DestinationUID;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.CallbackEventListener;
import com.sun.messaging.jmq.jmsserver.multibroker.ClientDownCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterCreateDestinationCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterDestroyDestinationCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ClusterUpdateDestinationCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.ConfigSyncCompleteCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.GPacketCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.GoHAActiveCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.InterestCreatedCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.InterestRemovedCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.MessageBusCallback;
import com.sun.messaging.jmq.jmsserver.multibroker.PrimaryInterestChangedCallbackEvent;
import com.sun.messaging.jmq.jmsserver.multibroker.Protocol;
import com.sun.messaging.jmq.jmsserver.multibroker.raptor.ClusterGoodbyeInfo;
import com.sun.messaging.jmq.jmsserver.service.ConnectionUID;
import com.sun.messaging.jmq.util.log.Logger;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.NoSuchElementException;

public class CallbackDispatcher
extends Thread {
    public static boolean DEBUG = false;
    protected Logger logger = Globals.getLogger();
    private MessageBusCallback cb = null;
    private LinkedList eventQ = null;
    private boolean stopThread = false;

    public CallbackDispatcher(MessageBusCallback messageBusCallback) {
        this.cb = messageBusCallback;
        this.eventQ = new LinkedList();
        this.setName("MessageBusCallbackDispatcher");
        this.setDaemon(true);
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void configSyncComplete() {
        ConfigSyncCompleteCallbackEvent configSyncCompleteCallbackEvent = new ConfigSyncCompleteCallbackEvent();
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(configSyncCompleteCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGPacket(BrokerAddress brokerAddress, GPacket gPacket, Protocol protocol) {
        GPacketCallbackEvent gPacketCallbackEvent = new GPacketCallbackEvent(brokerAddress, gPacket, protocol);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(gPacketCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGoodbye(BrokerAddress brokerAddress, ClusterGoodbyeInfo clusterGoodbyeInfo) {
        CallbackEvent callbackEvent = null;
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            Iterator iterator = this.eventQ.iterator();
            while (iterator.hasNext()) {
                GPacketCallbackEvent gPacketCallbackEvent;
                callbackEvent = (CallbackEvent)iterator.next();
                if (!(callbackEvent instanceof GPacketCallbackEvent) || !(gPacketCallbackEvent = (GPacketCallbackEvent)callbackEvent).getSender().equals(brokerAddress) || gPacketCallbackEvent.getEventType() != 3) continue;
                this.logger.log(16, "Discard unprocessed G_MESSAGE_ACK  because received GOODBYE from " + brokerAddress);
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processGoodbyeReply(BrokerAddress brokerAddress) {
        CallbackEvent callbackEvent = null;
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            Iterator iterator = this.eventQ.iterator();
            while (iterator.hasNext()) {
                GPacketCallbackEvent gPacketCallbackEvent;
                callbackEvent = (CallbackEvent)iterator.next();
                if (!(callbackEvent instanceof GPacketCallbackEvent) || !(gPacketCallbackEvent = (GPacketCallbackEvent)callbackEvent).getSender().equals(brokerAddress) || gPacketCallbackEvent.getEventType() != 4) continue;
                if (DEBUG) {
                    this.logger.log(8, "Processed G_MESSAGE_ACK_REPLY from " + brokerAddress);
                }
                gPacketCallbackEvent.dispatch(this.cb);
                iterator.remove();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interestCreated(Consumer consumer) {
        InterestCreatedCallbackEvent interestCreatedCallbackEvent = new InterestCreatedCallbackEvent(consumer);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(interestCreatedCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void interestRemoved(Consumer consumer) {
        InterestRemovedCallbackEvent interestRemovedCallbackEvent = new InterestRemovedCallbackEvent(consumer);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(interestRemovedCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeStateChanged(ConsumerUID consumerUID) {
        PrimaryInterestChangedCallbackEvent primaryInterestChangedCallbackEvent = new PrimaryInterestChangedCallbackEvent(consumerUID);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(primaryInterestChangedCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void activeStateChanged(Consumer consumer) {
        PrimaryInterestChangedCallbackEvent primaryInterestChangedCallbackEvent = new PrimaryInterestChangedCallbackEvent(consumer);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(primaryInterestChangedCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void clientDown(ConnectionUID connectionUID) {
        ClientDownCallbackEvent clientDownCallbackEvent = new ClientDownCallbackEvent(connectionUID);
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(clientDownCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void brokerDown(BrokerAddress brokerAddress) {
        CallbackEvent callbackEvent = null;
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            Iterator iterator = this.eventQ.iterator();
            while (iterator.hasNext()) {
                GPacketCallbackEvent gPacketCallbackEvent;
                callbackEvent = (CallbackEvent)iterator.next();
                if (!(callbackEvent instanceof GPacketCallbackEvent) || !(gPacketCallbackEvent = (GPacketCallbackEvent)callbackEvent).getSender().equals(brokerAddress) || !gPacketCallbackEvent.getSender().getBrokerSessionUID().equals(brokerAddress.getBrokerSessionUID())) continue;
                if (gPacketCallbackEvent.getEventType() == 4 || gPacketCallbackEvent.getEventType() == 5 || gPacketCallbackEvent.getEventType() == 7 || gPacketCallbackEvent.getEventType() == 21) {
                    gPacketCallbackEvent.dispatch(this.cb);
                }
                iterator.remove();
            }
        }
        this.cb.brokerDown(brokerAddress);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyCreateDestination(Destination destination) {
        ClusterCreateDestinationCallbackEvent clusterCreateDestinationCallbackEvent = new ClusterCreateDestinationCallbackEvent(destination, new CallbackEventListener());
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            if (this.stopThread) {
                this.logger.log(4, "Cluster shutdown, ignore create destination event on " + destination);
                return;
            }
            this.eventQ.add(clusterCreateDestinationCallbackEvent);
            this.eventQ.notify();
        }
        ((CallbackEvent)clusterCreateDestinationCallbackEvent).getEventListener().waitEventProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyDestroyDestination(DestinationUID destinationUID) {
        ClusterDestroyDestinationCallbackEvent clusterDestroyDestinationCallbackEvent = new ClusterDestroyDestinationCallbackEvent(destinationUID, new CallbackEventListener());
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            if (this.stopThread) {
                this.logger.log(4, "Cluster shutdown, ignore destroy destination event on " + destinationUID);
                return;
            }
            this.eventQ.add(clusterDestroyDestinationCallbackEvent);
            this.eventQ.notify();
        }
        ((CallbackEvent)clusterDestroyDestinationCallbackEvent).getEventListener().waitEventProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void notifyUpdateDestination(DestinationUID destinationUID, Map map) {
        ClusterUpdateDestinationCallbackEvent clusterUpdateDestinationCallbackEvent = new ClusterUpdateDestinationCallbackEvent(destinationUID, map, new CallbackEventListener());
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            if (this.stopThread) {
                this.logger.log(4, "Cluster shutdown, ignore update destination event on " + destinationUID);
                return;
            }
            this.eventQ.add(clusterUpdateDestinationCallbackEvent);
            this.eventQ.notify();
        }
        ((CallbackEvent)clusterUpdateDestinationCallbackEvent).getEventListener().waitEventProcessed();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void goHAActive() {
        GoHAActiveCallbackEvent goHAActiveCallbackEvent = new GoHAActiveCallbackEvent();
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.eventQ.add(goHAActiveCallbackEvent);
            this.eventQ.notify();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void shutdown() {
        LinkedList linkedList = this.eventQ;
        synchronized (linkedList) {
            this.stopThread = true;
            this.eventQ.notify();
        }
        try {
            this.join(30000L);
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Unable to fully structure code
     */
    public void run() {
        block26: {
            var1_1 = null;
            while (true) lbl-1000:
            // 3 sources

            {
                var2_2 = this.eventQ;
                synchronized (var2_2) {
                    while (!this.stopThread && this.eventQ.isEmpty()) {
                        try {
                            this.eventQ.wait();
                        }
                        catch (Exception var3_3) {}
                    }
                    if (this.stopThread) {
                        break block26;
                    }
                    var1_1 = (CallbackEvent)this.eventQ.removeFirst();
                }
                try {
                    var1_1.dispatch(this.cb);
                }
                finally {
                    var2_2 = var1_1.getEventListener();
                    if (var2_2 == null) continue;
                    var2_2.eventProcessed();
                    continue;
                }
                break;
            }
            ** GOTO lbl-1000
            finally {
                var2_2 = this.eventQ;
                synchronized (var2_2) {
                    try {
                        var1_1 = (CallbackEvent)this.eventQ.removeFirst();
                        while (var1_1 != null) {
                            var3_4 = var1_1.getEventListener();
                            if (var3_4 != null) {
                                var3_4.eventProcessed();
                            }
                            var1_1 = (CallbackEvent)this.eventQ.removeFirst();
                        }
                    }
                    catch (NoSuchElementException var3_5) {}
                    this.stopThread = true;
                }
            }
        }
    }
}

