/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import [Ljavax.management.ObjectName;;
import com.sun.messaging.jmq.io.MetricCounters;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadOnly;
import com.sun.messaging.jmq.jmsserver.management.util.ServiceUtil;
import com.sun.messaging.jmq.jmsserver.util.MetricManager;
import com.sun.messaging.jms.management.server.MQObjectName;
import com.sun.messaging.jms.management.server.ServiceNotification;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class ServiceManagerMonitor
extends MQMBeanReadOnly {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;
    private static String[] svcNotificationTypes;
    private static MBeanNotificationInfo[] notifs;

    public Long getMsgBytesIn() {
        MetricCounters metricCounters = this.getMetricsForAllServices();
        return new Long(metricCounters.messageBytesIn);
    }

    public Long getMsgBytesOut() {
        MetricCounters metricCounters = this.getMetricsForAllServices();
        return new Long(metricCounters.messageBytesOut);
    }

    public Integer getNumActiveThreads() {
        MetricCounters metricCounters = this.getMetricsForAllServices();
        return new Integer(metricCounters.threadsActive);
    }

    public Long getNumMsgsIn() {
        MetricCounters metricCounters = this.getMetricsForAllServices();
        return new Long(metricCounters.messagesIn);
    }

    public Long getNumMsgsOut() {
        MetricCounters metricCounters = this.getMetricsForAllServices();
        return new Long(metricCounters.messagesOut);
    }

    public Long getNumPktsIn() {
        MetricCounters metricCounters = this.getMetricsForAllServices();
        return new Long(metricCounters.packetsIn);
    }

    public Long getNumPktsOut() {
        MetricCounters metricCounters = this.getMetricsForAllServices();
        return new Long(metricCounters.packetsOut);
    }

    public Integer getNumServices() {
        List list = ServiceUtil.getVisibleServiceNames();
        return new Integer(list.size());
    }

    public Long getPktBytesIn() {
        MetricCounters metricCounters = this.getMetricsForAllServices();
        return new Long(metricCounters.packetBytesIn);
    }

    public Long getPktBytesOut() {
        MetricCounters metricCounters = this.getMetricsForAllServices();
        return new Long(metricCounters.packetBytesOut);
    }

    public ObjectName[] getServices() throws MBeanException {
        List list = ServiceUtil.getVisibleServiceNames();
        if (list.size() == 0) {
            return null;
        }
        ObjectName[] objectNameArray = new ObjectName[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                ObjectName objectName = MQObjectName.createServiceMonitor(string);
                objectNameArray[n++] = objectName;
            }
            catch (Exception exception) {
                this.handleOperationException("getServices", exception);
            }
        }
        return objectNameArray;
    }

    public String getMBeanName() {
        return "ServiceManagerMonitor";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1239");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return notifs;
    }

    public void notifyServicePause(String string) {
        ServiceNotification serviceNotification = new ServiceNotification("mq.service.pause", this, this.sequenceNumber++);
        serviceNotification.setServiceName(string);
        this.sendNotification(serviceNotification);
    }

    public void notifyServiceResume(String string) {
        ServiceNotification serviceNotification = new ServiceNotification("mq.service.resume", this, this.sequenceNumber++);
        serviceNotification.setServiceName(string);
        this.sendNotification(serviceNotification);
    }

    private MetricCounters getMetricsForAllServices() {
        MetricManager metricManager = Globals.getMetricManager();
        MetricCounters metricCounters = null;
        metricCounters = metricManager.getMetricCounters(null);
        return metricCounters;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[10];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("MsgBytesIn", Long.class.getName(), mbr.getString("MB1225"), true, false, false);
        Class clazz = Long.class;
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("MsgBytesOut", clazz.getName(), mbr.getString("MB1226"), true, false, false);
        mBeanAttributeInfoArray[2] = new MBeanAttributeInfo("NumActiveThreads", Integer.class.getName(), mbr.getString("MB1227"), true, false, false);
        Class clazz2 = Long.class;
        mBeanAttributeInfoArray[3] = new MBeanAttributeInfo("NumMsgsIn", clazz2.getName(), mbr.getString("MB1228"), true, false, false);
        Class clazz3 = Long.class;
        mBeanAttributeInfoArray[4] = new MBeanAttributeInfo("NumMsgsOut", clazz3.getName(), mbr.getString("MB1229"), true, false, false);
        Class clazz4 = Long.class;
        mBeanAttributeInfoArray[5] = new MBeanAttributeInfo("NumPktsIn", clazz4.getName(), mbr.getString("MB1230"), true, false, false);
        Class clazz5 = Long.class;
        mBeanAttributeInfoArray[6] = new MBeanAttributeInfo("NumPktsOut", clazz5.getName(), mbr.getString("MB1231"), true, false, false);
        Class clazz6 = Integer.class;
        mBeanAttributeInfoArray[7] = new MBeanAttributeInfo("NumServices", clazz6.getName(), mbr.getString("MB1232"), true, false, false);
        Class clazz7 = Long.class;
        mBeanAttributeInfoArray[8] = new MBeanAttributeInfo("PktBytesIn", clazz7.getName(), mbr.getString("MB1233"), true, false, false);
        Class clazz8 = Long.class;
        mBeanAttributeInfoArray[9] = new MBeanAttributeInfo("PktBytesOut", clazz8.getName(), mbr.getString("MB1234"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[1];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getServices", mbr.getString("MB1238"), null, ObjectName;.class.getName(), 0);
        ops = mBeanOperationInfoArray;
        svcNotificationTypes = new String[]{"mq.service.pause", "mq.service.resume"};
        MBeanNotificationInfo[] mBeanNotificationInfoArray = new MBeanNotificationInfo[1];
        mBeanNotificationInfoArray[0] = new MBeanNotificationInfo(svcNotificationTypes, ServiceNotification.class.getName(), mbr.getString("MB1220"));
        notifs = mBeanNotificationInfoArray;
    }
}

