/*
 * Decompiled with CFR 0.152.
 */
package com.sun.messaging.jmq.jmsserver.management.mbeans;

import [Ljavax.management.ObjectName;;
import com.sun.messaging.jmq.io.MetricCounters;
import com.sun.messaging.jmq.jmsserver.Globals;
import com.sun.messaging.jmq.jmsserver.management.mbeans.MQMBeanReadWrite;
import com.sun.messaging.jmq.jmsserver.management.util.ServiceUtil;
import com.sun.messaging.jmq.jmsserver.util.BrokerException;
import com.sun.messaging.jmq.jmsserver.util.MetricManager;
import com.sun.messaging.jms.management.server.MQObjectName;
import java.util.Iterator;
import java.util.List;
import javax.management.MBeanAttributeInfo;
import javax.management.MBeanException;
import javax.management.MBeanNotificationInfo;
import javax.management.MBeanOperationInfo;
import javax.management.ObjectName;

public class ServiceManagerConfig
extends MQMBeanReadWrite {
    private static MBeanAttributeInfo[] attrs;
    private static MBeanOperationInfo[] ops;

    public Integer getMaxThreads() {
        MetricManager metricManager = Globals.getMetricManager();
        MetricCounters metricCounters = metricManager.getMetricCounters(null);
        return new Integer(metricCounters.threadsHighWater);
    }

    public Integer getMinThreads() {
        MetricManager metricManager = Globals.getMetricManager();
        MetricCounters metricCounters = metricManager.getMetricCounters(null);
        return new Integer(metricCounters.threadsLowWater);
    }

    public ObjectName[] getServices() throws MBeanException {
        List list = ServiceUtil.getVisibleServiceNames();
        if (list.size() == 0) {
            return null;
        }
        ObjectName[] objectNameArray = new ObjectName[list.size()];
        Iterator iterator = list.iterator();
        int n = 0;
        while (iterator.hasNext()) {
            String string = (String)iterator.next();
            try {
                ObjectName objectName = MQObjectName.createServiceConfig(string);
                objectNameArray[n++] = objectName;
            }
            catch (Exception exception) {
                this.handleOperationException("getServices", exception);
            }
        }
        return objectNameArray;
    }

    public void pause() throws MBeanException {
        try {
            this.logger.log(8, "Pausing all services");
            ServiceUtil.pauseService(null);
        }
        catch (BrokerException brokerException) {
            this.handleOperationException("pause", brokerException);
        }
    }

    public void resume() throws MBeanException {
        try {
            this.logger.log(8, "Resuming all services");
            ServiceUtil.resumeService(null);
        }
        catch (BrokerException brokerException) {
            this.handleOperationException("resume", brokerException);
        }
    }

    public String getMBeanName() {
        return "ServiceManagerConfig";
    }

    public String getMBeanDescription() {
        return mbr.getString("MB1222");
    }

    public MBeanAttributeInfo[] getMBeanAttributeInfo() {
        return attrs;
    }

    public MBeanOperationInfo[] getMBeanOperationInfo() {
        return ops;
    }

    public MBeanNotificationInfo[] getMBeanNotificationInfo() {
        return null;
    }

    static {
        MBeanAttributeInfo[] mBeanAttributeInfoArray = new MBeanAttributeInfo[2];
        mBeanAttributeInfoArray[0] = new MBeanAttributeInfo("MaxThreads", Integer.class.getName(), mbr.getString("MB1223"), true, false, false);
        Class clazz = Integer.class;
        mBeanAttributeInfoArray[1] = new MBeanAttributeInfo("MinThreads", clazz.getName(), mbr.getString("MB1224"), true, false, false);
        attrs = mBeanAttributeInfoArray;
        MBeanOperationInfo[] mBeanOperationInfoArray = new MBeanOperationInfo[3];
        mBeanOperationInfoArray[0] = new MBeanOperationInfo("getServices", mbr.getString("MB1235"), null, ObjectName;.class.getName(), 0);
        mBeanOperationInfoArray[1] = new MBeanOperationInfo("pause", mbr.getString("MB1236"), null, Void.TYPE.getName(), 1);
        mBeanOperationInfoArray[2] = new MBeanOperationInfo("resume", mbr.getString("MB1237"), null, Void.TYPE.getName(), 1);
        ops = mBeanOperationInfoArray;
    }
}

