/*
 * Decompiled with CFR 0.152.
 */
package picard.vcf.filter;

import htsjdk.samtools.util.CollectionUtil;
import htsjdk.variant.variantcontext.Allele;
import htsjdk.variant.variantcontext.Genotype;
import htsjdk.variant.variantcontext.VariantContext;
import htsjdk.variant.vcf.VCFFilterHeaderLine;
import java.util.HashMap;
import java.util.List;
import picard.vcf.filter.VariantFilter;

public class AlleleBalanceFilter
implements VariantFilter {
    public static final String AB_FILTER = "AlleleBalance";
    private final double hetAlleleBalance;

    public AlleleBalanceFilter(double hetAlleleBalance) {
        this.hetAlleleBalance = hetAlleleBalance;
    }

    @Override
    public List<VCFFilterHeaderLine> headerLines() {
        return CollectionUtil.makeList((Object[])new VCFFilterHeaderLine[]{new VCFFilterHeaderLine(AB_FILTER, "Heterozygote allele balance below required threshold.")});
    }

    @Override
    public String filter(VariantContext ctx) {
        if (ctx.getHetCount() == 0) {
            return null;
        }
        HashMap<List, Counts> countsMap = new HashMap<List, Counts>();
        for (Genotype gt : ctx.getGenotypesOrderedByName()) {
            if (gt.isNoCall() || !gt.isHet()) continue;
            List alleles = gt.getAlleles();
            Counts counts = (Counts)countsMap.get(alleles);
            if (counts == null) {
                counts = new Counts();
                countsMap.put(alleles, counts);
            }
            counts.allele1 += gt.getAD()[ctx.getAlleleIndex((Allele)alleles.get(0))];
            counts.allele2 += gt.getAD()[ctx.getAlleleIndex((Allele)alleles.get(1))];
        }
        for (Counts counts : countsMap.values()) {
            int total = counts.allele1 + counts.allele2;
            if (total <= 0 || !((double)Math.min(counts.allele1, counts.allele2) / (double)total < this.hetAlleleBalance)) continue;
            return AB_FILTER;
        }
        return null;
    }

    private static class Counts {
        int samples;
        int allele1;
        int allele2;

        private Counts() {
        }
    }
}

