/*
 * Decompiled with CFR 0.152.
 */
package picard.fastq;

import htsjdk.samtools.util.StringUtil;
import picard.fastq.ReadNameEncoder;
import picard.illumina.parser.ClusterData;

public class Casava18ReadNameEncoder
implements ReadNameEncoder {
    static final int CONTROL_FIELD_VALUE = 0;
    final String runId;
    final String instrumentName;
    final String flowcellId;

    public Casava18ReadNameEncoder(String instrumentName, String runId, String flowcellId) {
        this.runId = runId;
        this.instrumentName = instrumentName;
        this.flowcellId = flowcellId;
    }

    @Override
    public String generateReadName(ClusterData cluster, Integer pairNumber) {
        return String.format("%s:%s:%s:%d:%d:%d:%d %s:%s:%d:%s", new Object[]{this.instrumentName, this.runId, this.flowcellId, cluster.getLane(), cluster.getTile(), cluster.getX(), cluster.getY(), StringUtil.asEmptyIfNull((Object)pairNumber), IsFilteredLabel.get(cluster.isPf()), 0, StringUtil.asEmptyIfNull((Object)cluster.getMatchedBarcode())});
    }

    static enum IsFilteredLabel {
        Y,
        N;


        static IsFilteredLabel get(boolean passesFilter) {
            return passesFilter ? N : Y;
        }
    }
}

