/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.util;

import java.util.Locale;
import org.fest.swing.util.OSFamily;
import org.fest.swing.util.SystemPropertyReader;
import org.fest.util.VisibleForTesting;

class OSIdentifier {
    private final boolean isWindows;
    private final boolean isWindows9x;
    private final boolean isWindowsXP;
    private final boolean isMacintosh;
    private final boolean isOSX;
    private final boolean isX11;
    private final boolean isSolaris;
    private final boolean isHPUX;
    private final boolean isLinux;
    private final OSFamily osFamily;

    OSIdentifier() {
        this(new SystemPropertyReader());
    }

    @VisibleForTesting
    OSIdentifier(SystemPropertyReader r) {
        String osName = r.systemProperty("os.name").toLowerCase(Locale.ENGLISH);
        String mrjVersion = r.systemProperty("mrj.version");
        this.isWindows = osName.startsWith("windows");
        this.isWindows9x = this.isWindows && OSIdentifier.containsAny(osName, "95", "98", "me");
        this.isWindowsXP = this.isWindows && osName.contains("xp");
        this.isMacintosh = mrjVersion != null;
        this.isOSX = this.isMacintosh && osName.contains("os x");
        this.isX11 = !this.isOSX && !this.isWindows;
        this.isSolaris = osName.startsWith("sunos") || osName.startsWith("solaris");
        this.isHPUX = osName.equals("hp-ux");
        this.isLinux = osName.equals("linux");
        this.osFamily = this.findOSFamily();
    }

    private static boolean containsAny(String s, String ... subs) {
        for (String sub : subs) {
            if (!s.contains(sub)) continue;
            return true;
        }
        return false;
    }

    private OSFamily findOSFamily() {
        if (this.isWindows()) {
            return OSFamily.WINDOWS;
        }
        if (this.isMacintosh() || this.isOSX()) {
            return OSFamily.MAC;
        }
        if (this.isLinux()) {
            return OSFamily.LINUX;
        }
        return OSFamily.UNIX;
    }

    boolean isWindows() {
        return this.isWindows;
    }

    boolean isWindows9x() {
        return this.isWindows9x;
    }

    boolean isWindowsXP() {
        return this.isWindowsXP;
    }

    boolean isMacintosh() {
        return this.isMacintosh;
    }

    boolean isOSX() {
        return this.isOSX;
    }

    boolean isX11() {
        return this.isX11;
    }

    boolean isSolaris() {
        return this.isSolaris;
    }

    boolean isHPUX() {
        return this.isHPUX;
    }

    boolean isLinux() {
        return this.isLinux;
    }

    OSFamily osFamily() {
        return this.osFamily;
    }
}

