/*
 * Decompiled with CFR 0.152.
 */
package org.fest.swing.monitor;

import java.awt.AWTEvent;
import java.awt.Component;
import java.awt.Toolkit;
import java.awt.Window;
import java.awt.event.AWTEventListener;
import java.awt.event.MouseEvent;
import javax.swing.SwingUtilities;
import org.fest.swing.annotation.RunsInEDT;
import org.fest.swing.listener.WeakEventListener;
import org.fest.swing.monitor.Windows;

final class WindowAvailabilityMonitor
implements AWTEventListener {
    private static final long EVENT_MASK = 8240L;
    private final Windows windows;

    WindowAvailabilityMonitor(Windows windows) {
        this.windows = windows;
    }

    void attachTo(Toolkit toolkit) {
        WeakEventListener.attachAsWeakEventListener(toolkit, this, 8240L);
    }

    @RunsInEDT
    public void eventDispatched(AWTEvent e) {
        if (!(e instanceof MouseEvent)) {
            return;
        }
        Object source = e.getSource();
        if (!(source instanceof Component)) {
            return;
        }
        Component c = (Component)source;
        Window w = c instanceof Window ? (Window)c : SwingUtilities.getWindowAncestor(c);
        this.windows.markAsReady(w);
    }
}

