/*
 * Decompiled with CFR 0.152.
 */
package oracle.sql;

import java.io.InputStream;
import java.io.Reader;
import java.math.BigDecimal;
import java.net.URL;
import java.sql.Array;
import java.sql.Blob;
import java.sql.Clob;
import java.sql.Date;
import java.sql.NClob;
import java.sql.Ref;
import java.sql.RowId;
import java.sql.SQLException;
import java.sql.SQLInput;
import java.sql.SQLXML;
import java.sql.Struct;
import java.sql.Time;
import java.sql.Timestamp;
import java.util.Map;
import oracle.jdbc.driver.DatabaseError;
import oracle.jdbc.internal.OracleConnection;
import oracle.sql.ARRAY;
import oracle.sql.BFILE;
import oracle.sql.BLOB;
import oracle.sql.CHAR;
import oracle.sql.CLOB;
import oracle.sql.DATE;
import oracle.sql.Datum;
import oracle.sql.NCLOB;
import oracle.sql.NUMBER;
import oracle.sql.RAW;
import oracle.sql.REF;
import oracle.sql.ROWID;
import oracle.sql.STRUCT;

public class OracleJdbc2SQLInput
implements SQLInput {
    private int index;
    private Datum[] attributes;
    private Map map;
    private oracle.jdbc.OracleConnection conn;
    private static final String _Copyright_2007_Oracle_All_Rights_Reserved_ = null;
    public static final String BUILD_DATE = "Fri_Aug_26_08:19:15_PDT_2011";
    public static final boolean TRACE = false;

    public OracleJdbc2SQLInput(Datum[] datumArray, Map map, oracle.jdbc.OracleConnection oracleConnection) {
        this.attributes = datumArray;
        this.map = map;
        this.conn = oracleConnection;
        this.index = 0;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public String readString() throws SQLException {
        String string = null;
        try {
            if (this.attributes[this.index] != null) {
                string = this.attributes[this.index].stringValue();
            }
        }
        finally {
            ++this.index;
        }
        return string;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean readBoolean() throws SQLException {
        boolean bl = false;
        try {
            if (this.attributes[this.index] != null) {
                bl = this.attributes[this.index].booleanValue();
            }
        }
        finally {
            ++this.index;
        }
        return bl;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte readByte() throws SQLException {
        byte by = 0;
        try {
            if (this.attributes[this.index] != null) {
                by = this.attributes[this.index].byteValue();
            }
        }
        finally {
            ++this.index;
        }
        return by;
    }

    @Override
    public short readShort() throws SQLException {
        long l2 = this.readLong();
        if (l2 > 65537L || l2 < -65538L) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 26, "readShort");
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        return (short)l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int readInt() throws SQLException {
        int n2 = 0;
        try {
            if (this.attributes[this.index] != null) {
                n2 = this.attributes[this.index].intValue();
            }
        }
        finally {
            ++this.index;
        }
        return n2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public long readLong() throws SQLException {
        long l2 = 0L;
        try {
            if (this.attributes[this.index] != null) {
                l2 = this.attributes[this.index].longValue();
            }
        }
        finally {
            ++this.index;
        }
        return l2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public float readFloat() throws SQLException {
        float f2 = 0.0f;
        try {
            if (this.attributes[this.index] != null) {
                f2 = this.attributes[this.index].floatValue();
            }
        }
        finally {
            ++this.index;
        }
        return f2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public double readDouble() throws SQLException {
        double d2 = 0.0;
        try {
            if (this.attributes[this.index] != null) {
                d2 = this.attributes[this.index].doubleValue();
            }
        }
        finally {
            ++this.index;
        }
        return d2;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public BigDecimal readBigDecimal() throws SQLException {
        BigDecimal bigDecimal = null;
        try {
            if (this.attributes[this.index] != null) {
                bigDecimal = this.attributes[this.index].bigDecimalValue();
            }
        }
        finally {
            ++this.index;
        }
        return bigDecimal;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public byte[] readBytes() throws SQLException {
        byte[] byArray;
        block4: {
            byArray = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof RAW) {
                    byArray = ((RAW)this.attributes[this.index]).shareBytes();
                    break block4;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                ++this.index;
            }
        }
        return byArray;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Date readDate() throws SQLException {
        Date date = null;
        try {
            if (this.attributes[this.index] != null) {
                date = this.attributes[this.index].dateValue();
            }
        }
        finally {
            ++this.index;
        }
        return date;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Time readTime() throws SQLException {
        Time time = null;
        try {
            if (this.attributes[this.index] != null) {
                time = this.attributes[this.index].timeValue();
            }
        }
        finally {
            ++this.index;
        }
        return time;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Timestamp readTimestamp() throws SQLException {
        Timestamp timestamp = null;
        try {
            if (this.attributes[this.index] != null) {
                timestamp = this.attributes[this.index].timestampValue();
            }
        }
        finally {
            ++this.index;
        }
        return timestamp;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Reader readCharacterStream() throws SQLException {
        Reader reader = null;
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                reader = datum.characterStreamValue();
            }
        }
        finally {
            ++this.index;
        }
        return reader;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream readAsciiStream() throws SQLException {
        InputStream inputStream = null;
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                inputStream = datum.asciiStreamValue();
            }
        }
        finally {
            ++this.index;
        }
        return inputStream;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public InputStream readBinaryStream() throws SQLException {
        InputStream inputStream = null;
        try {
            Datum datum = this.attributes[this.index];
            if (datum != null) {
                inputStream = datum.binaryStreamValue();
            }
        }
        finally {
            ++this.index;
        }
        return inputStream;
    }

    @Override
    public Object readObject() throws SQLException {
        Datum datum = (Datum)this.readOracleObject();
        Object object = null;
        if (datum != null) {
            object = datum instanceof STRUCT ? ((STRUCT)datum).toJdbc(this.map) : datum.toJdbc();
        }
        return object;
    }

    @Override
    public Ref readRef() throws SQLException {
        return this.readREF();
    }

    @Override
    public Blob readBlob() throws SQLException {
        return this.readBLOB();
    }

    @Override
    public Clob readClob() throws SQLException {
        return this.readCLOB();
    }

    @Override
    public Array readArray() throws SQLException {
        return this.readARRAY();
    }

    public Struct readStruct() throws SQLException {
        return this.readSTRUCT();
    }

    @Override
    public boolean wasNull() throws SQLException {
        if (this.index == 0) {
            SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 24);
            sQLException.fillInStackTrace();
            throw sQLException;
        }
        boolean bl = this.attributes[this.index - 1] == null;
        return bl;
    }

    public Object readOracleObject() throws SQLException {
        return this.attributes[this.index++];
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public NUMBER readNUMBER() throws SQLException {
        NUMBER nUMBER;
        block4: {
            nUMBER = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof NUMBER) {
                    nUMBER = (NUMBER)this.attributes[this.index];
                    break block4;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                ++this.index;
            }
        }
        return nUMBER;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CHAR readCHAR() throws SQLException {
        CHAR cHAR;
        block4: {
            cHAR = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof CHAR) {
                    cHAR = (CHAR)this.attributes[this.index];
                    break block4;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                ++this.index;
            }
        }
        return cHAR;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public DATE readDATE() throws SQLException {
        DATE dATE;
        block4: {
            dATE = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof DATE) {
                    dATE = (DATE)this.attributes[this.index];
                    break block4;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                ++this.index;
            }
        }
        return dATE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BFILE readBFILE() throws SQLException {
        BFILE bFILE;
        block4: {
            bFILE = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof BFILE) {
                    bFILE = (BFILE)this.attributes[this.index];
                    break block4;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                ++this.index;
            }
        }
        return bFILE;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public BLOB readBLOB() throws SQLException {
        BLOB bLOB;
        block4: {
            bLOB = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof BLOB) {
                    bLOB = (BLOB)this.attributes[this.index];
                    break block4;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                ++this.index;
            }
        }
        return bLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public CLOB readCLOB() throws SQLException {
        CLOB cLOB;
        block4: {
            cLOB = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof CLOB) {
                    cLOB = (CLOB)this.attributes[this.index];
                    break block4;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                ++this.index;
            }
        }
        return cLOB;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public RAW readRAW() throws SQLException {
        RAW rAW;
        block4: {
            rAW = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof RAW) {
                    rAW = (RAW)this.attributes[this.index];
                    break block4;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                ++this.index;
            }
        }
        return rAW;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public REF readREF() throws SQLException {
        REF rEF;
        block4: {
            rEF = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof REF) {
                    rEF = (REF)this.attributes[this.index];
                    break block4;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                ++this.index;
            }
        }
        return rEF;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ROWID readROWID() throws SQLException {
        ROWID rOWID;
        block4: {
            rOWID = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof ROWID) {
                    rOWID = (ROWID)this.attributes[this.index];
                    break block4;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                ++this.index;
            }
        }
        return rOWID;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public ARRAY readARRAY() throws SQLException {
        ARRAY aRRAY;
        block4: {
            aRRAY = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof ARRAY) {
                    aRRAY = (ARRAY)this.attributes[this.index];
                    break block4;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                ++this.index;
            }
        }
        return aRRAY;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public STRUCT readSTRUCT() throws SQLException {
        STRUCT sTRUCT;
        block4: {
            sTRUCT = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof STRUCT) {
                    sTRUCT = (STRUCT)this.attributes[this.index];
                    break block4;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                ++this.index;
            }
        }
        return sTRUCT;
    }

    @Override
    public URL readURL() throws SQLException {
        SQLException sQLException = DatabaseError.createUnsupportedFeatureSqlException();
        sQLException.fillInStackTrace();
        throw sQLException;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public NClob readNClob() throws SQLException {
        NCLOB nCLOB;
        block4: {
            nCLOB = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof NCLOB) {
                    nCLOB = (NCLOB)this.attributes[this.index];
                    break block4;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                ++this.index;
            }
        }
        return nCLOB;
    }

    @Override
    public String readNString() throws SQLException {
        return this.readString();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SQLXML readSQLXML() throws SQLException {
        SQLXML sQLXML;
        block4: {
            sQLXML = null;
            try {
                if (this.attributes[this.index] == null) break block4;
                if (this.attributes[this.index] instanceof SQLXML) {
                    sQLXML = (SQLXML)((Object)this.attributes[this.index]);
                    break block4;
                }
                SQLException sQLException = DatabaseError.createSqlException(this.getConnectionDuringExceptionHandling(), 4, null);
                sQLException.fillInStackTrace();
                throw sQLException;
            }
            finally {
                ++this.index;
            }
        }
        return sQLXML;
    }

    @Override
    public RowId readRowId() throws SQLException {
        return this.readROWID();
    }

    protected OracleConnection getConnectionDuringExceptionHandling() {
        return null;
    }
}

