/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding.readfeatures;

import htsjdk.samtools.cram.encoding.readfeatures.ReadFeature;
import java.io.Serializable;

public class Substitution
implements Serializable,
ReadFeature {
    public static final int NO_CODE = -1;
    private int position;
    private byte base = (byte)-1;
    private byte referenceBase = (byte)-1;
    private byte code = (byte)-1;
    public static final byte operator = 88;

    public Substitution() {
    }

    public Substitution(int position, byte base, byte referenceBase) {
        this.position = position;
        this.base = base;
        this.referenceBase = referenceBase;
    }

    public byte getCode() {
        return this.code;
    }

    public void setCode(byte code) {
        this.code = code;
    }

    @Override
    public byte getOperator() {
        return 88;
    }

    @Override
    public int getPosition() {
        return this.position;
    }

    @Override
    public void setPosition(int position) {
        this.position = position;
    }

    public byte getBase() {
        return this.base;
    }

    public void setBase(byte base) {
        this.base = base;
    }

    public byte getReferenceBase() {
        return this.referenceBase;
    }

    public void setReferenceBase(byte referenceBase) {
        this.referenceBase = referenceBase;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof Substitution)) {
            return false;
        }
        Substitution substitution = (Substitution)obj;
        if (this.position != substitution.position) {
            return false;
        }
        if (this.code != substitution.code & (this.code == -1 || substitution.code == -1)) {
            return false;
        }
        if (this.code > -1 && substitution.code > -1) {
            if (this.referenceBase != substitution.referenceBase) {
                return false;
            }
            if (this.base != substitution.base) {
                return false;
            }
        }
        return true;
    }

    public String toString() {
        return String.valueOf('X') + '@' + this.position + '\\' + (char)this.base + (char)this.referenceBase;
    }
}

