/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools.cram.encoding;

import htsjdk.samtools.cram.encoding.BitCodec;
import htsjdk.samtools.cram.encoding.Encoding;
import htsjdk.samtools.cram.encoding.SubexponentialIntegerCodec;
import htsjdk.samtools.cram.io.ExposedByteArrayOutputStream;
import htsjdk.samtools.cram.io.ITF8;
import htsjdk.samtools.cram.structure.EncodingID;
import htsjdk.samtools.cram.structure.EncodingParams;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Map;

public class SubexponentialIntegerEncoding
implements Encoding<Integer> {
    private static final EncodingID ENCODING_ID = EncodingID.SUBEXPONENTIAL;
    private int offset;
    private int k;

    public SubexponentialIntegerEncoding() {
    }

    public SubexponentialIntegerEncoding(int offset, int k) {
        this.offset = offset;
        this.k = k;
    }

    @Override
    public EncodingID id() {
        return ENCODING_ID;
    }

    public static EncodingParams toParam(int offset, int k) {
        SubexponentialIntegerEncoding subexponentialIntegerEncoding = new SubexponentialIntegerEncoding();
        subexponentialIntegerEncoding.offset = offset;
        subexponentialIntegerEncoding.k = k;
        return new EncodingParams(ENCODING_ID, subexponentialIntegerEncoding.toByteArray());
    }

    @Override
    public byte[] toByteArray() {
        ByteBuffer buffer = ByteBuffer.allocate(10);
        ITF8.writeUnsignedITF8(this.offset, buffer);
        ITF8.writeUnsignedITF8(this.k, buffer);
        buffer.flip();
        byte[] bytes = new byte[buffer.limit()];
        buffer.get(bytes);
        return bytes;
    }

    @Override
    public void fromByteArray(byte[] data) {
        ByteBuffer buffer = ByteBuffer.wrap(data);
        this.offset = ITF8.readUnsignedITF8(buffer);
        this.k = ITF8.readUnsignedITF8(buffer);
    }

    @Override
    public BitCodec<Integer> buildCodec(Map<Integer, InputStream> inputMap, Map<Integer, ExposedByteArrayOutputStream> outputMap) {
        return new SubexponentialIntegerCodec(this.offset, this.k);
    }
}

