/*
 * Decompiled with CFR 0.152.
 */
package htsjdk.samtools;

import htsjdk.samtools.SAMTag;
import htsjdk.samtools.util.StringUtil;

public class SAMTagUtil {
    public final short RG = this.makeBinaryTag(SAMTag.RG.name());
    public final short LB = this.makeBinaryTag(SAMTag.LB.name());
    public final short PU = this.makeBinaryTag(SAMTag.PU.name());
    public final short PG = this.makeBinaryTag(SAMTag.PG.name());
    public final short AS = this.makeBinaryTag(SAMTag.AS.name());
    public final short SQ = this.makeBinaryTag(SAMTag.SQ.name());
    public final short MQ = this.makeBinaryTag(SAMTag.MQ.name());
    public final short NM = this.makeBinaryTag(SAMTag.NM.name());
    public final short H0 = this.makeBinaryTag(SAMTag.H0.name());
    public final short H1 = this.makeBinaryTag(SAMTag.H1.name());
    public final short H2 = this.makeBinaryTag(SAMTag.H2.name());
    public final short UQ = this.makeBinaryTag(SAMTag.UQ.name());
    public final short PQ = this.makeBinaryTag(SAMTag.PQ.name());
    public final short NH = this.makeBinaryTag(SAMTag.NH.name());
    public final short IH = this.makeBinaryTag(SAMTag.IH.name());
    public final short HI = this.makeBinaryTag(SAMTag.HI.name());
    public final short MD = this.makeBinaryTag(SAMTag.MD.name());
    public final short CS = this.makeBinaryTag(SAMTag.CS.name());
    public final short CQ = this.makeBinaryTag(SAMTag.CQ.name());
    public final short CM = this.makeBinaryTag(SAMTag.CM.name());
    public final short R2 = this.makeBinaryTag(SAMTag.R2.name());
    public final short Q2 = this.makeBinaryTag(SAMTag.Q2.name());
    public final short S2 = this.makeBinaryTag(SAMTag.S2.name());
    public final short CC = this.makeBinaryTag(SAMTag.CC.name());
    public final short CP = this.makeBinaryTag(SAMTag.CP.name());
    public final short SM = this.makeBinaryTag(SAMTag.SM.name());
    public final short AM = this.makeBinaryTag(SAMTag.AM.name());
    public final short MF = this.makeBinaryTag(SAMTag.MF.name());
    public final short E2 = this.makeBinaryTag(SAMTag.E2.name());
    public final short U2 = this.makeBinaryTag(SAMTag.U2.name());
    public final short OQ = this.makeBinaryTag(SAMTag.OQ.name());
    public final short FZ = this.makeBinaryTag(SAMTag.FZ.name());
    public final short SA = this.makeBinaryTag(SAMTag.SA.name());
    public final short MC = this.makeBinaryTag(SAMTag.MC.name());
    private static SAMTagUtil singleton;
    private final String[] stringTags = new String[Short.MAX_VALUE];

    public static SAMTagUtil getSingleton() {
        if (singleton == null) {
            singleton = new SAMTagUtil();
        }
        return singleton;
    }

    public short makeBinaryTag(String tag) {
        if (tag.length() != 2) {
            throw new IllegalArgumentException("String tag does not have length() == 2: " + tag);
        }
        return (short)(tag.charAt(1) << 8 | tag.charAt(0));
    }

    public String makeStringTag(short tag) {
        String ret = this.stringTags[tag];
        if (ret == null) {
            byte[] stringConversionBuf = new byte[]{(byte)(tag & 0xFF), (byte)(tag >> 8 & 0xFF)};
            this.stringTags[tag] = ret = StringUtil.bytesToString(stringConversionBuf);
        }
        return ret;
    }
}

