/*
 * Decompiled with CFR 0.152.
 */
package com.mongodb;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.UnknownHostException;

public class ServerAddress {
    final String _host;
    final int _port;
    volatile InetSocketAddress _address;

    public ServerAddress() throws UnknownHostException {
        this(ServerAddress.defaultHost(), ServerAddress.defaultPort());
    }

    public ServerAddress(String host) throws UnknownHostException {
        this(host, ServerAddress.defaultPort());
    }

    public ServerAddress(String host, int port) throws UnknownHostException {
        int idx;
        if (host == null) {
            host = ServerAddress.defaultHost();
        }
        if ((host = host.trim()).length() == 0) {
            host = ServerAddress.defaultHost();
        }
        if ((idx = host.indexOf(":")) > 0) {
            if (port != ServerAddress.defaultPort()) {
                throw new IllegalArgumentException("can't specify port in construct and via host");
            }
            port = Integer.parseInt(host.substring(idx + 1));
            host = host.substring(0, idx).trim();
        }
        this._host = host;
        this._port = port;
        this.updateInetAddress();
    }

    public ServerAddress(InetAddress addr) {
        this(new InetSocketAddress(addr, ServerAddress.defaultPort()));
    }

    public ServerAddress(InetAddress addr, int port) {
        this(new InetSocketAddress(addr, port));
    }

    public ServerAddress(InetSocketAddress addr) {
        this._address = addr;
        this._host = this._address.getHostName();
        this._port = this._address.getPort();
    }

    public boolean sameHost(String host) {
        int idx = host.indexOf(":");
        int port = ServerAddress.defaultPort();
        if (idx > 0) {
            port = Integer.parseInt(host.substring(idx + 1));
            host = host.substring(0, idx);
        }
        return this._port == port && this._host.equalsIgnoreCase(host);
    }

    public boolean equals(Object other) {
        if (other instanceof ServerAddress) {
            ServerAddress a = (ServerAddress)other;
            return a._port == this._port && a._host.equals(this._host);
        }
        if (other instanceof InetSocketAddress) {
            return this._address.equals(other);
        }
        return false;
    }

    public int hashCode() {
        return this._host.hashCode() + this._port;
    }

    public String getHost() {
        return this._host;
    }

    public int getPort() {
        return this._port;
    }

    public InetSocketAddress getSocketAddress() {
        return this._address;
    }

    public String toString() {
        return this._address.toString();
    }

    public static String defaultHost() {
        return "127.0.0.1";
    }

    public static int defaultPort() {
        return 27017;
    }

    boolean updateInetAddress() throws UnknownHostException {
        InetSocketAddress oldAddress = this._address;
        this._address = new InetSocketAddress(InetAddress.getByName(this._host), this._port);
        return !this._address.equals(oldAddress);
    }
}

