/*
 * Decompiled with CFR 0.152.
 */
package org.fest.reflect.beanproperty;

import org.fest.reflect.beanproperty.Invoker;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PropertyType<T> {
    private final String name;
    private final Class<T> type;

    static <T> PropertyType<T> newPropertyType(String name, Class<T> type) {
        if (type == null) {
            throw new NullPointerException("The type of the property to access should not be null");
        }
        return new PropertyType<T>(name, type);
    }

    private PropertyType(String name, Class<T> type) {
        this.name = name;
        this.type = type;
    }

    public Invoker<T> in(Object target) {
        if (target == null) {
            throw new NullPointerException("Target should not be null");
        }
        return Invoker.newInvoker(this.name, this.type, target);
    }
}

