/*
 * Decompiled with CFR 0.152.
 */
package org.broadinstitute.sting.utils.help;

import com.sun.javadoc.FieldDoc;
import com.sun.javadoc.PackageDoc;
import com.sun.javadoc.ProgramElementDoc;
import java.lang.reflect.Field;
import org.broadinstitute.sting.utils.classloader.JVMUtils;

public class HelpUtils {
    protected static boolean assignableToClass(ProgramElementDoc classDoc, Class lhsClass, boolean requireConcrete) {
        try {
            Class type = HelpUtils.getClassForDoc(classDoc);
            return lhsClass.isAssignableFrom(type) && (!requireConcrete || JVMUtils.isConcrete(type));
        }
        catch (Throwable t) {
            return false;
        }
    }

    protected static Class getClassForDoc(ProgramElementDoc doc) throws ClassNotFoundException {
        return Class.forName(HelpUtils.getClassName(doc));
    }

    protected static Field getFieldForFieldDoc(FieldDoc fieldDoc) {
        try {
            Class clazz = HelpUtils.getClassForDoc((ProgramElementDoc)fieldDoc.containingClass());
            return JVMUtils.findField(clazz, fieldDoc.name());
        }
        catch (ClassNotFoundException e) {
            throw new RuntimeException(e);
        }
    }

    protected static String getClassName(ProgramElementDoc doc) {
        PackageDoc containingPackage = doc.containingPackage();
        return containingPackage.name().length() > 0 ? String.format("%s.%s", containingPackage.name(), doc.name()) : String.format("%s", doc.name());
    }
}

