/*
 * Decompiled with CFR 0.152.
 */
package org.broad.tribble.gelitext;

import java.util.Arrays;
import org.broad.tribble.AsciiFeatureCodec;
import org.broad.tribble.Feature;
import org.broad.tribble.exception.CodecLineParsingException;
import org.broad.tribble.gelitext.DiploidGenotype;
import org.broad.tribble.gelitext.GeliTextFeature;

public class GeliTextCodec
extends AsciiFeatureCodec<GeliTextFeature> {
    private String[] parts;
    private String line;

    public GeliTextCodec() {
        super(GeliTextFeature.class);
    }

    @Override
    public Feature decodeLoc(String line) {
        return this.decode(line);
    }

    @Override
    public GeliTextFeature decode(String line) {
        if (line.startsWith("#") || line.startsWith("@")) {
            return null;
        }
        this.line = line;
        this.parts = line.trim().split("\\s+");
        return this.decode(this.parts);
    }

    @Override
    public GeliTextFeature decode(String[] tokens) {
        try {
            if (tokens.length != 18) {
                throw new CodecLineParsingException("Invalid GeliTextFeature row found -- incorrect element count.  Expected 18, got " + tokens.length + " line = " + this.line);
            }
            char[] x = tokens[5].toUpperCase().toCharArray();
            Arrays.sort(x);
            String bestGenotype = new String(x);
            double[] genotypeLikelihoods = new double[10];
            int pieceIndex = 8;
            int offset = 0;
            while (pieceIndex < 18) {
                genotypeLikelihoods[offset] = Double.valueOf(tokens[pieceIndex]);
                ++pieceIndex;
                ++offset;
            }
            return new GeliTextFeature(tokens[0], Long.valueOf(tokens[1]), Character.toUpperCase(tokens[2].charAt(0)), Integer.valueOf(tokens[3]), Integer.valueOf(tokens[4]), DiploidGenotype.toDiploidGenotype(bestGenotype), Double.valueOf(tokens[6]), Double.valueOf(tokens[7]), genotypeLikelihoods);
        }
        catch (CodecLineParsingException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to parse line " + this.line, e);
        }
        catch (NumberFormatException e) {
            e.printStackTrace();
            throw new RuntimeException("Unable to parse line " + this.line, e);
        }
    }
}

