#include <stdio.h>
#include <string.h>
#include <stdlib.h>
#include <errno.h>
#include "tcprobe.h"
#include <dirent.h>

tcprobe_data_struct tcprobe_data;

/****************************************************************************
 * tcprobe
 *
 * Determines if we have just one file or a directory and makes the necessary
 * calls to run_tcprobe for each file.
 *
 * returns 0 on success
 * returns 1 if it fails
 ***************************************************************************/
int tcprobe(char *filename, tcprobe_data_struct *data){
	//char command[256]= "tcprobe -i \'";
	//double framerate=0;
	//FILE *transcode;
	char full_path[256];
	char *extention;
	DIR *dir;
	struct dirent *file;
	int file_count=0;

	/* check to see if current filename is a director */
	dir = opendir(filename);


	/* just a file */
	if(dir == NULL){ 
		printf("single file\n");
		run_tcprobe(filename,data);
		file_count++;
	/* directory */	
	}else{ 
		printf("entire directory\n");
		/* list files */
		while(file = readdir(dir)){
			extention = file->d_name + (strlen(file->d_name)-3);
			if(!strcasecmp(extention,"avi")){
				strcpy(full_path,filename);
				strcat(full_path,file->d_name);
				run_tcprobe(full_path,data);
				file_count++;
			}else{
				printf("WARNING: non .avi file (we only support multiple avi files in gtranscode) %s\n",file->d_name);
			}
		}
	}
	data->num_files = file_count;

	return 0;
	
}

/****************************************************************************
 * run_tcprobe
 * 
 * Runs tcprobe on the filename and keeps a running total of the number of
 * frames (when called multiple times).
 * 
 * returns 1 on error, 0 if everything is OK
 ***************************************************************************/
int run_tcprobe(char *filename, tcprobe_data_struct *data){
	char command[256]= "tcprobe -i \'";
	char string[100];
	double framerate=0;
	FILE *transcode;
	int no_frames;
	static total_frames=0;

	strcat(command,filename);
	strcat(command,"\'");
	
	/* run transcode on selected file */
	transcode = popen(command,"r");
	if(transcode == NULL){
		printf("Could not run tcprobe!\n");
		return 1;
	}

	while(fgets(string,sizeof(string),transcode) != NULL){
		if(sscanf(string,"import frame size: -g %ix%i ",
					&data->width,
					&data->height)){
			// we found the height and width
		}
		if(sscanf(string," frame rate: -f %s [",&data->framerate)){
			// we found the frame rate
		}
		if(sscanf(string," audio track: -a 0 [0] -e %i,%i,%i ",
					&data->audio_rate,
					&data->audio_size,
					&data->audio_channels)){
			// we found the audio info 
		}
		if(sscanf(string," length: %i frames",
					&no_frames)){
			total_frames += no_frames;
			data->length_frames = total_frames;
			framerate = atof(data->framerate); //convert to a double
			framerate = (double)data->length_frames*(1/framerate); //to time
			data->length_h= framerate/(60*60); //get hours
			framerate = framerate - data->length_h*60*60; //subtract hours
			data->length_m= framerate/60; //get minutes
			framerate = framerate - data->length_m*60; //subtract minutes
			data->length_s= framerate; //get seconds
		}
		
	}
	if(data->width==0){return 1;}

	return 0;
}
