
/* autogenerated from gstcogorc.orc */

#include <orc/orc.h>
#include <orc-test/orctest.h>
#include <stdio.h>
#include <stdlib.h>
#include <math.h>

#ifndef _ORC_INTEGER_TYPEDEFS_
#define _ORC_INTEGER_TYPEDEFS_
#if defined(__STDC_VERSION__) && __STDC_VERSION__ >= 199901L
#include <stdint.h>
typedef int8_t orc_int8;
typedef int16_t orc_int16;
typedef int32_t orc_int32;
typedef int64_t orc_int64;
typedef uint8_t orc_uint8;
typedef uint16_t orc_uint16;
typedef uint32_t orc_uint32;
typedef uint64_t orc_uint64;
#elif defined(_MSC_VER)
typedef signed __int8 orc_int8;
typedef signed __int16 orc_int16;
typedef signed __int32 orc_int32;
typedef signed __int64 orc_int64;
typedef unsigned __int8 orc_uint8;
typedef unsigned __int16 orc_uint16;
typedef unsigned __int32 orc_uint32;
typedef unsigned __int64 orc_uint64;
#else
#include <limits.h>
typedef signed char orc_int8;
typedef short orc_int16;
typedef int orc_int32;
typedef unsigned char orc_uint8;
typedef unsigned short orc_uint16;
typedef unsigned int orc_uint32;
#if INT_MAX == LONG_MAX
typedef long long orc_int64;
typedef unsigned long long orc_uint64;
#else
typedef long orc_int64;
typedef unsigned long orc_uint64;
#endif
#endif
typedef union { orc_int32 i; float f; } orc_union32;
typedef union { orc_int64 i; double f; } orc_union64;
#endif

/* begin Orc C target preamble */
#define ORC_CLAMP(x,a,b) ((x)<(a) ? (a) : ((x)>(b) ? (b) : (x)))
#define ORC_ABS(a) ((a)<0 ? -(a) : (a))
#define ORC_MIN(a,b) ((a)<(b) ? (a) : (b))
#define ORC_MAX(a,b) ((a)>(b) ? (a) : (b))
#define ORC_SB_MAX 127
#define ORC_SB_MIN (-1-ORC_SB_MAX)
#define ORC_UB_MAX 255
#define ORC_UB_MIN 0
#define ORC_SW_MAX 32767
#define ORC_SW_MIN (-1-ORC_SW_MAX)
#define ORC_UW_MAX 65535
#define ORC_UW_MIN 0
#define ORC_SL_MAX 2147483647
#define ORC_SL_MIN (-1-ORC_SL_MAX)
#define ORC_UL_MAX 4294967295U
#define ORC_UL_MIN 0
#define ORC_CLAMP_SB(x) ORC_CLAMP(x,ORC_SB_MIN,ORC_SB_MAX)
#define ORC_CLAMP_UB(x) ORC_CLAMP(x,ORC_UB_MIN,ORC_UB_MAX)
#define ORC_CLAMP_SW(x) ORC_CLAMP(x,ORC_SW_MIN,ORC_SW_MAX)
#define ORC_CLAMP_UW(x) ORC_CLAMP(x,ORC_UW_MIN,ORC_UW_MAX)
#define ORC_CLAMP_SL(x) ORC_CLAMP(x,ORC_SL_MIN,ORC_SL_MAX)
#define ORC_CLAMP_UL(x) ORC_CLAMP(x,ORC_UL_MIN,ORC_UL_MAX)
#define ORC_SWAP_W(x) ((((x)&0xff)<<8) | (((x)&0xff00)>>8))
#define ORC_SWAP_L(x) ((((x)&0xff)<<24) | (((x)&0xff00)<<8) | (((x)&0xff0000)>>8) | (((x)&0xff000000)>>24))
#define ORC_PTR_OFFSET(ptr,offset) ((void *)(((unsigned char *)(ptr)) + (offset)))
/* end Orc C target preamble */


/* cogorc_downsample_horiz_cosite_1tap */
static void
_backup_cogorc_downsample_horiz_cosite_1tap (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int16 var4;
  const orc_int16 * ptr4;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int16 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0wb */
    var0 = (orc_uint16)var4 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* cogorc_downsample_horiz_cosite_3tap */
static void
_backup_cogorc_downsample_horiz_cosite_3tap (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int16 var4;
  const orc_int16 * ptr4;
  orc_int16 var5;
  const orc_int16 * ptr5;
  const orc_int16 var16 = 2;
  const orc_int16 var17 = 2;
  const orc_int16 var18 = 2;
  orc_int8 var32;
  orc_int8 var33;
  orc_int8 var34;
  orc_int16 var35;
  orc_int16 var36;
  orc_int16 var37;
  orc_int16 var38;
  orc_int16 var39;
  orc_int16 var40;
  orc_int16 var41;
  orc_int16 var42;
  orc_int16 var43;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int16 *)ex->arrays[4];
  ptr5 = (orc_int16 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var35 = var4;
    /* 1: select0wb */
    var32 = (orc_uint16)var35 & 0xff;
    /* 2: select1wb */
    var33 = ((orc_uint16)var35 >> 8)&0xff;
    /* 3: select0wb */
    var34 = (orc_uint16)var5 & 0xff;
    /* 4: convubw */
    var38 = (orc_uint8)var32;
    /* 5: convubw */
    var36 = (orc_uint8)var33;
    /* 6: convubw */
    var37 = (orc_uint8)var34;
    /* 7: mullw */
    var39 = (var36 * var16) & 0xffff;
    /* 8: addw */
    var40 = var38 + var37;
    /* 9: addw */
    var41 = var40 + var39;
    /* 10: addw */
    var42 = var41 + var17;
    /* 11: shrsw */
    var43 = var42 >> var18;
    /* 12: convsuswb */
    var0 = ORC_CLAMP_UB(var43);
    *ptr0 = var0;
    ptr0++;
  }

}

/* cogorc_downsample_420_jpeg */
static void
_backup_cogorc_downsample_420_jpeg (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int16 var4;
  const orc_int16 * ptr4;
  orc_int16 var5;
  const orc_int16 * ptr5;
  orc_int16 var32;
  orc_int8 var33;
  orc_int8 var34;
  orc_int8 var35;
  orc_int8 var36;
  orc_int8 var37;
  orc_int16 var38;
  orc_int8 var39;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int16 *)ex->arrays[4];
  ptr5 = (orc_int16 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyw */
    var32 = var4;
    /* 1: select0wb */
    var33 = (orc_uint16)var32 & 0xff;
    /* 2: select1wb */
    var34 = ((orc_uint16)var32 >> 8)&0xff;
    /* 3: avgub */
    var37 = ((orc_uint8)var33 + (orc_uint8)var34 + 1)>>1;
    /* 4: copyw */
    var38 = var5;
    /* 5: select0wb */
    var35 = (orc_uint16)var38 & 0xff;
    /* 6: select1wb */
    var36 = ((orc_uint16)var38 >> 8)&0xff;
    /* 7: avgub */
    var39 = ((orc_uint8)var35 + (orc_uint8)var36 + 1)>>1;
    /* 8: avgub */
    var0 = ((orc_uint8)var37 + (orc_uint8)var39 + 1)>>1;
    *ptr0 = var0;
    ptr0++;
  }

}

/* cogorc_downsample_vert_halfsite_2tap */
static void
_backup_cogorc_downsample_vert_halfsite_2tap (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgub */
    var0 = ((orc_uint8)var4 + (orc_uint8)var5 + 1)>>1;
    *ptr0 = var0;
    ptr0++;
  }

}

/* cogorc_downsample_vert_cosite_3tap */
static void
_backup_cogorc_downsample_vert_cosite_3tap (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  orc_int8 var6;
  const orc_int8 * ptr6;
  const orc_int16 var16 = 2;
  const orc_int16 var17 = 2;
  const orc_int16 var18 = 2;
  orc_int16 var32;
  orc_int16 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;
  orc_int16 var37;
  orc_int16 var38;
  orc_int16 var39;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: convubw */
    var32 = (orc_uint8)var4;
    /* 1: convubw */
    var33 = (orc_uint8)var5;
    /* 2: convubw */
    var34 = (orc_uint8)var6;
    /* 3: mullw */
    var35 = (var33 * var16) & 0xffff;
    /* 4: addw */
    var36 = var32 + var34;
    /* 5: addw */
    var37 = var36 + var35;
    /* 6: addw */
    var38 = var37 + var17;
    /* 7: shrsw */
    var39 = var38 >> var18;
    /* 8: convsuswb */
    var0 = ORC_CLAMP_UB(var39);
    *ptr0 = var0;
    ptr0++;
  }

}

/* cogorc_downsample_vert_halfsite_4tap */
static void
_backup_cogorc_downsample_vert_halfsite_4tap (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  orc_int8 var6;
  const orc_int8 * ptr6;
  orc_int8 var7;
  const orc_int8 * ptr7;
  const orc_int16 var16 = 26;
  const orc_int16 var17 = 6;
  const orc_int16 var18 = 32;
  const orc_int16 var19 = 6;
  orc_int16 var32;
  orc_int16 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;
  orc_int16 var37;
  orc_int16 var38;
  orc_int16 var39;
  orc_int16 var40;
  orc_int16 var41;
  orc_int16 var42;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    /* 0: convubw */
    var32 = (orc_uint8)var4;
    /* 1: convubw */
    var33 = (orc_uint8)var5;
    /* 2: convubw */
    var34 = (orc_uint8)var6;
    /* 3: convubw */
    var35 = (orc_uint8)var7;
    /* 4: addw */
    var36 = var33 + var34;
    /* 5: mullw */
    var37 = (var36 * var16) & 0xffff;
    /* 6: addw */
    var38 = var32 + var35;
    /* 7: mullw */
    var39 = (var38 * var17) & 0xffff;
    /* 8: addw */
    var40 = var37 + var39;
    /* 9: addw */
    var41 = var40 + var18;
    /* 10: shrsw */
    var42 = var41 >> var19;
    /* 11: convsuswb */
    var0 = ORC_CLAMP_UB(var42);
    *ptr0 = var0;
    ptr0++;
  }

}

/* cogorc_upsample_horiz_cosite_1tap */
static void
_backup_cogorc_upsample_horiz_cosite_1tap (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int16 var0;
  orc_int16 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var32;

  ptr0 = (orc_int16 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: copyb */
    var32 = var4;
    /* 1: mergebw */
    var0 = ((orc_uint8)var32) | ((orc_uint8)var32 << 8);
    *ptr0 = var0;
    ptr0++;
  }

}

/* cogorc_upsample_horiz_cosite */
static void
_backup_cogorc_upsample_horiz_cosite (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int16 var0;
  orc_int16 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  orc_int8 var32;
  orc_int8 var33;

  ptr0 = (orc_int16 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: copyb */
    var32 = var4;
    /* 1: avgub */
    var33 = ((orc_uint8)var32 + (orc_uint8)var5 + 1)>>1;
    /* 2: mergebw */
    var0 = ((orc_uint8)var32) | ((orc_uint8)var33 << 8);
    *ptr0 = var0;
    ptr0++;
  }

}

/* cogorc_upsample_vert_avgub */
static void
_backup_cogorc_upsample_vert_avgub (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: avgub */
    var0 = ((orc_uint8)var4 + (orc_uint8)var5 + 1)>>1;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_unpack_yuyv_y */
static void
_backup_orc_unpack_yuyv_y (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int16 var4;
  const orc_int16 * ptr4;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int16 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0wb */
    var0 = (orc_uint16)var4 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_unpack_yuyv_u */
static void
_backup_orc_unpack_yuyv_u (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_int16 var32;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0lw */
    var32 = (orc_uint32)var4.i & 0xffff;
    /* 1: select1wb */
    var0 = ((orc_uint16)var32 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_unpack_yuyv_v */
static void
_backup_orc_unpack_yuyv_v (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_int16 var32;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1lw */
    var32 = ((orc_uint32)var4.i >> 16)&0xffff;
    /* 1: select1wb */
    var0 = ((orc_uint16)var32 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_pack_yuyv */
static void
_backup_orc_pack_yuyv (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_int16 var4;
  const orc_int16 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  orc_int8 var6;
  const orc_int8 * ptr6;
  orc_int8 var32;
  orc_int8 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int16 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: copyw */
    var36 = var4;
    /* 1: select0wb */
    var32 = (orc_uint16)var36 & 0xff;
    /* 2: select1wb */
    var33 = ((orc_uint16)var36 >> 8)&0xff;
    /* 3: mergebw */
    var34 = ((orc_uint8)var32) | ((orc_uint8)var5 << 8);
    /* 4: mergebw */
    var35 = ((orc_uint8)var33) | ((orc_uint8)var6 << 8);
    /* 5: mergewl */
    var0.i = ((orc_uint16)var34) | ((orc_uint16)var35 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_unpack_uyvy_y */
static void
_backup_orc_unpack_uyvy_y (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int16 var4;
  const orc_int16 * ptr4;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int16 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1wb */
    var0 = ((orc_uint16)var4 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_unpack_uyvy_u */
static void
_backup_orc_unpack_uyvy_u (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_int16 var32;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0lw */
    var32 = (orc_uint32)var4.i & 0xffff;
    /* 1: select0wb */
    var0 = (orc_uint16)var32 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_unpack_uyvy_v */
static void
_backup_orc_unpack_uyvy_v (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_int16 var32;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1lw */
    var32 = ((orc_uint32)var4.i >> 16)&0xffff;
    /* 1: select0wb */
    var0 = (orc_uint16)var32 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_pack_uyvy */
static void
_backup_orc_pack_uyvy (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_int16 var4;
  const orc_int16 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  orc_int8 var6;
  const orc_int8 * ptr6;
  orc_int8 var32;
  orc_int8 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int16 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: copyw */
    var36 = var4;
    /* 1: select0wb */
    var32 = (orc_uint16)var36 & 0xff;
    /* 2: select1wb */
    var33 = ((orc_uint16)var36 >> 8)&0xff;
    /* 3: mergebw */
    var34 = ((orc_uint8)var5) | ((orc_uint8)var32 << 8);
    /* 4: mergebw */
    var35 = ((orc_uint8)var6) | ((orc_uint8)var33 << 8);
    /* 5: mergewl */
    var0.i = ((orc_uint16)var34) | ((orc_uint16)var35 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_addc_convert_u8_s16 */
static void
_backup_orc_addc_convert_u8_s16 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int16 var4;
  const orc_int16 * ptr4;
  const orc_int16 var16 = 128;
  orc_int16 var32;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int16 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: addw */
    var32 = var4 + var16;
    /* 1: convsuswb */
    var0 = ORC_CLAMP_UB(var32);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_subc_convert_s16_u8 */
static void
_backup_orc_subc_convert_s16_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int16 var0;
  orc_int16 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  const orc_int16 var16 = 128;
  orc_int16 var32;

  ptr0 = (orc_int16 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: convubw */
    var32 = (orc_uint8)var4;
    /* 1: subw */
    var0 = var32 - var16;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_splat_u8_ns */
static void
_backup_orc_splat_u8_ns (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  const int var24 = ex->params[24];

  ptr0 = (orc_int8 *)ex->arrays[0];

  for (i = 0; i < n; i++) {
    /* 0: copyb */
    var0 = var24;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_splat_s16_ns */
static void
_backup_orc_splat_s16_ns (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int16 var0;
  orc_int16 * ptr0;
  const int var24 = ex->params[24];

  ptr0 = (orc_int16 *)ex->arrays[0];

  for (i = 0; i < n; i++) {
    /* 0: copyw */
    var0 = var24;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_matrix2_u8 */
static void
_backup_orc_matrix2_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  const orc_int16 var16 = 6;
  const int var24 = ex->params[24];
  const int var25 = ex->params[25];
  const int var26 = ex->params[26];
  orc_int16 var32;
  orc_int16 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;
  orc_int16 var37;
  orc_int16 var38;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (orc_uint8)var4;
    /* 1: mullw */
    var34 = (var32 * var24) & 0xffff;
    /* 2: convubw */
    var33 = (orc_uint8)var5;
    /* 3: mullw */
    var35 = (var33 * var25) & 0xffff;
    /* 4: addw */
    var36 = var34 + var35;
    /* 5: addw */
    var37 = var36 + var26;
    /* 6: shrsw */
    var38 = var37 >> var16;
    /* 7: convsuswb */
    var0 = ORC_CLAMP_UB(var38);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_matrix2_11_u8 */
static void
_backup_orc_matrix2_11_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  const orc_int16 var16 = 16;
  const orc_int16 var17 = 128;
  const orc_int16 var18 = 128;
  const orc_int16 var19 = 8;
  const int var24 = ex->params[24];
  const int var25 = ex->params[25];
  orc_int16 var32;
  orc_int16 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;
  orc_int16 var37;
  orc_int16 var38;
  orc_int16 var39;
  orc_int16 var40;
  orc_int16 var41;
  orc_int16 var42;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (orc_uint8)var4;
    /* 1: subw */
    var36 = var32 - var16;
    /* 2: mullw */
    var34 = (var36 * var24) & 0xffff;
    /* 3: convubw */
    var33 = (orc_uint8)var5;
    /* 4: subw */
    var37 = var33 - var17;
    /* 5: mullw */
    var35 = (var37 * var25) & 0xffff;
    /* 6: addw */
    var38 = var34 + var35;
    /* 7: addw */
    var39 = var38 + var18;
    /* 8: shrsw */
    var40 = var39 >> var19;
    /* 9: addw */
    var41 = var40 + var36;
    /* 10: addw */
    var42 = var41 + var37;
    /* 11: convsuswb */
    var0 = ORC_CLAMP_UB(var42);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_matrix2_12_u8 */
static void
_backup_orc_matrix2_12_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  const orc_int16 var16 = 16;
  const orc_int16 var17 = 128;
  const orc_int16 var18 = 128;
  const orc_int16 var19 = 8;
  const int var24 = ex->params[24];
  const int var25 = ex->params[25];
  orc_int16 var32;
  orc_int16 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;
  orc_int16 var37;
  orc_int16 var38;
  orc_int16 var39;
  orc_int16 var40;
  orc_int16 var41;
  orc_int16 var42;
  orc_int16 var43;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (orc_uint8)var4;
    /* 1: subw */
    var36 = var32 - var16;
    /* 2: mullw */
    var34 = (var36 * var24) & 0xffff;
    /* 3: convubw */
    var33 = (orc_uint8)var5;
    /* 4: subw */
    var37 = var33 - var17;
    /* 5: mullw */
    var35 = (var37 * var25) & 0xffff;
    /* 6: addw */
    var38 = var34 + var35;
    /* 7: addw */
    var39 = var38 + var18;
    /* 8: shrsw */
    var40 = var39 >> var19;
    /* 9: addw */
    var41 = var40 + var36;
    /* 10: addw */
    var42 = var41 + var37;
    /* 11: addw */
    var43 = var42 + var37;
    /* 12: convsuswb */
    var0 = ORC_CLAMP_UB(var43);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_matrix3_u8 */
static void
_backup_orc_matrix3_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  orc_int8 var6;
  const orc_int8 * ptr6;
  const orc_int16 var16 = 6;
  const int var24 = ex->params[24];
  const int var25 = ex->params[25];
  const int var26 = ex->params[26];
  const int var27 = ex->params[27];
  orc_int16 var32;
  orc_int16 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;
  orc_int16 var37;
  orc_int16 var38;
  orc_int16 var39;
  orc_int16 var40;
  orc_int16 var41;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: convubw */
    var32 = (orc_uint8)var4;
    /* 1: mullw */
    var34 = (var32 * var24) & 0xffff;
    /* 2: convubw */
    var33 = (orc_uint8)var5;
    /* 3: mullw */
    var35 = (var33 * var25) & 0xffff;
    /* 4: addw */
    var36 = var34 + var35;
    /* 5: convubw */
    var37 = (orc_uint8)var6;
    /* 6: mullw */
    var38 = (var37 * var26) & 0xffff;
    /* 7: addw */
    var39 = var36 + var38;
    /* 8: addw */
    var40 = var39 + var27;
    /* 9: shrsw */
    var41 = var40 >> var16;
    /* 10: convsuswb */
    var0 = ORC_CLAMP_UB(var41);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_matrix3_100_u8 */
static void
_backup_orc_matrix3_100_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  orc_int8 var6;
  const orc_int8 * ptr6;
  const orc_int16 var16 = 16;
  const orc_int16 var17 = 128;
  const orc_int16 var18 = 128;
  const orc_int16 var19 = 128;
  const orc_int16 var20 = 8;
  const int var24 = ex->params[24];
  const int var25 = ex->params[25];
  const int var26 = ex->params[26];
  orc_int16 var32;
  orc_int16 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;
  orc_int16 var37;
  orc_int16 var38;
  orc_int16 var39;
  orc_int16 var40;
  orc_int16 var41;
  orc_int16 var42;
  orc_int16 var43;
  orc_int16 var44;
  orc_int16 var45;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: convubw */
    var32 = (orc_uint8)var4;
    /* 1: subw */
    var35 = var32 - var16;
    /* 2: mullw */
    var34 = (var35 * var24) & 0xffff;
    /* 3: convubw */
    var33 = (orc_uint8)var5;
    /* 4: subw */
    var36 = var33 - var17;
    /* 5: mullw */
    var37 = (var36 * var25) & 0xffff;
    /* 6: addw */
    var38 = var34 + var37;
    /* 7: convubw */
    var39 = (orc_uint8)var6;
    /* 8: subw */
    var40 = var39 - var18;
    /* 9: mullw */
    var41 = (var40 * var26) & 0xffff;
    /* 10: addw */
    var42 = var38 + var41;
    /* 11: addw */
    var43 = var42 + var19;
    /* 12: shrsw */
    var44 = var43 >> var20;
    /* 13: addw */
    var45 = var44 + var35;
    /* 14: convsuswb */
    var0 = ORC_CLAMP_UB(var45);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_matrix3_100_offset_u8 */
static void
_backup_orc_matrix3_100_offset_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  orc_int8 var6;
  const orc_int8 * ptr6;
  const int var24 = ex->params[24];
  const int var25 = ex->params[25];
  const int var26 = ex->params[26];
  const int var27 = ex->params[27];
  const int var28 = ex->params[28];
  orc_int16 var32;
  orc_int16 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;
  orc_int16 var37;
  orc_int16 var38;
  orc_int16 var39;
  orc_int16 var40;
  orc_int16 var41;
  orc_int16 var42;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: convubw */
    var34 = (orc_uint8)var4;
    /* 1: mullw */
    var32 = (var34 * var24) & 0xffff;
    /* 2: convubw */
    var33 = (orc_uint8)var5;
    /* 3: mullw */
    var35 = (var33 * var25) & 0xffff;
    /* 4: addw */
    var36 = var32 + var35;
    /* 5: convubw */
    var37 = (orc_uint8)var6;
    /* 6: mullw */
    var38 = (var37 * var26) & 0xffff;
    /* 7: addw */
    var39 = var36 + var38;
    /* 8: addw */
    var40 = var39 + var27;
    /* 9: shrsw */
    var41 = var40 >> var28;
    /* 10: addw */
    var42 = var41 + var34;
    /* 11: convsuswb */
    var0 = ORC_CLAMP_UB(var42);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_matrix3_000_u8 */
static void
_backup_orc_matrix3_000_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  orc_int8 var6;
  const orc_int8 * ptr6;
  const int var24 = ex->params[24];
  const int var25 = ex->params[25];
  const int var26 = ex->params[26];
  const int var27 = ex->params[27];
  const int var28 = ex->params[28];
  orc_int16 var32;
  orc_int16 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;
  orc_int16 var37;
  orc_int16 var38;
  orc_int16 var39;
  orc_int16 var40;
  orc_int16 var41;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: convubw */
    var32 = (orc_uint8)var4;
    /* 1: mullw */
    var34 = (var32 * var24) & 0xffff;
    /* 2: convubw */
    var33 = (orc_uint8)var5;
    /* 3: mullw */
    var35 = (var33 * var25) & 0xffff;
    /* 4: addw */
    var36 = var34 + var35;
    /* 5: convubw */
    var37 = (orc_uint8)var6;
    /* 6: mullw */
    var38 = (var37 * var26) & 0xffff;
    /* 7: addw */
    var39 = var36 + var38;
    /* 8: addw */
    var40 = var39 + var27;
    /* 9: shrsw */
    var41 = var40 >> var28;
    /* 10: convwb */
    var0 = var41;
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_pack_123x */
static void
_backup_orc_pack_123x (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  orc_int8 var6;
  const orc_int8 * ptr6;
  const int var24 = ex->params[24];
  orc_int16 var32;
  orc_int16 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: mergebw */
    var32 = ((orc_uint8)var4) | ((orc_uint8)var5 << 8);
    /* 1: mergebw */
    var33 = ((orc_uint8)var6) | ((orc_uint8)var24 << 8);
    /* 2: mergewl */
    var0.i = ((orc_uint16)var32) | ((orc_uint16)var33 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

/* orc_pack_x123 */
static void
_backup_orc_pack_x123 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_union32 var0;
  orc_union32 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  orc_int8 var6;
  const orc_int8 * ptr6;
  const int var24 = ex->params[24];
  orc_int16 var32;
  orc_int16 var33;

  ptr0 = (orc_union32 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    /* 0: mergebw */
    var32 = ((orc_uint8)var24) | ((orc_uint8)var4 << 8);
    /* 1: mergebw */
    var33 = ((orc_uint8)var5) | ((orc_uint8)var6 << 8);
    /* 2: mergewl */
    var0.i = ((orc_uint16)var32) | ((orc_uint16)var33 << 16);
    *ptr0 = var0;
    ptr0++;
  }

}

/* cogorc_combine2_u8 */
static void
_backup_cogorc_combine2_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  const orc_int16 var16 = 8;
  const int var24 = ex->params[24];
  const int var25 = ex->params[25];
  orc_int16 var32;
  orc_int16 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;
  orc_int16 var37;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    /* 0: convubw */
    var32 = (orc_uint8)var4;
    /* 1: mullw */
    var34 = (var32 * var24) & 0xffff;
    /* 2: convubw */
    var33 = (orc_uint8)var5;
    /* 3: mullw */
    var35 = (var33 * var25) & 0xffff;
    /* 4: addw */
    var36 = var34 + var35;
    /* 5: shruw */
    var37 = ((orc_uint16)var36) >> var16;
    /* 6: convuuswb */
    var0 = ORC_CLAMP_UB((orc_uint16)var37);
    *ptr0 = var0;
    ptr0++;
  }

}

/* cogorc_combine4_u8 */
static void
_backup_cogorc_combine4_u8 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_int8 var4;
  const orc_int8 * ptr4;
  orc_int8 var5;
  const orc_int8 * ptr5;
  orc_int8 var6;
  const orc_int8 * ptr6;
  orc_int8 var7;
  const orc_int8 * ptr7;
  const orc_int16 var16 = 32;
  const orc_int16 var17 = 6;
  const int var24 = ex->params[24];
  const int var25 = ex->params[25];
  const int var26 = ex->params[26];
  const int var27 = ex->params[27];
  orc_int16 var32;
  orc_int16 var33;
  orc_int16 var34;
  orc_int16 var35;
  orc_int16 var36;
  orc_int16 var37;
  orc_int16 var38;
  orc_int16 var39;
  orc_int16 var40;
  orc_int16 var41;
  orc_int16 var42;
  orc_int16 var43;
  orc_int16 var44;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_int8 *)ex->arrays[4];
  ptr5 = (orc_int8 *)ex->arrays[5];
  ptr6 = (orc_int8 *)ex->arrays[6];
  ptr7 = (orc_int8 *)ex->arrays[7];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    var5 = *ptr5;
    ptr5++;
    var6 = *ptr6;
    ptr6++;
    var7 = *ptr7;
    ptr7++;
    /* 0: convubw */
    var32 = (orc_uint8)var4;
    /* 1: mullw */
    var34 = (var32 * var24) & 0xffff;
    /* 2: convubw */
    var33 = (orc_uint8)var5;
    /* 3: mullw */
    var35 = (var33 * var25) & 0xffff;
    /* 4: addw */
    var36 = var34 + var35;
    /* 5: convubw */
    var37 = (orc_uint8)var6;
    /* 6: mullw */
    var38 = (var37 * var26) & 0xffff;
    /* 7: addw */
    var39 = var36 + var38;
    /* 8: convubw */
    var40 = (orc_uint8)var7;
    /* 9: mullw */
    var41 = (var40 * var27) & 0xffff;
    /* 10: addw */
    var42 = var39 + var41;
    /* 11: addw */
    var43 = var42 + var16;
    /* 12: shrsw */
    var44 = var43 >> var17;
    /* 13: convsuswb */
    var0 = ORC_CLAMP_UB(var44);
    *ptr0 = var0;
    ptr0++;
  }

}

/* cogorc_unpack_axyz_0 */
static void
_backup_cogorc_unpack_axyz_0 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_int16 var32;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0lw */
    var32 = (orc_uint32)var4.i & 0xffff;
    /* 1: select0wb */
    var0 = (orc_uint16)var32 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* cogorc_unpack_axyz_1 */
static void
_backup_cogorc_unpack_axyz_1 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_int16 var32;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select0lw */
    var32 = (orc_uint32)var4.i & 0xffff;
    /* 1: select1wb */
    var0 = ((orc_uint16)var32 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* cogorc_unpack_axyz_2 */
static void
_backup_cogorc_unpack_axyz_2 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_int16 var32;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1lw */
    var32 = ((orc_uint32)var4.i >> 16)&0xffff;
    /* 1: select0wb */
    var0 = (orc_uint16)var32 & 0xff;
    *ptr0 = var0;
    ptr0++;
  }

}

/* cogorc_unpack_axyz_3 */
static void
_backup_cogorc_unpack_axyz_3 (OrcExecutor *ex)
{
  int i;
  int n = ex->n;
  orc_int8 var0;
  orc_int8 * ptr0;
  orc_union32 var4;
  const orc_union32 * ptr4;
  orc_int16 var32;

  ptr0 = (orc_int8 *)ex->arrays[0];
  ptr4 = (orc_union32 *)ex->arrays[4];

  for (i = 0; i < n; i++) {
    var4 = *ptr4;
    ptr4++;
    /* 0: select1lw */
    var32 = ((orc_uint32)var4.i >> 16)&0xffff;
    /* 1: select1wb */
    var0 = ((orc_uint16)var32 >> 8)&0xff;
    *ptr0 = var0;
    ptr0++;
  }

}


static int quiet = 0;
static int benchmark = 0;

static void help (const char *argv0)
{
  printf("Usage:\n");
  printf("  %s [OPTION]\n", argv0);
  printf("Help Options:\n");
  printf("  -h, --help          Show help options\n");
  printf("Application Options:\n");
  printf("  -b, --benchmark     Run benchmark and show results\n");
  printf("  -q, --quiet         Don't output anything except on failures\n");

  exit(0);
}

int
main (int argc, char *argv[])
{
  int error = FALSE;
  int i;

  orc_test_init ();

  for(i=1;i<argc;i++) {
    if (strcmp(argv[i], "--help") == 0 ||
      strcmp(argv[i], "-h") == 0) {
      help(argv[0]);
    } else if (strcmp(argv[i], "--quiet") == 0 ||
      strcmp(argv[i], "-q") == 0) {
      quiet = 1;
      benchmark = 0;
    } else if (strcmp(argv[i], "--benchmark") == 0 ||
      strcmp(argv[i], "-b") == 0) {
      benchmark = 1;
      quiet = 0;
    }
  }

  /* cogorc_downsample_horiz_cosite_1tap */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_downsample_horiz_cosite_1tap:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_downsample_horiz_cosite_1tap");
    orc_program_set_backup_function (p, _backup_cogorc_downsample_horiz_cosite_1tap);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "select0wb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* cogorc_downsample_horiz_cosite_3tap */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_downsample_horiz_cosite_3tap:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_downsample_horiz_cosite_3tap");
    orc_program_set_backup_function (p, _backup_cogorc_downsample_horiz_cosite_3tap);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
      orc_program_add_constant (p, 2, 2, "c3");
    orc_program_add_temporary (p, 1, "t1");
    orc_program_add_temporary (p, 1, "t2");
    orc_program_add_temporary (p, 1, "t3");
    orc_program_add_temporary (p, 2, "t4");
    orc_program_add_temporary (p, 2, "t5");
    orc_program_add_temporary (p, 2, "t6");

    orc_program_append (p, "copyw", ORC_VAR_T4, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_T1, ORC_VAR_T4, ORC_VAR_D1);
    orc_program_append (p, "select1wb", ORC_VAR_T2, ORC_VAR_T4, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_T3, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T5, ORC_VAR_T2, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T6, ORC_VAR_T3, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T5, ORC_VAR_T5, ORC_VAR_C1);
    orc_program_append (p, "addw", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T6);
    orc_program_append (p, "addw", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5);
    orc_program_append (p, "addw", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C2);
    orc_program_append (p, "shrsw", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_C3);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T4, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* cogorc_downsample_420_jpeg */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_downsample_420_jpeg:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_downsample_420_jpeg");
    orc_program_set_backup_function (p, _backup_cogorc_downsample_420_jpeg);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 2, "s2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 1, "t2");
    orc_program_add_temporary (p, 1, "t3");
    orc_program_add_temporary (p, 1, "t4");
    orc_program_add_temporary (p, 1, "t5");

    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "select1wb", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "avgub", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3);
    orc_program_append (p, "copyw", ORC_VAR_T1, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_T4, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "select1wb", ORC_VAR_T5, ORC_VAR_T1, ORC_VAR_D1);
    orc_program_append (p, "avgub", ORC_VAR_T4, ORC_VAR_T4, ORC_VAR_T5);
    orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_T4);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* cogorc_downsample_vert_halfsite_2tap */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_downsample_vert_halfsite_2tap:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_downsample_vert_halfsite_2tap");
    orc_program_set_backup_function (p, _backup_cogorc_downsample_vert_halfsite_2tap);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* cogorc_downsample_vert_cosite_3tap */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_downsample_vert_cosite_3tap:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_downsample_vert_cosite_3tap");
    orc_program_set_backup_function (p, _backup_cogorc_downsample_vert_cosite_3tap);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 2, 2, "c1");
      orc_program_add_constant (p, 2, 2, "c2");
      orc_program_add_constant (p, 2, 2, "c3");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 2, "t3");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T3);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C3);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* cogorc_downsample_vert_halfsite_4tap */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_downsample_vert_halfsite_4tap:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_downsample_vert_halfsite_4tap");
    orc_program_set_backup_function (p, _backup_cogorc_downsample_vert_halfsite_4tap);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 26, "c1");
      orc_program_add_constant (p, 2, 6, "c2");
      orc_program_add_constant (p, 2, 32, "c3");
      orc_program_add_constant (p, 2, 6, "c4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 2, "t3");
    orc_program_add_temporary (p, 2, "t4");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T3, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "convubw", ORC_VAR_T4, ORC_VAR_S4, ORC_VAR_D1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T3);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C1);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T4);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_T1);
    orc_program_append (p, "addw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C3);
    orc_program_append (p, "shrsw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C4);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T2, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* cogorc_upsample_horiz_cosite_1tap */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_upsample_horiz_cosite_1tap:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_upsample_horiz_cosite_1tap");
    orc_program_set_backup_function (p, _backup_cogorc_upsample_horiz_cosite_1tap);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_temporary (p, 1, "t1");

    orc_program_append (p, "copyb", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "mergebw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* cogorc_upsample_horiz_cosite */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_upsample_horiz_cosite:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_upsample_horiz_cosite");
    orc_program_set_backup_function (p, _backup_cogorc_upsample_horiz_cosite);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_temporary (p, 1, "t1");
    orc_program_add_temporary (p, 1, "t2");

    orc_program_append (p, "copyb", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "avgub", ORC_VAR_T2, ORC_VAR_T1, ORC_VAR_S2);
    orc_program_append (p, "mergebw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* cogorc_upsample_vert_avgub */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_upsample_vert_avgub:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_upsample_vert_avgub");
    orc_program_set_backup_function (p, _backup_cogorc_upsample_vert_avgub);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");

    orc_program_append (p, "avgub", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_S2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_unpack_yuyv_y */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_unpack_yuyv_y:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_unpack_yuyv_y");
    orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_y);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "select0wb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_unpack_yuyv_u */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_unpack_yuyv_u:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_unpack_yuyv_u");
    orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_u);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "select0lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select1wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_unpack_yuyv_v */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_unpack_yuyv_v:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_unpack_yuyv_v");
    orc_program_set_backup_function (p, _backup_orc_unpack_yuyv_v);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "select1lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select1wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_pack_yuyv */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_pack_yuyv:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_pack_yuyv");
    orc_program_set_backup_function (p, _backup_orc_pack_yuyv);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_temporary (p, 1, "t1");
    orc_program_add_temporary (p, 1, "t2");
    orc_program_add_temporary (p, 2, "t3");
    orc_program_add_temporary (p, 2, "t4");
    orc_program_add_temporary (p, 2, "t5");

    orc_program_append (p, "copyw", ORC_VAR_T5, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1);
    orc_program_append (p, "select1wb", ORC_VAR_T2, ORC_VAR_T5, ORC_VAR_D1);
    orc_program_append (p, "mergebw", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_S2);
    orc_program_append (p, "mergebw", ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_S3);
    orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_unpack_uyvy_y */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_unpack_uyvy_y:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_unpack_uyvy_y");
    orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_y);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");

    orc_program_append (p, "select1wb", ORC_VAR_D1, ORC_VAR_S1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_unpack_uyvy_u */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_unpack_uyvy_u:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_unpack_uyvy_u");
    orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_u);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "select0lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_unpack_uyvy_v */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_unpack_uyvy_v:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_unpack_uyvy_v");
    orc_program_set_backup_function (p, _backup_orc_unpack_uyvy_v);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "select1lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_pack_uyvy */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_pack_uyvy:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_pack_uyvy");
    orc_program_set_backup_function (p, _backup_orc_pack_uyvy);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 2, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_temporary (p, 1, "t1");
    orc_program_add_temporary (p, 1, "t2");
    orc_program_add_temporary (p, 2, "t3");
    orc_program_add_temporary (p, 2, "t4");
    orc_program_add_temporary (p, 2, "t5");

    orc_program_append (p, "copyw", ORC_VAR_T5, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_T1, ORC_VAR_T5, ORC_VAR_D1);
    orc_program_append (p, "select1wb", ORC_VAR_T2, ORC_VAR_T5, ORC_VAR_D1);
    orc_program_append (p, "mergebw", ORC_VAR_T3, ORC_VAR_S2, ORC_VAR_T1);
    orc_program_append (p, "mergebw", ORC_VAR_T4, ORC_VAR_S3, ORC_VAR_T2);
    orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_T4);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_addc_convert_u8_s16 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_addc_convert_u8_s16:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_addc_convert_u8_s16");
    orc_program_set_backup_function (p, _backup_orc_addc_convert_u8_s16);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 2, "s1");
      orc_program_add_constant (p, 2, 128, "c1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_C1);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_subc_convert_s16_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_subc_convert_s16_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_subc_convert_s16_u8");
    orc_program_set_backup_function (p, _backup_orc_subc_convert_s16_u8);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_source (p, 1, "s1");
      orc_program_add_constant (p, 2, 128, "c1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_C1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_splat_u8_ns */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_splat_u8_ns:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_splat_u8_ns");
    orc_program_set_backup_function (p, _backup_orc_splat_u8_ns);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_parameter (p, 1, "p1");

    orc_program_append (p, "copyb", ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_splat_s16_ns */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_splat_s16_ns:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_splat_s16_ns");
    orc_program_set_backup_function (p, _backup_orc_splat_s16_ns);
    orc_program_add_destination (p, 2, "d1");
    orc_program_add_parameter (p, 2, "p1");

    orc_program_append (p, "copyw", ORC_VAR_D1, ORC_VAR_P1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_matrix2_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_matrix2_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_matrix2_u8");
    orc_program_set_backup_function (p, _backup_orc_matrix2_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
      orc_program_add_constant (p, 2, 6, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P3);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_matrix2_11_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_matrix2_11_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_matrix2_11_u8");
    orc_program_set_backup_function (p, _backup_orc_matrix2_11_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
      orc_program_add_constant (p, 2, 16, "c1");
      orc_program_add_constant (p, 2, 128, "c2");
      orc_program_add_constant (p, 2, 128, "c3");
      orc_program_add_constant (p, 2, 8, "c4");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 2, "t3");
    orc_program_add_temporary (p, 2, "t4");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "mullw", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2);
    orc_program_append (p, "mullw", ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4);
    orc_program_append (p, "addw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C3);
    orc_program_append (p, "shrsw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C4);
    orc_program_append (p, "addw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T1);
    orc_program_append (p, "addw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T2);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_matrix2_12_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_matrix2_12_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_matrix2_12_u8");
    orc_program_set_backup_function (p, _backup_orc_matrix2_12_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
      orc_program_add_constant (p, 2, 16, "c1");
      orc_program_add_constant (p, 2, 128, "c2");
      orc_program_add_constant (p, 2, 128, "c3");
      orc_program_add_constant (p, 2, 8, "c4");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 2, "t3");
    orc_program_add_temporary (p, 2, "t4");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "mullw", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2);
    orc_program_append (p, "mullw", ORC_VAR_T4, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T4);
    orc_program_append (p, "addw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C3);
    orc_program_append (p, "shrsw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C4);
    orc_program_append (p, "addw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T1);
    orc_program_append (p, "addw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T2);
    orc_program_append (p, "addw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T2);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_matrix3_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_matrix3_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_matrix3_u8");
    orc_program_set_backup_function (p, _backup_orc_matrix3_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 2, 6, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_matrix3_100_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_matrix3_100_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_matrix3_100_u8");
    orc_program_set_backup_function (p, _backup_orc_matrix3_100_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
      orc_program_add_constant (p, 2, 16, "c1");
      orc_program_add_constant (p, 2, 128, "c2");
      orc_program_add_constant (p, 2, 128, "c3");
      orc_program_add_constant (p, 2, 128, "c4");
      orc_program_add_constant (p, 2, 8, "c5");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 2, "t3");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "mullw", ORC_VAR_T3, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C2);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T2);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "subw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_C3);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3);
    orc_program_append (p, "addw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T2);
    orc_program_append (p, "addw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C4);
    orc_program_append (p, "shrsw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_C5);
    orc_program_append (p, "addw", ORC_VAR_T3, ORC_VAR_T3, ORC_VAR_T1);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T3, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_matrix3_100_offset_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_matrix3_100_offset_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_matrix3_100_offset_u8");
    orc_program_set_backup_function (p, _backup_orc_matrix3_100_offset_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_parameter (p, 2, "p5");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");
    orc_program_add_temporary (p, 2, "t3");

    orc_program_append (p, "convubw", ORC_VAR_T3, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T3, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P5);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T3);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_matrix3_000_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_matrix3_000_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_matrix3_000_u8");
    orc_program_set_backup_function (p, _backup_orc_matrix3_000_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_parameter (p, 2, "p5");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P4);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P5);
    orc_program_append (p, "convwb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_pack_123x */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_pack_123x:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_pack_123x");
    orc_program_set_backup_function (p, _backup_orc_pack_123x);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_parameter (p, 1, "p1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "mergebw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_S2);
    orc_program_append (p, "mergebw", ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_P1);
    orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* orc_pack_x123 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("orc_pack_x123:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "orc_pack_x123");
    orc_program_set_backup_function (p, _backup_orc_pack_x123);
    orc_program_add_destination (p, 4, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_parameter (p, 1, "p1");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "mergebw", ORC_VAR_T1, ORC_VAR_P1, ORC_VAR_S1);
    orc_program_append (p, "mergebw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_S3);
    orc_program_append (p, "mergewl", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_T2);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* cogorc_combine2_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_combine2_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_combine2_u8");
    orc_program_set_backup_function (p, _backup_cogorc_combine2_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
      orc_program_add_constant (p, 2, 8, "c1");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "shruw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "convuuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* cogorc_combine4_u8 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_combine4_u8:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_combine4_u8");
    orc_program_set_backup_function (p, _backup_cogorc_combine4_u8);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 1, "s1");
    orc_program_add_source (p, 1, "s2");
    orc_program_add_source (p, 1, "s3");
    orc_program_add_source (p, 1, "s4");
      orc_program_add_constant (p, 2, 32, "c1");
      orc_program_add_constant (p, 2, 6, "c2");
    orc_program_add_parameter (p, 2, "p1");
    orc_program_add_parameter (p, 2, "p2");
    orc_program_add_parameter (p, 2, "p3");
    orc_program_add_parameter (p, 2, "p4");
    orc_program_add_temporary (p, 2, "t1");
    orc_program_add_temporary (p, 2, "t2");

    orc_program_append (p, "convubw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_P1);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S2, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S3, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P3);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "convubw", ORC_VAR_T2, ORC_VAR_S4, ORC_VAR_D1);
    orc_program_append (p, "mullw", ORC_VAR_T2, ORC_VAR_T2, ORC_VAR_P4);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_T2);
    orc_program_append (p, "addw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C1);
    orc_program_append (p, "shrsw", ORC_VAR_T1, ORC_VAR_T1, ORC_VAR_C2);
    orc_program_append (p, "convsuswb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* cogorc_unpack_axyz_0 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_unpack_axyz_0:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_unpack_axyz_0");
    orc_program_set_backup_function (p, _backup_cogorc_unpack_axyz_0);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "select0lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* cogorc_unpack_axyz_1 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_unpack_axyz_1:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_unpack_axyz_1");
    orc_program_set_backup_function (p, _backup_cogorc_unpack_axyz_1);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "select0lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select1wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* cogorc_unpack_axyz_2 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_unpack_axyz_2:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_unpack_axyz_2");
    orc_program_set_backup_function (p, _backup_cogorc_unpack_axyz_2);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "select1lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select0wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }

  /* cogorc_unpack_axyz_3 */
  {
    OrcProgram *p = NULL;
    int ret;

    if (!quiet)      printf ("cogorc_unpack_axyz_3:\n");
    p = orc_program_new ();
    orc_program_set_name (p, "cogorc_unpack_axyz_3");
    orc_program_set_backup_function (p, _backup_cogorc_unpack_axyz_3);
    orc_program_add_destination (p, 1, "d1");
    orc_program_add_source (p, 4, "s1");
    orc_program_add_temporary (p, 2, "t1");

    orc_program_append (p, "select1lw", ORC_VAR_T1, ORC_VAR_S1, ORC_VAR_D1);
    orc_program_append (p, "select1wb", ORC_VAR_D1, ORC_VAR_T1, ORC_VAR_D1);

    ret = orc_test_compare_output_backup (p);
    if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    backup function  :   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (backup)  :   ");
      orc_test_performance (p, ORC_TEST_FLAGS_BACKUP);
    }

    ret = orc_test_compare_output (p);
    if (ret == ORC_TEST_INDETERMINATE && !quiet) {
      printf ("    compiled function:   COMPILE FAILED\n");
    } else if (!ret) {
      error = TRUE;
    } else if (!quiet) {
      printf ("    compiled function:   PASSED\n");
    }

    if (benchmark) {
      printf ("    cycles (compiled):   ");
      orc_test_performance (p, 0);
    }

    orc_program_free (p);
  }


  if (error) {
    return 1;
  };
  return 0;
}
