/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003 
 *					All rights reserved
 *
 *  This file is part of GPAC / Authoring Tools sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <gpac/intern/m4_author_dev.h>

static void mpeg12_do_flush(M4RTPBuilder *builder, Bool start_new)
{
	char *tmp1, *tmp2;
	u32 tmp1_size, tmp2_size;
	/*flush*/
	if (builder->auheader) {
		BS_GetContent(builder->auheader, (unsigned char **) &tmp1, &tmp1_size);
		BS_GetContent(builder->payload, (unsigned char **) &tmp2, &tmp2_size);
		builder->OnPacketDone(builder->cbk_obj, &builder->rtp_header, tmp1, tmp1_size, tmp2, tmp2_size);
		DeleteBitStream(builder->auheader);
		DeleteBitStream(builder->payload);
		free(tmp1);
		free(tmp2);
	}
	if (!start_new) return;
	builder->rtp_header.PayloadType = builder->payloadType;
	builder->rtp_header.TimeStamp = (u32) builder->sl_header.compositionTimeStamp;
	builder->auheader = NewBitStream(NULL, 0, BS_WRITE);
	builder->payload = NewBitStream(NULL, 0, BS_WRITE);
	/*create new RTP Packet */
	builder->rtp_header.SequenceNumber += 1;
	builder->OnNewPacket(builder->cbk_obj, &builder->rtp_header);
	builder->first_sl_in_rtp = 1;
	builder->bytesInPacket = 0;
}

static M4Err M4RTP_ProcessMPEG12Audio(M4RTPBuilder *builder, char *data, u32 data_size, u8 IsAUEnd, u32 FullAUSize)
{
	u32 pck_size;
	u16 offset;

	/*if no data flush, if nothing start if not enough space restart*/
	if (!data || !builder->bytesInPacket || (builder->bytesInPacket + data_size > builder->Path_MTU)) {
		mpeg12_do_flush(builder, data ? 1 : 0);
		if (!data) return M4OK;
	}

	offset = 0;
	while (data_size) {
		if (data_size + 4 < builder->Path_MTU) {
			pck_size = data_size;
		} else {
			pck_size = builder->Path_MTU - 4;
		}
		if (builder->first_sl_in_rtp) {
			BS_WriteInt(builder->auheader, 0, 16);
			BS_WriteInt(builder->auheader, offset, 16);
			builder->first_sl_in_rtp = 0;
		}
		/*add reference*/
		if (builder->OnDataReference) 
			builder->OnDataReference(builder->cbk_obj, pck_size, offset);

		/*write data*/		
		BS_WriteData(builder->payload, data + offset, pck_size);

		data_size -= pck_size;
		/*start new packet if fragmenting*/
		if (data_size) {
			offset += (u16) pck_size;
			mpeg12_do_flush(builder, 1);
		}
	}
	/*if offset force flush*/
	if (offset) mpeg12_do_flush(builder, 1);

	return M4OK;
}



M4Err M4RTP_ProcessMPEG12(M4RTPBuilder *builder, char *data, u32 data_size, u8 IsAUEnd, u32 FullAUSize)
{
	switch (builder->slMap.StreamType) {
	case M4ST_VISUAL:
		return M4NotSupported;
	case M4ST_AUDIO:
		return M4RTP_ProcessMPEG12Audio(builder, data, data_size, IsAUEnd, FullAUSize);
	default:
		return M4NotSupported;
	}
}
