/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003
 *					All rights reserved
 *
 *  This file is part of GPAC / Scene Graph sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.	
 *
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 */


/*FILE AUTOMATICALLY GENERATED BY SGGen - DO NOT MOFIFY*/



#include <gpac/intern/m4_node_tables.h>



u32 NDT_V1_GetNodeTag(u32 Context_NDT_Tag, u32 NodeType)
{
	if (!NodeType) return 0;
	/* adjust according to the table version */
	/* v1: 0 reserved for extensions */
	NodeType -= 1;
	switch (Context_NDT_Tag) {
	case NDT_SFWorldNode:
		if (NodeType >= SFWorldNode_V1_Count) return 0;
		return SFWorldNode_V1_TypeToTag[NodeType];
	case NDT_SF3DNode:
		if (NodeType >= SF3DNode_V1_Count) return 0;
		return SF3DNode_V1_TypeToTag[NodeType];
	case NDT_SF2DNode:
		if (NodeType >= SF2DNode_V1_Count) return 0;
		return SF2DNode_V1_TypeToTag[NodeType];
	case NDT_SFStreamingNode:
		if (NodeType >= SFStreamingNode_V1_Count) return 0;
		return SFStreamingNode_V1_TypeToTag[NodeType];
	case NDT_SFAppearanceNode:
		if (NodeType >= SFAppearanceNode_V1_Count) return 0;
		return SFAppearanceNode_V1_TypeToTag[NodeType];
	case NDT_SFAudioNode:
		if (NodeType >= SFAudioNode_V1_Count) return 0;
		return SFAudioNode_V1_TypeToTag[NodeType];
	case NDT_SFBackground3DNode:
		if (NodeType >= SFBackground3DNode_V1_Count) return 0;
		return SFBackground3DNode_V1_TypeToTag[NodeType];
	case NDT_SFBackground2DNode:
		if (NodeType >= SFBackground2DNode_V1_Count) return 0;
		return SFBackground2DNode_V1_TypeToTag[NodeType];
	case NDT_SFGeometryNode:
		if (NodeType >= SFGeometryNode_V1_Count) return 0;
		return SFGeometryNode_V1_TypeToTag[NodeType];
	case NDT_SFColorNode:
		if (NodeType >= SFColorNode_V1_Count) return 0;
		return SFColorNode_V1_TypeToTag[NodeType];
	case NDT_SFTextureNode:
		if (NodeType >= SFTextureNode_V1_Count) return 0;
		return SFTextureNode_V1_TypeToTag[NodeType];
	case NDT_SFCoordinateNode:
		if (NodeType >= SFCoordinateNode_V1_Count) return 0;
		return SFCoordinateNode_V1_TypeToTag[NodeType];
	case NDT_SFCoordinate2DNode:
		if (NodeType >= SFCoordinate2DNode_V1_Count) return 0;
		return SFCoordinate2DNode_V1_TypeToTag[NodeType];
	case NDT_SFExpressionNode:
		if (NodeType >= SFExpressionNode_V1_Count) return 0;
		return SFExpressionNode_V1_TypeToTag[NodeType];
	case NDT_SFFaceDefMeshNode:
		if (NodeType >= SFFaceDefMeshNode_V1_Count) return 0;
		return SFFaceDefMeshNode_V1_TypeToTag[NodeType];
	case NDT_SFFaceDefTablesNode:
		if (NodeType >= SFFaceDefTablesNode_V1_Count) return 0;
		return SFFaceDefTablesNode_V1_TypeToTag[NodeType];
	case NDT_SFFaceDefTransformNode:
		if (NodeType >= SFFaceDefTransformNode_V1_Count) return 0;
		return SFFaceDefTransformNode_V1_TypeToTag[NodeType];
	case NDT_SFFAPNode:
		if (NodeType >= SFFAPNode_V1_Count) return 0;
		return SFFAPNode_V1_TypeToTag[NodeType];
	case NDT_SFFDPNode:
		if (NodeType >= SFFDPNode_V1_Count) return 0;
		return SFFDPNode_V1_TypeToTag[NodeType];
	case NDT_SFFITNode:
		if (NodeType >= SFFITNode_V1_Count) return 0;
		return SFFITNode_V1_TypeToTag[NodeType];
	case NDT_SFFogNode:
		if (NodeType >= SFFogNode_V1_Count) return 0;
		return SFFogNode_V1_TypeToTag[NodeType];
	case NDT_SFFontStyleNode:
		if (NodeType >= SFFontStyleNode_V1_Count) return 0;
		return SFFontStyleNode_V1_TypeToTag[NodeType];
	case NDT_SFTopNode:
		if (NodeType >= SFTopNode_V1_Count) return 0;
		return SFTopNode_V1_TypeToTag[NodeType];
	case NDT_SFLinePropertiesNode:
		if (NodeType >= SFLinePropertiesNode_V1_Count) return 0;
		return SFLinePropertiesNode_V1_TypeToTag[NodeType];
	case NDT_SFMaterialNode:
		if (NodeType >= SFMaterialNode_V1_Count) return 0;
		return SFMaterialNode_V1_TypeToTag[NodeType];
	case NDT_SFNavigationInfoNode:
		if (NodeType >= SFNavigationInfoNode_V1_Count) return 0;
		return SFNavigationInfoNode_V1_TypeToTag[NodeType];
	case NDT_SFNormalNode:
		if (NodeType >= SFNormalNode_V1_Count) return 0;
		return SFNormalNode_V1_TypeToTag[NodeType];
	case NDT_SFTextureCoordinateNode:
		if (NodeType >= SFTextureCoordinateNode_V1_Count) return 0;
		return SFTextureCoordinateNode_V1_TypeToTag[NodeType];
	case NDT_SFTextureTransformNode:
		if (NodeType >= SFTextureTransformNode_V1_Count) return 0;
		return SFTextureTransformNode_V1_TypeToTag[NodeType];
	case NDT_SFViewpointNode:
		if (NodeType >= SFViewpointNode_V1_Count) return 0;
		return SFViewpointNode_V1_TypeToTag[NodeType];
	case NDT_SFVisemeNode:
		if (NodeType >= SFVisemeNode_V1_Count) return 0;
		return SFVisemeNode_V1_TypeToTag[NodeType];
	default:
		return 0;
	}
}


u32 NDT_V1_GetNumBits(u32 NDT_Tag)
{
	switch (NDT_Tag) {
	case NDT_SFWorldNode:
		return SFWorldNode_V1_NUMBITS;
	case NDT_SF3DNode:
		return SF3DNode_V1_NUMBITS;
	case NDT_SF2DNode:
		return SF2DNode_V1_NUMBITS;
	case NDT_SFStreamingNode:
		return SFStreamingNode_V1_NUMBITS;
	case NDT_SFAppearanceNode:
		return SFAppearanceNode_V1_NUMBITS;
	case NDT_SFAudioNode:
		return SFAudioNode_V1_NUMBITS;
	case NDT_SFBackground3DNode:
		return SFBackground3DNode_V1_NUMBITS;
	case NDT_SFBackground2DNode:
		return SFBackground2DNode_V1_NUMBITS;
	case NDT_SFGeometryNode:
		return SFGeometryNode_V1_NUMBITS;
	case NDT_SFColorNode:
		return SFColorNode_V1_NUMBITS;
	case NDT_SFTextureNode:
		return SFTextureNode_V1_NUMBITS;
	case NDT_SFCoordinateNode:
		return SFCoordinateNode_V1_NUMBITS;
	case NDT_SFCoordinate2DNode:
		return SFCoordinate2DNode_V1_NUMBITS;
	case NDT_SFExpressionNode:
		return SFExpressionNode_V1_NUMBITS;
	case NDT_SFFaceDefMeshNode:
		return SFFaceDefMeshNode_V1_NUMBITS;
	case NDT_SFFaceDefTablesNode:
		return SFFaceDefTablesNode_V1_NUMBITS;
	case NDT_SFFaceDefTransformNode:
		return SFFaceDefTransformNode_V1_NUMBITS;
	case NDT_SFFAPNode:
		return SFFAPNode_V1_NUMBITS;
	case NDT_SFFDPNode:
		return SFFDPNode_V1_NUMBITS;
	case NDT_SFFITNode:
		return SFFITNode_V1_NUMBITS;
	case NDT_SFFogNode:
		return SFFogNode_V1_NUMBITS;
	case NDT_SFFontStyleNode:
		return SFFontStyleNode_V1_NUMBITS;
	case NDT_SFTopNode:
		return SFTopNode_V1_NUMBITS;
	case NDT_SFLinePropertiesNode:
		return SFLinePropertiesNode_V1_NUMBITS;
	case NDT_SFMaterialNode:
		return SFMaterialNode_V1_NUMBITS;
	case NDT_SFNavigationInfoNode:
		return SFNavigationInfoNode_V1_NUMBITS;
	case NDT_SFNormalNode:
		return SFNormalNode_V1_NUMBITS;
	case NDT_SFTextureCoordinateNode:
		return SFTextureCoordinateNode_V1_NUMBITS;
	case NDT_SFTextureTransformNode:
		return SFTextureTransformNode_V1_NUMBITS;
	case NDT_SFViewpointNode:
		return SFViewpointNode_V1_NUMBITS;
	case NDT_SFVisemeNode:
		return SFVisemeNode_V1_NUMBITS;
	default:
		return 0;
	}
}




u32 NDT_V2_GetNodeTag(u32 Context_NDT_Tag, u32 NodeType)
{
	if (!NodeType) return 0;
	/* adjust according to the table version */
	/* v2: 0 reserved for extensions, 1 reserved for protos */
	if (NodeType == 1) return 0;
	NodeType -= 2;
	switch (Context_NDT_Tag) {
	case NDT_SFWorldNode:
		if (NodeType >= SFWorldNode_V2_Count) return 0;
		return SFWorldNode_V2_TypeToTag[NodeType];
	case NDT_SF3DNode:
		if (NodeType >= SF3DNode_V2_Count) return 0;
		return SF3DNode_V2_TypeToTag[NodeType];
	case NDT_SF2DNode:
		if (NodeType >= SF2DNode_V2_Count) return 0;
		return SF2DNode_V2_TypeToTag[NodeType];
	case NDT_SFGeometryNode:
		if (NodeType >= SFGeometryNode_V2_Count) return 0;
		return SFGeometryNode_V2_TypeToTag[NodeType];
	case NDT_SFMaterialNode:
		if (NodeType >= SFMaterialNode_V2_Count) return 0;
		return SFMaterialNode_V2_TypeToTag[NodeType];
	case NDT_SFBAPNode:
		if (NodeType >= SFBAPNode_V2_Count) return 0;
		return SFBAPNode_V2_TypeToTag[NodeType];
	case NDT_SFBDPNode:
		if (NodeType >= SFBDPNode_V2_Count) return 0;
		return SFBDPNode_V2_TypeToTag[NodeType];
	case NDT_SFBodyDefTableNode:
		if (NodeType >= SFBodyDefTableNode_V2_Count) return 0;
		return SFBodyDefTableNode_V2_TypeToTag[NodeType];
	case NDT_SFBodySegmentConnectionHintNode:
		if (NodeType >= SFBodySegmentConnectionHintNode_V2_Count) return 0;
		return SFBodySegmentConnectionHintNode_V2_TypeToTag[NodeType];
	case NDT_SFPerceptualParameterNode:
		if (NodeType >= SFPerceptualParameterNode_V2_Count) return 0;
		return SFPerceptualParameterNode_V2_TypeToTag[NodeType];
	default:
		return 0;
	}
}


u32 NDT_V2_GetNumBits(u32 NDT_Tag)
{
	switch (NDT_Tag) {
	case NDT_SFWorldNode:
		return SFWorldNode_V2_NUMBITS;
	case NDT_SF3DNode:
		return SF3DNode_V2_NUMBITS;
	case NDT_SF2DNode:
		return SF2DNode_V2_NUMBITS;
	case NDT_SFGeometryNode:
		return SFGeometryNode_V2_NUMBITS;
	case NDT_SFMaterialNode:
		return SFMaterialNode_V2_NUMBITS;
	case NDT_SFBAPNode:
		return SFBAPNode_V2_NUMBITS;
	case NDT_SFBDPNode:
		return SFBDPNode_V2_NUMBITS;
	case NDT_SFBodyDefTableNode:
		return SFBodyDefTableNode_V2_NUMBITS;
	case NDT_SFBodySegmentConnectionHintNode:
		return SFBodySegmentConnectionHintNode_V2_NUMBITS;
	case NDT_SFPerceptualParameterNode:
		return SFPerceptualParameterNode_V2_NUMBITS;
	default:
		return 1;
	}
}




u32 NDT_V3_GetNodeTag(u32 Context_NDT_Tag, u32 NodeType)
{
	if (!NodeType) return 0;
	/* adjust according to the table version */
	/* v3: 0 reserved for extensions */
	NodeType -= 1;
	switch (Context_NDT_Tag) {
	case NDT_SFWorldNode:
		if (NodeType >= SFWorldNode_V3_Count) return 0;
		return SFWorldNode_V3_TypeToTag[NodeType];
	case NDT_SF3DNode:
		if (NodeType >= SF3DNode_V3_Count) return 0;
		return SF3DNode_V3_TypeToTag[NodeType];
	case NDT_SF2DNode:
		if (NodeType >= SF2DNode_V3_Count) return 0;
		return SF2DNode_V3_TypeToTag[NodeType];
	case NDT_SFTemporalNode:
		if (NodeType >= SFTemporalNode_V3_Count) return 0;
		return SFTemporalNode_V3_TypeToTag[NodeType];
	default:
		return 0;
	}
}


u32 NDT_V3_GetNumBits(u32 NDT_Tag)
{
	switch (NDT_Tag) {
	case NDT_SFWorldNode:
		return SFWorldNode_V3_NUMBITS;
	case NDT_SF3DNode:
		return SF3DNode_V3_NUMBITS;
	case NDT_SF2DNode:
		return SF2DNode_V3_NUMBITS;
	case NDT_SFTemporalNode:
		return SFTemporalNode_V3_NUMBITS;
	default:
		return 0;
	}
}




u32 NDT_V4_GetNodeTag(u32 Context_NDT_Tag, u32 NodeType)
{
	if (!NodeType) return 0;
	/* adjust according to the table version */
	/* v4: 0 reserved for extensions */
	NodeType -= 1;
	switch (Context_NDT_Tag) {
	case NDT_SFWorldNode:
		if (NodeType >= SFWorldNode_V4_Count) return 0;
		return SFWorldNode_V4_TypeToTag[NodeType];
	case NDT_SF3DNode:
		if (NodeType >= SF3DNode_V4_Count) return 0;
		return SF3DNode_V4_TypeToTag[NodeType];
	case NDT_SF2DNode:
		if (NodeType >= SF2DNode_V4_Count) return 0;
		return SF2DNode_V4_TypeToTag[NodeType];
	case NDT_SFTextureNode:
		if (NodeType >= SFTextureNode_V4_Count) return 0;
		return SFTextureNode_V4_TypeToTag[NodeType];
	default:
		return 0;
	}
}


u32 NDT_V4_GetNumBits(u32 NDT_Tag)
{
	switch (NDT_Tag) {
	case NDT_SFWorldNode:
		return SFWorldNode_V4_NUMBITS;
	case NDT_SF3DNode:
		return SF3DNode_V4_NUMBITS;
	case NDT_SF2DNode:
		return SF2DNode_V4_NUMBITS;
	case NDT_SFTextureNode:
		return SFTextureNode_V4_NUMBITS;
	default:
		return 0;
	}
}




u32 NDT_V5_GetNodeTag(u32 Context_NDT_Tag, u32 NodeType)
{
	if (!NodeType) return 0;
	/* adjust according to the table version */
	/* v5: 0 reserved for extensions */
	NodeType -= 1;
	switch (Context_NDT_Tag) {
	case NDT_SFWorldNode:
		if (NodeType >= SFWorldNode_V5_Count) return 0;
		return SFWorldNode_V5_TypeToTag[NodeType];
	case NDT_SF3DNode:
		if (NodeType >= SF3DNode_V5_Count) return 0;
		return SF3DNode_V5_TypeToTag[NodeType];
	case NDT_SF2DNode:
		if (NodeType >= SF2DNode_V5_Count) return 0;
		return SF2DNode_V5_TypeToTag[NodeType];
	case NDT_SFAppearanceNode:
		if (NodeType >= SFAppearanceNode_V5_Count) return 0;
		return SFAppearanceNode_V5_TypeToTag[NodeType];
	case NDT_SFGeometryNode:
		if (NodeType >= SFGeometryNode_V5_Count) return 0;
		return SFGeometryNode_V5_TypeToTag[NodeType];
	case NDT_SFTextureNode:
		if (NodeType >= SFTextureNode_V5_Count) return 0;
		return SFTextureNode_V5_TypeToTag[NodeType];
	case NDT_SFDepthImageNode:
		if (NodeType >= SFDepthImageNode_V5_Count) return 0;
		return SFDepthImageNode_V5_TypeToTag[NodeType];
	case NDT_SFBlendListNode:
		if (NodeType >= SFBlendListNode_V5_Count) return 0;
		return SFBlendListNode_V5_TypeToTag[NodeType];
	case NDT_SFFrameListNode:
		if (NodeType >= SFFrameListNode_V5_Count) return 0;
		return SFFrameListNode_V5_TypeToTag[NodeType];
	case NDT_SFLightMapNode:
		if (NodeType >= SFLightMapNode_V5_Count) return 0;
		return SFLightMapNode_V5_TypeToTag[NodeType];
	case NDT_SFSurfaceMapNode:
		if (NodeType >= SFSurfaceMapNode_V5_Count) return 0;
		return SFSurfaceMapNode_V5_TypeToTag[NodeType];
	case NDT_SFViewMapNode:
		if (NodeType >= SFViewMapNode_V5_Count) return 0;
		return SFViewMapNode_V5_TypeToTag[NodeType];
	case NDT_SFParticleInitializerNode:
		if (NodeType >= SFParticleInitializerNode_V5_Count) return 0;
		return SFParticleInitializerNode_V5_TypeToTag[NodeType];
	case NDT_SFInfluenceNode:
		if (NodeType >= SFInfluenceNode_V5_Count) return 0;
		return SFInfluenceNode_V5_TypeToTag[NodeType];
	case NDT_SFDepthTextureNode:
		if (NodeType >= SFDepthTextureNode_V5_Count) return 0;
		return SFDepthTextureNode_V5_TypeToTag[NodeType];
	case NDT_SFSBBoneNode:
		if (NodeType >= SFSBBoneNode_V5_Count) return 0;
		return SFSBBoneNode_V5_TypeToTag[NodeType];
	case NDT_SFSBMuscleNode:
		if (NodeType >= SFSBMuscleNode_V5_Count) return 0;
		return SFSBMuscleNode_V5_TypeToTag[NodeType];
	case NDT_SFSBSegmentNode:
		if (NodeType >= SFSBSegmentNode_V5_Count) return 0;
		return SFSBSegmentNode_V5_TypeToTag[NodeType];
	case NDT_SFSBSiteNode:
		if (NodeType >= SFSBSiteNode_V5_Count) return 0;
		return SFSBSiteNode_V5_TypeToTag[NodeType];
	case NDT_SFBaseMeshNode:
		if (NodeType >= SFBaseMeshNode_V5_Count) return 0;
		return SFBaseMeshNode_V5_TypeToTag[NodeType];
	case NDT_SFSubdivSurfaceSectorNode:
		if (NodeType >= SFSubdivSurfaceSectorNode_V5_Count) return 0;
		return SFSubdivSurfaceSectorNode_V5_TypeToTag[NodeType];
	default:
		return 0;
	}
}


u32 NDT_V5_GetNumBits(u32 NDT_Tag)
{
	switch (NDT_Tag) {
	case NDT_SFWorldNode:
		return SFWorldNode_V5_NUMBITS;
	case NDT_SF3DNode:
		return SF3DNode_V5_NUMBITS;
	case NDT_SF2DNode:
		return SF2DNode_V5_NUMBITS;
	case NDT_SFAppearanceNode:
		return SFAppearanceNode_V5_NUMBITS;
	case NDT_SFGeometryNode:
		return SFGeometryNode_V5_NUMBITS;
	case NDT_SFTextureNode:
		return SFTextureNode_V5_NUMBITS;
	case NDT_SFDepthImageNode:
		return SFDepthImageNode_V5_NUMBITS;
	case NDT_SFBlendListNode:
		return SFBlendListNode_V5_NUMBITS;
	case NDT_SFFrameListNode:
		return SFFrameListNode_V5_NUMBITS;
	case NDT_SFLightMapNode:
		return SFLightMapNode_V5_NUMBITS;
	case NDT_SFSurfaceMapNode:
		return SFSurfaceMapNode_V5_NUMBITS;
	case NDT_SFViewMapNode:
		return SFViewMapNode_V5_NUMBITS;
	case NDT_SFParticleInitializerNode:
		return SFParticleInitializerNode_V5_NUMBITS;
	case NDT_SFInfluenceNode:
		return SFInfluenceNode_V5_NUMBITS;
	case NDT_SFDepthTextureNode:
		return SFDepthTextureNode_V5_NUMBITS;
	case NDT_SFSBBoneNode:
		return SFSBBoneNode_V5_NUMBITS;
	case NDT_SFSBMuscleNode:
		return SFSBMuscleNode_V5_NUMBITS;
	case NDT_SFSBSegmentNode:
		return SFSBSegmentNode_V5_NUMBITS;
	case NDT_SFSBSiteNode:
		return SFSBSiteNode_V5_NUMBITS;
	case NDT_SFBaseMeshNode:
		return SFBaseMeshNode_V5_NUMBITS;
	case NDT_SFSubdivSurfaceSectorNode:
		return SFSubdivSurfaceSectorNode_V5_NUMBITS;
	default:
		return 0;
	}
}




u32 NDT_V6_GetNodeTag(u32 Context_NDT_Tag, u32 NodeType)
{
	if (!NodeType) return 0;
	/* adjust according to the table version */
	/* v6: 0 reserved for extensions */
	NodeType -= 1;
	switch (Context_NDT_Tag) {
	case NDT_SFWorldNode:
		if (NodeType >= SFWorldNode_V6_Count) return 0;
		return SFWorldNode_V6_TypeToTag[NodeType];
	case NDT_SF3DNode:
		if (NodeType >= SF3DNode_V6_Count) return 0;
		return SF3DNode_V6_TypeToTag[NodeType];
	case NDT_SF2DNode:
		if (NodeType >= SF2DNode_V6_Count) return 0;
		return SF2DNode_V6_TypeToTag[NodeType];
	case NDT_SFGeometryNode:
		if (NodeType >= SFGeometryNode_V6_Count) return 0;
		return SFGeometryNode_V6_TypeToTag[NodeType];
	case NDT_SFTextureNode:
		if (NodeType >= SFTextureNode_V6_Count) return 0;
		return SFTextureNode_V6_TypeToTag[NodeType];
	case NDT_SFFontStyleNode:
		if (NodeType >= SFFontStyleNode_V6_Count) return 0;
		return SFFontStyleNode_V6_TypeToTag[NodeType];
	case NDT_SFLinePropertiesNode:
		if (NodeType >= SFLinePropertiesNode_V6_Count) return 0;
		return SFLinePropertiesNode_V6_TypeToTag[NodeType];
	case NDT_SFTextureTransformNode:
		if (NodeType >= SFTextureTransformNode_V6_Count) return 0;
		return SFTextureTransformNode_V6_TypeToTag[NodeType];
	case NDT_SFViewportNode:
		if (NodeType >= SFViewportNode_V6_Count) return 0;
		return SFViewportNode_V6_TypeToTag[NodeType];
	default:
		return 0;
	}
}


u32 NDT_V6_GetNumBits(u32 NDT_Tag)
{
	switch (NDT_Tag) {
	case NDT_SFWorldNode:
		return SFWorldNode_V6_NUMBITS;
	case NDT_SF3DNode:
		return SF3DNode_V6_NUMBITS;
	case NDT_SF2DNode:
		return SF2DNode_V6_NUMBITS;
	case NDT_SFGeometryNode:
		return SFGeometryNode_V6_NUMBITS;
	case NDT_SFTextureNode:
		return SFTextureNode_V6_NUMBITS;
	case NDT_SFFontStyleNode:
		return SFFontStyleNode_V6_NUMBITS;
	case NDT_SFLinePropertiesNode:
		return SFLinePropertiesNode_V6_NUMBITS;
	case NDT_SFTextureTransformNode:
		return SFTextureTransformNode_V6_NUMBITS;
	case NDT_SFViewportNode:
		return SFViewportNode_V6_NUMBITS;
	default:
		return 0;
	}
}



u32 NDT_GetNodeTag(u32 NDT_Tag, u32 NodeType, u32 Version)
{
	switch (Version) {
	case BIFS_V1:
		return NDT_V1_GetNodeTag(NDT_Tag, NodeType);
	case BIFS_V2:
		return NDT_V2_GetNodeTag(NDT_Tag, NodeType);
	case BIFS_V3:
		return NDT_V3_GetNodeTag(NDT_Tag, NodeType);
	case BIFS_V4:
		return NDT_V4_GetNodeTag(NDT_Tag, NodeType);
	case BIFS_V5:
		return NDT_V5_GetNodeTag(NDT_Tag, NodeType);
	case BIFS_V6:
		return NDT_V6_GetNodeTag(NDT_Tag, NodeType);
	default:
		return 0;
	}
}

u32 NDT_GetNumBits(u32 NDT_Tag, u32 Version)
{
	switch (Version) {
	case BIFS_V1:
		return NDT_V1_GetNumBits(NDT_Tag);
	case BIFS_V2:
		return NDT_V2_GetNumBits(NDT_Tag);
	case BIFS_V3:
		return NDT_V3_GetNumBits(NDT_Tag);
	case BIFS_V4:
		return NDT_V4_GetNumBits(NDT_Tag);
	case BIFS_V5:
		return NDT_V5_GetNumBits(NDT_Tag);
	case BIFS_V6:
		return NDT_V6_GetNumBits(NDT_Tag);
	default:
		return 0;
	}
}u32 GetChildrenNDT(SFNode *node)
{
	if (!node) return 0;
	switch (Node_GetTag(node)) {
	case TAG_Anchor:
		return NDT_SF3DNode;
	case TAG_AudioBuffer:
		return NDT_SFAudioNode;
	case TAG_AudioDelay:
		return NDT_SFAudioNode;
	case TAG_AudioFX:
		return NDT_SFAudioNode;
	case TAG_AudioMix:
		return NDT_SFAudioNode;
	case TAG_AudioSource:
		return NDT_SFAudioNode;
	case TAG_AudioSwitch:
		return NDT_SFAudioNode;
	case TAG_Billboard:
		return NDT_SF3DNode;
	case TAG_Collision:
		return NDT_SF3DNode;
	case TAG_CompositeTexture2D:
		return NDT_SF2DNode;
	case TAG_CompositeTexture3D:
		return NDT_SF3DNode;
	case TAG_Form:
		return NDT_SF2DNode;
	case TAG_Group:
		return NDT_SF3DNode;
	case TAG_Layer2D:
		return NDT_SF2DNode;
	case TAG_Layer3D:
		return NDT_SF3DNode;
	case TAG_Layout:
		return NDT_SF2DNode;
	case TAG_OrderedGroup:
		return NDT_SF3DNode;
	case TAG_Transform:
		return NDT_SF3DNode;
	case TAG_Transform2D:
		return NDT_SF2DNode;
	case TAG_TemporalTransform:
		return NDT_SF3DNode;
	case TAG_TemporalGroup:
		return NDT_SFTemporalNode;
	case TAG_Clipper2D:
		return NDT_SF2DNode;
	case TAG_ColorTransform:
		return NDT_SF3DNode;
	case TAG_PathLayout:
		return NDT_SF2DNode;
	case TAG_TransformMatrix2D:
		return NDT_SF2DNode;
	default:
		return 0;
	}
}

