/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003 
 *					All rights reserved
 *
 *  This file is part of GPAC / Stream Management sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */

#include <gpac/intern/m4_esm_dev.h>

Bool net_check_interface(NetClientPlugin *ifce)
{
	if (!ifce->CanHandleURL) return 0;
	if (!ifce->ConnectService) return 0;
	if (!ifce->CloseService) return 0;
	if (!ifce->ConnectChannel) return 0;
	if (!ifce->DisconnectChannel) return 0;
	if (!ifce->Get_MPEG4_IOD) return 0;
	if (!ifce->GetStatus) return 0;
	if (!ifce->ServiceCommand) return 0;
	return 1;
}

LPNETSERVICE NM_NewService(struct _m4_client *term, struct _od_manager *owner, const char *url, LPNETSERVICE parent_service)
{
	LPNETSERVICE serv;
	u32 i;
	char *sURL;
	NetClientPlugin *ifce;

	if (!url) return NULL;

	if (parent_service && parent_service->url) {
		sURL = URL_Concatenate(parent_service->url, url);
		/*path was absolute*/
		if (!sURL) sURL = strdup(url);
	} else {
		sURL = strdup(url);
	}

	/*browse all plugins*/
	ifce = NULL;
	for (i=0; i< PM_GetPluginsCount(term->user->plugins); i++) {
		PM_LoadInterface(term->user->plugins, i, M4STREAMINGCLIENT, (void **) &ifce);
		if (!ifce) continue;
		if (net_check_interface(ifce) && ifce->CanHandleURL(ifce, sURL)) break;
		PM_ShutdownInterface(ifce);
		ifce = NULL;
	}
	if (!ifce) {
		free(sURL);
		return NULL;
	}
	serv = malloc(sizeof(NetService));
	memset(serv, 0, sizeof(NetService));
	serv->term = term;
	serv->owner = owner;
	serv->ifce = ifce;
	serv->url = sURL;
	serv->Clocks = NewChain();
	ChainAddEntry(term->net_services, serv);
	return serv;
}

M4Err NM_OpenService(LPNETSERVICE ns)
{
	return ns->ifce->ConnectService(ns->ifce, ns, ns->url);
}
M4Err NM_CloseService(LPNETSERVICE ns) 
{ 
	return ns->ifce->CloseService(ns->ifce, 0); 
}
Bool NM_CanHandleURLInService(LPNETSERVICE ns, char *url)
{
	if (!ns->ifce->CanHandleURLInService) return 0;
	return ns->ifce->CanHandleURLInService(ns->ifce, url);
}
M4Err NM_GetStatus(LPNETSERVICE serv, LPNETCHANNEL channel, u32 *status) 
{
	return serv->ifce->GetStatus(serv->ifce, channel, status); 
}
M4Err NM_Get_MPEG4_IOD(LPNETSERVICE ns, u32 expect_type, char **raw_iod, u32 *raw_iod_size) 
{
	return ns->ifce->Get_MPEG4_IOD(ns->ifce, expect_type, raw_iod, raw_iod_size); 
}
M4Err NM_ConnectChannel(LPNETSERVICE ns, LPNETCHANNEL channel, const char *url, Bool upstream) 
{ 
	return ns->ifce->ConnectChannel(ns->ifce, channel, url, upstream); 
}
M4Err NM_DisconnectChannel(LPNETSERVICE ns, LPNETCHANNEL channel) 
{
	return ns->ifce->DisconnectChannel(ns->ifce, channel); 
}
M4Err NM_ServiceCommand(LPNETSERVICE ns, NetworkCommand *com) 
{ 
	return ns->ifce->ServiceCommand(ns->ifce, com); 
}
M4Err NM_ChannelGetSLP(LPNETSERVICE ns, LPNETCHANNEL channel, char **out_data_ptr, u32 *out_data_size, struct tagSLHeader *out_sl_hdr, Bool *sl_compressed, M4Err *out_reception_status, Bool *is_new_data)
{
	if (!ns->ifce->ChannelGetSLP) return M4NotSupported;
	return ns->ifce->ChannelGetSLP(ns->ifce, channel, out_data_ptr, out_data_size, out_sl_hdr, sl_compressed, out_reception_status, is_new_data);
}
M4Err NM_ChannelReleaseSLP(LPNETSERVICE ns, LPNETCHANNEL channel)
{
	if (!ns->ifce->ChannelGetSLP) return M4NotSupported;
	return ns->ifce->ChannelReleaseSLP(ns->ifce, channel);
}
void NM_OnMessage(LPNETSERVICE service, M4Err error, const char *message)
{
	assert(service);
	service->term->client_sink.on_message(service->term, service, error, message);
}
void NM_OnConnect(LPNETSERVICE service, LPNETCHANNEL ns, M4Err response)
{
	assert(service);
	service->term->client_sink.on_connect(service->term, service, ns, response);
}
void NM_OnDisconnect(LPNETSERVICE service, LPNETCHANNEL ns, M4Err response)
{
	assert(service);
	service->term->client_sink.on_disconnect(service->term, service, ns, response);
}
void NM_OnCommand(LPNETSERVICE service, NetworkCommand *com)
{
	assert(service);
	service->term->client_sink.on_command(service->term, service, com);
}
void NM_OnSLPRecieved(LPNETSERVICE service, LPNETCHANNEL ns, char *data, u32 data_size, struct tagSLHeader *hdr, M4Err reception_status)
{
	assert(service);
	service->term->client_sink.on_slp_recieved(service->term, service, ns, data, data_size, hdr, reception_status);
}
const char *NM_GetServiceURL(LPNETSERVICE service)
{
	if (!service) return NULL;
	return service->url;
}
