/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2003 
 *					All rights reserved
 *
 *  This file is part of GPAC / Stream Management sub-project
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 */


#include <gpac/m4_render.h>
#include <gpac/intern/m4_esm_dev.h>
#include "InputSensor.h"

void Inline_Modified(SFNode *node);
void InitMediaControl(InlineScene *is, SFNode *node);
void MC_Modified(SFNode *node);
void InitMediaSensor(InlineScene *is, SFNode *node);
void MS_Modified(SFNode *node);


#ifdef M4_DEF_WorldInfo
void Destroy_WorldInfo(SFNode *node)
{
	InlineScene *is = Node_GetPrivate(node);
	is->world_info = NULL;
}
void Render_WorldInfo(SFNode *node, void *rs)
{
	InlineScene *is = Node_GetPrivate(node);
	is->world_info = (B_WorldInfo *) node;
}
#endif

void M4_NodeInit(void *_is, SFNode *node)
{
	InlineScene *is = (InlineScene *)_is;
	if (!node || !is) return;
	
	switch (Node_GetTag(node)) {
#ifdef M4_DEF_Inline
	case TAG_Inline: Node_SetRenderFunction(node, IS_Render); break;
#endif

#ifdef M4_DEF_MediaBuffer
	case TAG_MediaBuffer: break;
#endif
#ifdef M4_DEF_MediaControl
	case TAG_MediaControl: InitMediaControl(is, node); break;
#endif
#ifdef M4_DEF_MediaSensor
	case TAG_MediaSensor: InitMediaSensor(is, node); break;
#endif

#ifdef M4_DEF_InputSensor
	case TAG_InputSensor: InitInputSensor(is, node); break;
#endif

	/*BIFS nodes, get back to codec, but filter externProtos*/
#ifdef M4_DEF_Conditional
	case TAG_Conditional: break;
#endif
#ifdef M4_DEF_QuantizationParameter
	case TAG_QuantizationParameter: break;
#endif

	/*world info is stored at the inline scene level*/
#ifdef M4_DEF_WorldInfo
	case TAG_WorldInfo:
		Node_SetPreDestroyFunction(node, Destroy_WorldInfo);
		Node_SetRenderFunction(node, Render_WorldInfo);
		Node_SetPrivate(node, is);
		break;
#endif

	default: SR_NodeInit(is->root_od->term->renderer, node); break;
	}
}

void M4_NodeModified(void *_is, SFNode *node)
{
	InlineScene *is = (InlineScene *)_is;
	if (!node || !is) return;
	
	switch (Node_GetTag(node)) {
#ifdef M4_DEF_Inline
	case TAG_Inline: Inline_Modified(node); break;
#endif
#ifdef M4_DEF_MediaBuffer
	case TAG_MediaBuffer: break;
#endif
#ifdef M4_DEF_MediaControl
	case TAG_MediaControl: MC_Modified(node); break;
#endif
#ifdef M4_DEF_MediaSensor
	case TAG_MediaSensor: MS_Modified(node); break;
#endif
#ifdef M4_DEF_InputSensor
	case TAG_InputSensor: InputSensorModified(node); break;
#endif
#ifdef M4_DEF_Conditional
	case TAG_Conditional: break;
#endif

	default: SR_Invalidate(is->root_od->term->renderer, node); break;
	}
}
