#include "V4SceneGraph.h"
#include <gpac/m4_author.h>

void node_init(void *cbkObject, SFNode *node)
{
	switch (Node_GetTag(node)) {
	case TAG_Conditional:
	case TAG_QuantizationParameter:
		break;
	default:
		SR_NodeInit(((V4SceneGraph *)cbkObject)->GetSceneRenderer(), node);
		break;
	}
}

V4SceneGraph::V4SceneGraph()
{
	m_pSm = NULL;
	m_pSg = NULL;
	m_pSr = NULL;
	m_pOriginal_mp4 = NULL;
	m_bEncodeNames = 0;
	LoadNew();
}

V4SceneGraph::~V4SceneGraph()
{
	if (m_pSm) M4SM_Delete(m_pSm);
	if (m_pOriginal_mp4) free(m_pOriginal_mp4);
}

void V4SceneGraph::SetSceneSize(int w, int h)
{
	SG_SetSizeInfo(m_pSg, w,h, 1);
	/*reassign scene graph to update scene size in renderer*/
	SR_SetSceneGraph(m_pSr, m_pSg);
}

void V4SceneGraph::GetSceneSize(wxSize &size) 
{
	SG_GetSizeInfo(m_pSg, (u32 *)&(size.x), (u32 *)&(size.y));	
}

SFNode *V4SceneGraph::SetTopNode(u32 tag) 
{
	B_OrderedGroup * root = (B_OrderedGroup *)NewNode(TAG_OrderedGroup);
	SG_SetRootNode(m_pSg, (SFNode *)root);
	return (SFNode *)root;
}


SFNode *V4SceneGraph::NewNode(u32 tag)
{
	SFNode *n = SG_NewNode(m_pSg, tag);
	if (!n) return NULL;
	Node_Init(n);
	return n;
}

void V4SceneGraph::SaveFile(const char *path) 
{
	M4File *mp4 = M4_MovieOpen(path, M4_WRITE_EDIT);
	M4SM_EncodeFile(m_pSm, mp4, NULL, m_pOriginal_mp4, m_bEncodeNames ? M4SM_EncodeNames : 0, 0);
	M4_MovieClose(mp4);
}

void V4SceneGraph::LoadNew() 
{
	if (m_pSm) {
		SR_SetSceneGraph(m_pSr, NULL);
		m_pSg = NULL;
		M4SM_Delete(m_pSm);
	}
	m_pSm = NewSceneManager();
	if (m_pOriginal_mp4) free(m_pOriginal_mp4);
	m_pOriginal_mp4 = NULL;
	/* Create a BIFS stream with one AU with on ReplaceScene */
	M4StreamContext *sc = M4SM_NewStream(m_pSm, 1, 3, 0);
	M4AUContext *au = M4SM_NewAU(sc, 0, 0, 1);
	SGCommand *command = SG_NewCommand(SG_SceneReplace);
	command->graph = m_pSg = NewSceneGraph(node_init, this, NULL, NULL);
	ChainAddEntry(au->commands, command);
	SR_SetSceneGraph(m_pSr, m_pSg);
}

void V4SceneGraph::LoadBTFile(const char *path) 
{
	if (m_pSm) {
		SR_SetSceneGraph(m_pSr, NULL);
		m_pSg = NULL;
		M4SM_Delete(m_pSm);
	}
	m_pSm = NewSceneManager();
	if (m_pOriginal_mp4) free(m_pOriginal_mp4);
	m_pOriginal_mp4 = NULL;
	FILE *input = fopen(path, "rt");
	M4SM_LoadContextFromBT(m_pSm, input, node_init, NULL, this);
	M4StreamContext *sc = (M4StreamContext *) ChainGetEntry(m_pSm->streams,0);
	if (sc->streamType == 3) {
		M4AUContext *au = (M4AUContext *) ChainGetEntry(sc->AUs,0);
		SGCommand *c = (SGCommand *) ChainGetEntry(au->commands,0);
		m_pSg = c->graph;
		for (u32 i=0; i<ChainGetCount(m_pSm->root_od->ESDescriptors); i++) {
			ESDescriptor *es = (ESDescriptor *)ChainGetEntry(m_pSm->root_od->ESDescriptors, i);
			if (es->decoderConfig->streamType != 3) continue;
			BIFSConfigDescriptor *bcfg = (BIFSConfigDescriptor *)es->decoderConfig->decoderSpecificInfo;
			SG_SetSizeInfo(m_pSg, bcfg->pixelWidth, bcfg->pixelHeight, bcfg->pixelMetrics);
			break;
		}
	}
	fclose(input);
	SR_SetSceneGraph(m_pSr, m_pSg);
}

void V4SceneGraph::LoadMP4File(const char *path) 
{
	if (m_pSm) {
		SR_SetSceneGraph(m_pSr, NULL);
		m_pSg = NULL;
		M4SM_Delete(m_pSm);
	}
	if (m_pOriginal_mp4) free(m_pOriginal_mp4);
	m_pOriginal_mp4 = strdup(path);
	m_pSm = NewSceneManager();
	M4File *input = M4_MovieOpen(path, M4_OPEN_READ);
	M4SM_LoadContextFromMP4(m_pSm, input, node_init, NULL, this);
	M4StreamContext *sc = (M4StreamContext *) ChainGetEntry(m_pSm->streams,0);
	if (sc->streamType == 3) {
		m_pSg = sc->scene_context;
		for (u32 i=0; i<ChainGetCount(m_pSm->root_od->ESDescriptors); i++) {
			ESDescriptor *es = (ESDescriptor *)ChainGetEntry(m_pSm->root_od->ESDescriptors, i);
			if (es->decoderConfig->streamType != 3) continue;
			BIFSConfigDescriptor bcfg;
			if (OD_GetBIFSConfig(es->decoderConfig->decoderSpecificInfo, es->decoderConfig->objectTypeIndication, &bcfg) != M4OK) continue;;
			SG_SetSizeInfo(m_pSg, bcfg.pixelWidth, bcfg.pixelHeight, bcfg.pixelMetrics);
			break;
		}
	}
	M4_MovieClose(input);
	SR_SetSceneGraph(m_pSr, m_pSg);
}

SFNode *V4SceneGraph::CopyNode(SFNode *node, SFNode *parent, bool copy) 
{
	if (copy) return CloneNodeForEditing(m_pSg, node);
	u32 nodeID = Node_GetID(node);
	if (!nodeID) {
		nodeID = SG_GetNextNodeID(m_pSg);
		Node_SetDEF(node, nodeID, NULL);
		Node_Register(node, parent);
	}
	return node;
}

void V4SceneGraph::LoadCommand(u32 commandNumber)
{
	M4StreamContext *sc = NULL;
	for (u32 i=0; i<ChainGetCount(m_pSm->streams); i++) {
		sc = (M4StreamContext *) ChainGetEntry(m_pSm->streams, i);
		if (sc->streamType == M4ST_BIFS) break;
		sc = NULL;
	}
	assert(sc);
	M4AUContext *au = (M4AUContext *) ChainGetEntry(sc->AUs,0);
	if (commandNumber < ChainGetCount(au->commands)) {
		for (u32 j=0; j<=commandNumber; j++) {
			SGCommand *c = (SGCommand *) ChainGetEntry(au->commands, j);
			SG_ApplyCommand(m_pSg, c);
		}
	}
}



extern "C" {

SFNode *CloneNodeForEditing(LPSCENEGRAPH inScene, SFNode *orig) //, SFNode *cloned_parent)
{
	u32 i, j, count;
	SFNode *node, *child, *tmp;
	Chain *list, *list2;
	FieldInfo field_orig, field;

	/*this is not a mistake*/
	if (!orig) return NULL;

	/*check for DEF/USE
	if (orig->sgprivate->NodeID) {
		node = SG_FindNode(inScene, orig->sgprivate->NodeID);
		//node already created, USE
		if (node) {
			Node_Register(node, cloned_parent);
			return node;
		}
	}
	*/
	/*create a node*/
/*
	if (orig->sgprivate->tag == TAG_ProtoNode) {
		proto_node = ((ProtoInstance *)orig)->proto_interface;
		//create the instance but don't load the code -c we MUST wait for ISed routes to be cloned before
		node = Proto_CreateNode(inScene, proto_node, (ProtoInstance *) orig);
	} else {
*/
	node = SG_NewNode(inScene, Node_GetTag(orig));
//	}

	count = Node_GetNumFields(orig, FCM_ALL);

/*
#ifdef M4_DEF_Script
	if (orig->sgprivate->tag==TAG_Script) 
		Script_PrepareClone(node, orig);
#endif
*/
	/*copy each field*/
	for (i=0; i<count; i++) {
		Node_GetField(orig, i, &field_orig);

		/*get target ptr*/
		Node_GetField(node, i, &field);

		assert(field.eventType==field_orig.eventType);
		assert(field.fieldType==field_orig.fieldType);

		/*duplicate it*/
		switch (field.fieldType) {
		case FT_SFNode:
			child = CloneNodeForEditing(inScene, (SFNode *) (* ((SFNode **) field_orig.far_ptr)));//, node);
			*((SFNode **) field.far_ptr) = child;
			break;
		case FT_MFNode:
			list = *( (Chain **) field_orig.far_ptr);
			list2 = *( (Chain **) field.far_ptr);

			for (j=0; j<ChainGetCount(list); j++) {
				tmp = (SFNode *)ChainGetEntry(list, j);
				child = CloneNodeForEditing(inScene, tmp);//, node);
				ChainAddEntry(list2, child);
			}
			break;
		default:
			SG_CopyField(field.far_ptr, field_orig.far_ptr, field.fieldType);
			break;
		}
	}
	/*register node
	if (orig->sgprivate->NodeID) {
		Node_SetID(node, orig->sgprivate->NodeID);
		Node_Register(node, cloned_parent);
	}*/

	/*init node before creating ISed routes so the eventIn handler are in place*/
	if (Node_GetTag(node) != TAG_ProtoNode) Node_Init(node);

	return node;
}

}
