/*
 *			GPAC - MPEG-4 Systems C Development Kit
 *
 *			Copyright (c) Jean Le Feuvre 2000-2004
 *					All rights reserved
 *
 *  This file is part of GPAC / Osmo4 wxWidgets GUI
 *
 *  GPAC is free software; you can redistribute it and/or modify
 *  it under the terms of the GNU General Public License as published by
 *  the Free Software Foundation; either version 2, or (at your option)
 *  any later version.
 *   
 *  GPAC is distributed in the hope that it will be useful,
 *  but WITHOUT ANY WARRANTY; without even the implied warranty of
 *  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
 *  GNU General Public License for more details.
 *   
 *  You should have received a copy of the GNU General Public License
 *  along with GNU Make; see the file COPYING.  If not, write to
 *  the Free Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA. 
 *
 *		
 */

#ifndef _OPTIONS_H
#define _OPTIONS_H

#include "wx/wxprec.h"

#ifndef WX_PRECOMP
  #include "wx/wx.h"
#endif

#include <wx/spinbutt.h>
#include <wx/spinctrl.h>

enum
{
	ID_SELECT = 1000,
	ID_APPLY,

	ID_MAKE_DEF,
	ID_FORCE_AUDIO,
	ID_AUDIO_DRIVER,
	ID_FONT_DIR,
	ID_CACHE_DIR,
	ID_RTSP_PORT,
	ID_RTP_OVER_RTSP,
	ID_RTSP_REBUFFER,
};

class wxOsmo4Frame;
class wxGPACControl : public wxDialog 
{
public:
    wxGPACControl(wxWindow *parent);

private:
	DECLARE_EVENT_TABLE()

	wxOsmo4Frame *m_pApp;

	wxComboBox *m_select;
	Bool m_bWas3D;

	void Apply(wxCommandEvent &event);
	void OnSetSelection(wxCommandEvent &event);
	void ForceAudio(wxCommandEvent &event);
	void OnSetAudioDriver(wxCommandEvent &event);
	void FontDir(wxCommandEvent &event);
	void CacheDir(wxCommandEvent &event);
	void RTPoverRTSP(wxCommandEvent &event);
	void Rebuffer(wxCommandEvent &event);
	void OnSetRTSPPort(wxCommandEvent &event);
#ifdef WIN32
	void OnFileassoc(wxCommandEvent &event);
#endif
	void DoSelect();
	s32 m_sel;

	/*general section*/
	wxCheckBox *m_loop, *m_stopatend, *m_noconsole, *m_viewxmt;
#ifdef WIN32
	wxButton *m_makedefault;
#endif
	/*MPEG-4 systems*/
	wxStaticText *m_langtxt, *m_threadtxt;
	wxCheckBox *m_bifsalwaysdrawn, *m_singletime;
	wxComboBox *m_lang, *m_thread;

	/*media decoders*/
	wxStaticText *m_decaudiotxt, *m_decvideotxt;
	wxComboBox *m_decaudio, *m_decvideo;

	/*Rendering*/
	wxStaticText *m_fpstxt, *m_backtxt, *m_aatxt;
	wxComboBox *m_fps, *m_aa;
	wxCheckBox *m_use3D, *m_draw_bounds, *m_fast, *m_force_size;
	wxTextCtrl *m_back;

	/*Renderer 2D*/
	wxStaticText *m_graphtxt, *m_yuvtxt;
	wxComboBox *m_graph;
	wxCheckBox *m_noyuv, *m_direct, *m_scalable;

	/*Renderer 3D*/
	wxCheckBox *m_raster_outlines, *m_polyaa, *m_emulpow2, *m_norectext, *m_copypixels;
	wxStaticText *m_wiretxt;
	wxComboBox *m_wire;

	/*video*/
	wxStaticText *m_videotxt;
	wxComboBox *m_video;
	wxCheckBox *m_switchres;
	
	/*audio*/
	wxStaticText *m_nbbuftxt, *m_buflentxt, *m_audiotxt;
	wxSpinCtrl *m_nbbuf, *m_buflen;
	wxComboBox *m_audio;
	wxCheckBox *m_forcecfg, *m_noresync;
#ifdef WIN32
	wxCheckBox *m_notifs;
#endif

	/*font*/
	wxStaticText *m_fonttxt, *m_fontdirtxt;
	wxComboBox *m_font;
	wxButton *m_fontdir;

	/*file download*/
	wxStaticText *m_cachedirtxt;
	wxButton *m_cachedir;
	wxCheckBox *m_cleancache, *m_restartcache;

	/*streaming*/
	wxStaticText *m_porttxt, *m_timeouttxt, *m_buffertxt;
	wxComboBox *m_port;
	wxCheckBox *m_rtsp, *m_reorder, *m_dorebuffer;
	wxTextCtrl *m_timeout, *m_buffer, *m_rebuffer;
};

#endif

