// OptRender.cpp : implementation file
//

#include "stdafx.h"
#include "Osmo4.h"
#include "OptRender.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptRender dialog


COptRender::COptRender(CWnd* pParent /*=NULL*/)
	: CDialog(COptRender::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptRender)
	//}}AFX_DATA_INIT
}


void COptRender::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptRender)
	DDX_Control(pDX, IDC_FORCE_SIZE, m_ForceSize);
	DDX_Control(pDX, IDC_FAST_RENDER, m_FastRender);
	DDX_Control(pDX, IDC_ZOOM_SCALABLE, m_Scalable);
	DDX_Control(pDX, IDC_COLOR, m_Color);
	DDX_Control(pDX, IDC_DIRECTRENDER, m_DirectRender);
	DDX_Control(pDX, IDC_BIFS_RATE, m_BIFSRate);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptRender, CDialog)
	//{{AFX_MSG_MAP(COptRender)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptRender message handlers



#define NUM_RATES 11
static char *BIFSRates[11] = 
{
	"5.0",
	"7.5",
	"10.0",
	"12.5",
	"15.0",
	"24.0",
	"25.0",
	"30.0",
	"50.0",
	"60.0",
	"100.0",
};



BOOL COptRender::OnInitDialog() 
{
	CDialog::OnInitDialog();
	
	COsmo4 *gpac = GetApp();
	char *sOpt;
	
	sOpt = IF_GetKey(gpac->m_config, "Render2D", "DirectRender");
	if (sOpt && !stricmp(sOpt, "yes")) {
		m_DirectRender.SetCheck(1);
	} else {
		m_DirectRender.SetCheck(0);
	}
	sOpt = IF_GetKey(gpac->m_config, "Render2D", "ScalableZoom");
	if (sOpt && !stricmp(sOpt, "no")) {
		m_Scalable.SetCheck(0);
	} else {
		m_Scalable.SetCheck(1);
	}
	sOpt = IF_GetKey(gpac->m_config, "Rendering", "ForceSceneSize");
	if (sOpt && !stricmp(sOpt, "yes")) {
		m_ForceSize.SetCheck(1);
	} else {
		m_ForceSize.SetCheck(0);
	}

	sOpt = IF_GetKey(gpac->m_config, "Rendering", "BackColor");
	if (sOpt) {
		s32 col = atoi(sOpt);
		TCHAR sMsg[10];
		wsprintf(sMsg, _T("0x%.2x%.2x%.2x"), (col>>16) & 0xFF, (col>>8) & 0xFF, (col) & 0xFF);
		m_Color.SetWindowText(sMsg);
	} else {
		m_Color.SetWindowText(_T("0x000000"));
	}

	sOpt = IF_GetKey(gpac->m_config, "Rendering", "FrameRate");
	if (!sOpt) sOpt = "30.0";
	s32 select = 0;
	while (m_BIFSRate.GetCount()) m_BIFSRate.DeleteString(0);
	for (s32 i = 0; i<NUM_RATES; i++) {
		TCHAR szText[100];
		CE_CharToWide(BIFSRates[i], szText);
		m_BIFSRate.AddString(szText);
		if (sOpt && !stricmp(sOpt, BIFSRates[i]) ) select = i;
	}
	m_BIFSRate.SetCurSel(select);
	
	sOpt = IF_GetKey(gpac->m_config, "Rendering", "FastRender");
	if (sOpt && !stricmp(sOpt, "yes")) {
		m_FastRender.SetCheck(1);
	} else {
		m_FastRender.SetCheck(0);
	}
	
	return TRUE;  
}


void COptRender::SaveOptions()
{
	COsmo4 *gpac = GetApp();

	IF_SetKey(gpac->m_config, "Render2D", "DirectRender", m_DirectRender.GetCheck() ? "yes" : "no");
	IF_SetKey(gpac->m_config, "Render2D", "ScalableZoom", m_Scalable.GetCheck() ? "yes" : "no");
	IF_SetKey(gpac->m_config, "Rendering", "FastRender", m_FastRender.GetCheck() ? "yes" : "no");
	IF_SetKey(gpac->m_config, "Rendering", "ForceSceneSize", m_ForceSize.GetCheck() ? "yes" : "no");

	TCHAR wstr[20];
	char str[20];
	u32 col;
	m_Color.GetWindowText(wstr, 20);
	CE_WideToChar(wstr, str);

	sscanf(str, "0x%x", &col);
	sprintf(str, "%d", col);
	IF_SetKey(gpac->m_config, "Rendering", "BackColor", str);

	s32 sel = m_BIFSRate.GetCurSel();
	IF_SetKey(gpac->m_config, "Rendering", "FrameRate", BIFSRates[sel]);

}

