// OptFont.cpp : implementation file
//

#include "stdafx.h"
#include "Osmo4.h"
#include "OptFont.h"
#include <gpac/m4_graphics.h>

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// COptFont dialog


COptFont::COptFont(CWnd* pParent /*=NULL*/)
	: CDialog(COptFont::IDD, pParent)
{
	//{{AFX_DATA_INIT(COptFont)
	//}}AFX_DATA_INIT
}


void COptFont::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(COptFont)
	DDX_Control(pDX, IDC_FONT_LIST, m_Fonts);
	DDX_Control(pDX, IDC_BROWSE_FONT, m_BrowseFont);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(COptFont, CDialog)
	//{{AFX_MSG_MAP(COptFont)
	ON_BN_CLICKED(IDC_BROWSE_FONT, OnBrowseFont)
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// COptFont message handlers

BOOL COptFont::OnInitDialog() 
{
	u32 i;
	void *ifce;
	
	CDialog::OnInitDialog();
	
	COsmo4 *gpac = GetApp();
	TCHAR wTmp[500];
	char *sOpt;

	/*video drivers enum*/
	while (m_Fonts.GetCount()) m_Fonts.DeleteString(0);
	sOpt = IF_GetKey(gpac->m_config, "FontEngine", "DriverName");
	s32 to_sel = 0;
	s32 select = 0;
	u32 count = PM_GetPluginsCount(gpac->m_plugins);
	for (i=0; i<count; i++) {
		if (!PM_LoadInterface(gpac->m_plugins, i, M4_FONT_RASTER_INTERFACE, &ifce)) continue;
		if (sOpt && !stricmp(((BaseInterface *)ifce)->plugin_name, sOpt)) select = to_sel;
		CE_CharToWide((char *) ((BaseInterface *)ifce)->plugin_name, wTmp);
		m_Fonts.AddString(wTmp);
		PM_ShutdownInterface(ifce);
		to_sel++;
	}
	m_Fonts.SetCurSel(select);
	

	sOpt = IF_GetKey(gpac->m_config, "FontEngine", "FontDirectory");
	CE_CharToWide(sOpt, wTmp);
	if (sOpt) m_BrowseFont.SetWindowText(wTmp);

	return TRUE;  
}

void COptFont::OnBrowseFont() 
{

}


void COptFont::SaveOptions()
{
	COsmo4 *gpac = GetApp();
	char str[MAX_PATH];
	TCHAR wstr[MAX_PATH];
		
	m_Fonts.GetWindowText(wstr, 50);
	CE_WideToChar(wstr, str);
	IF_SetKey(gpac->m_config, "FontEngine", "DriverName", str);
	m_BrowseFont.GetWindowText(wstr, 50);
	CE_WideToChar(wstr, str);
	IF_SetKey(gpac->m_config, "FontEngine", "FontDirectory", str);
}
