// ProgressBar.cpp : implementation file
//

#include "stdafx.h"
#include "Osmo4.h"
#include "ProgressBar.h"

#ifdef _DEBUG
#define new DEBUG_NEW
#undef THIS_FILE
static char THIS_FILE[] = __FILE__;
#endif

/////////////////////////////////////////////////////////////////////////////
// ProgressBar dialog


ProgressBar::ProgressBar(CWnd* pParent /*=NULL*/)
	: CDialog(ProgressBar::IDD, pParent)
{
	//{{AFX_DATA_INIT(ProgressBar)
		// NOTE: the ClassWizard will add member initialization here
	//}}AFX_DATA_INIT

	m_icoplay = AfxGetApp()->LoadIcon(IDI_PLAY);
	m_icostop = AfxGetApp()->LoadIcon(IDI_STOP);
	m_icopause = AfxGetApp()->LoadIcon(IDI_PAUSE);
	m_grabbed = 0;
	m_reset = 0;
}


void ProgressBar::DoDataExchange(CDataExchange* pDX)
{
	CDialog::DoDataExchange(pDX);
	//{{AFX_DATA_MAP(ProgressBar)
	DDX_Control(pDX, IDC_STOP, m_Stop);
	DDX_Control(pDX, IDC_PLAY, m_Play);
	DDX_Control(pDX, IDC_SLIDER, m_Slider);
	//}}AFX_DATA_MAP
}


BEGIN_MESSAGE_MAP(ProgressBar, CDialog)
	//{{AFX_MSG_MAP(ProgressBar)
	ON_WM_SIZE()
	ON_WM_CLOSE()
	ON_BN_CLICKED(IDC_PLAY, OnPlay)
	ON_BN_CLICKED(IDC_STOP, OnStop)
	ON_WM_HSCROLL()
	//}}AFX_MSG_MAP
END_MESSAGE_MAP()

/////////////////////////////////////////////////////////////////////////////
// ProgressBar message handlers

void ProgressBar::OnSize(UINT nType, int cx, int cy) 
{
	CDialog::OnSize(nType, cx, cy);

	if (!m_Slider.m_hWnd) return;

	RECT rc, rc2;;
	m_Slider.GetClientRect(&rc);
	rc.right = rc.left + cx;

	m_Play.GetClientRect(&rc2);
	rc.left = rc2.right - rc2.left;
	m_Stop.GetClientRect(&rc2);
	rc.left += rc2.right - rc2.left;

	m_Slider.MoveWindow(&rc);
	m_Stop.SetIcon(m_icostop);

	WinGPAC *gpac = GetApp();
	if (!gpac->m_isopen) {
		m_Play.EnableWindow(FALSE);
		m_Stop.EnableWindow(FALSE);
		m_Play.SetIcon(m_icoplay);
	} else {
		m_Play.EnableWindow(TRUE);
		m_Stop.EnableWindow(TRUE);
		m_Play.SetIcon(gpac->m_paused ? m_icoplay : m_icopause);
	}
}

void ProgressBar::OnClose() 
{
	WinGPAC *gpac = GetApp();
	GetApp()->GetMainWnd()->PostMessage(WM_CLOSE);
}

void ProgressBar::OnPlay() 
{
	WinGPAC *gpac = GetApp();

	gpac->Pause();
	m_Play.SetIcon(gpac->m_paused ? m_icoplay : m_icopause);

	if (m_reset) {
		m_reset = 0;
		gpac->PlayFromTime(0);
	}
}

void ProgressBar::OnStop() 
{
	WinGPAC *gpac = GetApp();
	if (m_reset) return;
	m_reset = 1;
	gpac->Pause();
	m_Slider.SetPos(0);
	m_Play.SetIcon(gpac->m_paused ? m_icoplay : m_icopause);
}

void ProgressBar::Stop() 
{
	OnStop();
}

void ProgressBar::OnHScroll(UINT nSBCode, UINT nPos, CScrollBar* pScrollBar) 
{
	WinGPAC *gpac = GetApp();
	

	if (pScrollBar->GetDlgCtrlID() == IDC_SLIDER) {
		switch (nSBCode) {
		case TB_LINEUP:
		case TB_LINEDOWN:
		case TB_PAGEUP:
		case TB_PAGEDOWN:
		case TB_THUMBPOSITION:
		case TB_THUMBTRACK:
		case TB_TOP:
		case TB_BOTTOM:
			m_grabbed = 1;
			break;
		case TB_ENDTRACK:
			if (!gpac->can_seek || !gpac->m_isopen) {
				m_Slider.SetPos(0);
			} else {
				u32 seek_to = m_Slider.GetPos();
				gpac->PlayFromTime(seek_to);
				m_Play.SetIcon(m_icopause);
				m_reset = 0;
			}
			m_grabbed = 0;
			break;
		}
	}
	CDialog::OnHScroll(nSBCode, nPos, pScrollBar);
}
