static char rcsid[] = "$Id: genome_hr.c 34923 2011-02-09 06:25:58Z twu $";
#ifdef HAVE_CONFIG_H
#include <config.h>
#endif
#ifndef HAVE_MEMCPY
# define memcpy(d,s,n) bcopy((s),(d),(n))
#endif
#ifndef HAVE_MEMMOVE
# define memmove(d,s,n) bcopy((s),(d),(n))
#endif

#include "genome_hr.h"

#include <stdio.h>
#include <stddef.h>
#include <stdlib.h>
#include <string.h>
#include <ctype.h>		/* For tolower() */

#include "assert.h"
#include "except.h"
#include "mem.h"
#include "cmet.h"
#include "dibase.h"

#ifdef WORDS_BIGENDIAN
#include "bigendian.h"
#else
#include "littleendian.h"
#endif


#ifdef DEBUG
#define debug(x) x
#else
#define debug(x)
#endif

/* Fragments */
#ifdef DEBUG1
#define debug1(x) x
#else
#define debug1(x)
#endif

/* Splice sites */
#ifdef DEBUG2
#define debug2(x) x
#else
#define debug2(x)
#endif



#ifndef HAVE_BUILTIN_POPCOUNT
static const int count_bits[] =
{ 0, 1, 1, 2, 1, 2, 2, 3, 1, 2, 2, 3, 2, 3, 3, 4, 1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
 10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,11,12,12,13,12,13,13,14,12,13,13,14,13,14,14,15,
  1, 2, 2, 3, 2, 3, 3, 4, 2, 3, 3, 4, 3, 4, 4, 5, 2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
 10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,11,12,12,13,12,13,13,14,12,13,13,14,13,14,14,15,
  2, 3, 3, 4, 3, 4, 4, 5, 3, 4, 4, 5, 4, 5, 5, 6, 3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
 10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,11,12,12,13,12,13,13,14,12,13,13,14,13,14,14,15,
  3, 4, 4, 5, 4, 5, 5, 6, 4, 5, 5, 6, 5, 6, 6, 7, 4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
 10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,11,12,12,13,12,13,13,14,12,13,13,14,13,14,14,15,
  4, 5, 5, 6, 5, 6, 6, 7, 5, 6, 6, 7, 6, 7, 7, 8, 5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
 10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,11,12,12,13,12,13,13,14,12,13,13,14,13,14,14,15,
  5, 6, 6, 7, 6, 7, 7, 8, 6, 7, 7, 8, 7, 8, 8, 9, 6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
 10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,11,12,12,13,12,13,13,14,12,13,13,14,13,14,14,15,
  6, 7, 7, 8, 7, 8, 8, 9, 7, 8, 8, 9, 8, 9, 9,10, 7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
 10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,11,12,12,13,12,13,13,14,12,13,13,14,13,14,14,15,
  7, 8, 8, 9, 8, 9, 9,10, 8, 9, 9,10, 9,10,10,11, 8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
 10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,11,12,12,13,12,13,13,14,12,13,13,14,13,14,14,15,
  8, 9, 9,10, 9,10,10,11, 9,10,10,11,10,11,11,12, 9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
 10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,11,12,12,13,12,13,13,14,12,13,13,14,13,14,14,15,
  9,10,10,11,10,11,11,12,10,11,11,12,11,12,12,13,10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,
 10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,11,12,12,13,12,13,13,14,12,13,13,14,13,14,14,15,
 10,11,11,12,11,12,12,13,11,12,12,13,12,13,13,14,11,12,12,13,12,13,13,14,12,13,13,14,13,14,14,15,
 11,12,12,13,12,13,13,14,12,13,13,14,13,14,14,15,12,13,13,14,13,14,14,15,13,14,14,15,14,15,15,16,
 };
#endif

static const UINT4 reduce_nt[] =
{0x00,0x01,0x01,0x01,0x02,0x03,0x03,0x03,0x02,0x03,0x03,0x03,0x02,0x03,0x03,0x03,
 0x04,0x05,0x05,0x05,0x06,0x07,0x07,0x07,0x06,0x07,0x07,0x07,0x06,0x07,0x07,0x07,
 0x04,0x05,0x05,0x05,0x06,0x07,0x07,0x07,0x06,0x07,0x07,0x07,0x06,0x07,0x07,0x07,
 0x04,0x05,0x05,0x05,0x06,0x07,0x07,0x07,0x06,0x07,0x07,0x07,0x06,0x07,0x07,0x07,
 0x08,0x09,0x09,0x09,0x0A,0x0B,0x0B,0x0B,0x0A,0x0B,0x0B,0x0B,0x0A,0x0B,0x0B,0x0B,
 0x0C,0x0D,0x0D,0x0D,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,
 0x0C,0x0D,0x0D,0x0D,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,
 0x0C,0x0D,0x0D,0x0D,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,
 0x08,0x09,0x09,0x09,0x0A,0x0B,0x0B,0x0B,0x0A,0x0B,0x0B,0x0B,0x0A,0x0B,0x0B,0x0B,
 0x0C,0x0D,0x0D,0x0D,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,
 0x0C,0x0D,0x0D,0x0D,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,
 0x0C,0x0D,0x0D,0x0D,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,
 0x08,0x09,0x09,0x09,0x0A,0x0B,0x0B,0x0B,0x0A,0x0B,0x0B,0x0B,0x0A,0x0B,0x0B,0x0B,
 0x0C,0x0D,0x0D,0x0D,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,
 0x0C,0x0D,0x0D,0x0D,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,
 0x0C,0x0D,0x0D,0x0D,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,0x0E,0x0F,0x0F,0x0F,
 0x10,0x11,0x11,0x11,0x12,0x13,0x13,0x13,0x12,0x13,0x13,0x13,0x12,0x13,0x13,0x13,
 0x14,0x15,0x15,0x15,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,
 0x14,0x15,0x15,0x15,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,
 0x14,0x15,0x15,0x15,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,
 0x18,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x18,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x18,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x10,0x11,0x11,0x11,0x12,0x13,0x13,0x13,0x12,0x13,0x13,0x13,0x12,0x13,0x13,0x13,
 0x14,0x15,0x15,0x15,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,
 0x14,0x15,0x15,0x15,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,
 0x14,0x15,0x15,0x15,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,
 0x18,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x18,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x18,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x10,0x11,0x11,0x11,0x12,0x13,0x13,0x13,0x12,0x13,0x13,0x13,0x12,0x13,0x13,0x13,
 0x14,0x15,0x15,0x15,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,
 0x14,0x15,0x15,0x15,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,
 0x14,0x15,0x15,0x15,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,0x16,0x17,0x17,0x17,
 0x18,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x18,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x18,0x19,0x19,0x19,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,0x1A,0x1B,0x1B,0x1B,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x1C,0x1D,0x1D,0x1D,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,0x1E,0x1F,0x1F,0x1F,
 0x20,0x21,0x21,0x21,0x22,0x23,0x23,0x23,0x22,0x23,0x23,0x23,0x22,0x23,0x23,0x23,
 0x24,0x25,0x25,0x25,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,
 0x24,0x25,0x25,0x25,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,
 0x24,0x25,0x25,0x25,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,
 0x28,0x29,0x29,0x29,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x28,0x29,0x29,0x29,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x28,0x29,0x29,0x29,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x30,0x31,0x31,0x31,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x30,0x31,0x31,0x31,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x30,0x31,0x31,0x31,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x20,0x21,0x21,0x21,0x22,0x23,0x23,0x23,0x22,0x23,0x23,0x23,0x22,0x23,0x23,0x23,
 0x24,0x25,0x25,0x25,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,
 0x24,0x25,0x25,0x25,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,
 0x24,0x25,0x25,0x25,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,
 0x28,0x29,0x29,0x29,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x28,0x29,0x29,0x29,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x28,0x29,0x29,0x29,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x30,0x31,0x31,0x31,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x30,0x31,0x31,0x31,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x30,0x31,0x31,0x31,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x20,0x21,0x21,0x21,0x22,0x23,0x23,0x23,0x22,0x23,0x23,0x23,0x22,0x23,0x23,0x23,
 0x24,0x25,0x25,0x25,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,
 0x24,0x25,0x25,0x25,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,
 0x24,0x25,0x25,0x25,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,0x26,0x27,0x27,0x27,
 0x28,0x29,0x29,0x29,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x28,0x29,0x29,0x29,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x28,0x29,0x29,0x29,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,0x2A,0x2B,0x2B,0x2B,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x2C,0x2D,0x2D,0x2D,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,0x2E,0x2F,0x2F,0x2F,
 0x30,0x31,0x31,0x31,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x30,0x31,0x31,0x31,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x30,0x31,0x31,0x31,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,0x32,0x33,0x33,0x33,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x34,0x35,0x35,0x35,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,0x36,0x37,0x37,0x37,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x38,0x39,0x39,0x39,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,0x3A,0x3B,0x3B,0x3B,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x3C,0x3D,0x3D,0x3D,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,0x3E,0x3F,0x3F,0x3F,
 0x40,0x41,0x41,0x41,0x42,0x43,0x43,0x43,0x42,0x43,0x43,0x43,0x42,0x43,0x43,0x43,
 0x44,0x45,0x45,0x45,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,
 0x44,0x45,0x45,0x45,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,
 0x44,0x45,0x45,0x45,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,
 0x48,0x49,0x49,0x49,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x48,0x49,0x49,0x49,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x48,0x49,0x49,0x49,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x50,0x51,0x51,0x51,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x50,0x51,0x51,0x51,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x50,0x51,0x51,0x51,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x60,0x61,0x61,0x61,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x60,0x61,0x61,0x61,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x60,0x61,0x61,0x61,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x40,0x41,0x41,0x41,0x42,0x43,0x43,0x43,0x42,0x43,0x43,0x43,0x42,0x43,0x43,0x43,
 0x44,0x45,0x45,0x45,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,
 0x44,0x45,0x45,0x45,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,
 0x44,0x45,0x45,0x45,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,
 0x48,0x49,0x49,0x49,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x48,0x49,0x49,0x49,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x48,0x49,0x49,0x49,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x50,0x51,0x51,0x51,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x50,0x51,0x51,0x51,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x50,0x51,0x51,0x51,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x60,0x61,0x61,0x61,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x60,0x61,0x61,0x61,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x60,0x61,0x61,0x61,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x40,0x41,0x41,0x41,0x42,0x43,0x43,0x43,0x42,0x43,0x43,0x43,0x42,0x43,0x43,0x43,
 0x44,0x45,0x45,0x45,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,
 0x44,0x45,0x45,0x45,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,
 0x44,0x45,0x45,0x45,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,0x46,0x47,0x47,0x47,
 0x48,0x49,0x49,0x49,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x48,0x49,0x49,0x49,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x48,0x49,0x49,0x49,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,0x4A,0x4B,0x4B,0x4B,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x4C,0x4D,0x4D,0x4D,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,0x4E,0x4F,0x4F,0x4F,
 0x50,0x51,0x51,0x51,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x50,0x51,0x51,0x51,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x50,0x51,0x51,0x51,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,0x52,0x53,0x53,0x53,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x54,0x55,0x55,0x55,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,0x56,0x57,0x57,0x57,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x58,0x59,0x59,0x59,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,0x5A,0x5B,0x5B,0x5B,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x5C,0x5D,0x5D,0x5D,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,0x5E,0x5F,0x5F,0x5F,
 0x60,0x61,0x61,0x61,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x60,0x61,0x61,0x61,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x60,0x61,0x61,0x61,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,0x62,0x63,0x63,0x63,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x64,0x65,0x65,0x65,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,0x66,0x67,0x67,0x67,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x68,0x69,0x69,0x69,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,0x6A,0x6B,0x6B,0x6B,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x6C,0x6D,0x6D,0x6D,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,0x6E,0x6F,0x6F,0x6F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x70,0x71,0x71,0x71,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,0x72,0x73,0x73,0x73,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x74,0x75,0x75,0x75,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,0x76,0x77,0x77,0x77,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x78,0x79,0x79,0x79,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,0x7A,0x7B,0x7B,0x7B,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x7C,0x7D,0x7D,0x7D,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,0x7E,0x7F,0x7F,0x7F,
 0x80,0x81,0x81,0x81,0x82,0x83,0x83,0x83,0x82,0x83,0x83,0x83,0x82,0x83,0x83,0x83,
 0x84,0x85,0x85,0x85,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,
 0x84,0x85,0x85,0x85,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,
 0x84,0x85,0x85,0x85,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,
 0x88,0x89,0x89,0x89,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x88,0x89,0x89,0x89,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x88,0x89,0x89,0x89,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x90,0x91,0x91,0x91,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x90,0x91,0x91,0x91,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x90,0x91,0x91,0x91,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0xA0,0xA1,0xA1,0xA1,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xA0,0xA1,0xA1,0xA1,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xA0,0xA1,0xA1,0xA1,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xC0,0xC1,0xC1,0xC1,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xC0,0xC1,0xC1,0xC1,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xC0,0xC1,0xC1,0xC1,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0x80,0x81,0x81,0x81,0x82,0x83,0x83,0x83,0x82,0x83,0x83,0x83,0x82,0x83,0x83,0x83,
 0x84,0x85,0x85,0x85,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,
 0x84,0x85,0x85,0x85,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,
 0x84,0x85,0x85,0x85,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,
 0x88,0x89,0x89,0x89,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x88,0x89,0x89,0x89,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x88,0x89,0x89,0x89,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x90,0x91,0x91,0x91,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x90,0x91,0x91,0x91,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x90,0x91,0x91,0x91,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0xA0,0xA1,0xA1,0xA1,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xA0,0xA1,0xA1,0xA1,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xA0,0xA1,0xA1,0xA1,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xC0,0xC1,0xC1,0xC1,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xC0,0xC1,0xC1,0xC1,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xC0,0xC1,0xC1,0xC1,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0x80,0x81,0x81,0x81,0x82,0x83,0x83,0x83,0x82,0x83,0x83,0x83,0x82,0x83,0x83,0x83,
 0x84,0x85,0x85,0x85,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,
 0x84,0x85,0x85,0x85,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,
 0x84,0x85,0x85,0x85,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,0x86,0x87,0x87,0x87,
 0x88,0x89,0x89,0x89,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x88,0x89,0x89,0x89,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x88,0x89,0x89,0x89,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,0x8A,0x8B,0x8B,0x8B,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x8C,0x8D,0x8D,0x8D,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,0x8E,0x8F,0x8F,0x8F,
 0x90,0x91,0x91,0x91,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x90,0x91,0x91,0x91,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x90,0x91,0x91,0x91,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,0x92,0x93,0x93,0x93,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x94,0x95,0x95,0x95,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,0x96,0x97,0x97,0x97,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x98,0x99,0x99,0x99,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,0x9A,0x9B,0x9B,0x9B,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0x9C,0x9D,0x9D,0x9D,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,0x9E,0x9F,0x9F,0x9F,
 0xA0,0xA1,0xA1,0xA1,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xA0,0xA1,0xA1,0xA1,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xA0,0xA1,0xA1,0xA1,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,0xA2,0xA3,0xA3,0xA3,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA4,0xA5,0xA5,0xA5,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,0xA6,0xA7,0xA7,0xA7,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xA8,0xA9,0xA9,0xA9,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,0xAA,0xAB,0xAB,0xAB,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xAC,0xAD,0xAD,0xAD,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,0xAE,0xAF,0xAF,0xAF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB0,0xB1,0xB1,0xB1,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,0xB2,0xB3,0xB3,0xB3,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB4,0xB5,0xB5,0xB5,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,0xB6,0xB7,0xB7,0xB7,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xB8,0xB9,0xB9,0xB9,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,0xBA,0xBB,0xBB,0xBB,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xBC,0xBD,0xBD,0xBD,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,0xBE,0xBF,0xBF,0xBF,
 0xC0,0xC1,0xC1,0xC1,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xC0,0xC1,0xC1,0xC1,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xC0,0xC1,0xC1,0xC1,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,0xC2,0xC3,0xC3,0xC3,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC4,0xC5,0xC5,0xC5,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,0xC6,0xC7,0xC7,0xC7,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xC8,0xC9,0xC9,0xC9,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,0xCA,0xCB,0xCB,0xCB,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xCC,0xCD,0xCD,0xCD,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,0xCE,0xCF,0xCF,0xCF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD0,0xD1,0xD1,0xD1,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,0xD2,0xD3,0xD3,0xD3,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD4,0xD5,0xD5,0xD5,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,0xD6,0xD7,0xD7,0xD7,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xD8,0xD9,0xD9,0xD9,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,0xDA,0xDB,0xDB,0xDB,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xDC,0xDD,0xDD,0xDD,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,0xDE,0xDF,0xDF,0xDF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xE0,0xE1,0xE1,0xE1,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,0xE2,0xE3,0xE3,0xE3,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE4,0xE5,0xE5,0xE5,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,0xE6,0xE7,0xE7,0xE7,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xE8,0xE9,0xE9,0xE9,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,0xEA,0xEB,0xEB,0xEB,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xEC,0xED,0xED,0xED,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,0xEE,0xEF,0xEF,0xEF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF0,0xF1,0xF1,0xF1,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,0xF2,0xF3,0xF3,0xF3,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF4,0xF5,0xF5,0xF5,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,0xF6,0xF7,0xF7,0xF7,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xF8,0xF9,0xF9,0xF9,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,0xFA,0xFB,0xFB,0xFB,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 0xFC,0xFD,0xFD,0xFD,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,0xFE,0xFF,0xFF,0xFF,
 };

#ifndef HAVE_BUILTIN_CLZ
static const int clz_table[] =
{16,15,14,14,13,13,13,13,12,12,12,12,12,12,12,12,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,11,
 10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,10,
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
  9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9, 9,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8, 8,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7, 7,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6, 6,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5, 5,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4, 4,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3, 3,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2, 2,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1, 1,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0,
  0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0, 0
};
#endif

/* bestscore, besti, totalscore from low bit */
static const int score_low[] =
{16,15, 16,14,15, 14,14,15, 14,12,15, 12,14,15, 14,12,15, 12,12,15, 12,10,15, 10,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10, 9, 10, 8, 9,  8, 8, 9,  8, 6, 9,  6, 8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 14,15, 14,12,15, 12,12,15, 12,10,15, 10,12,15, 12,10,15, 10,10,15, 10, 8,15,  8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 12,15, 12,10,15, 10,10,15, 10, 8,15,  8,10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,15, 10, 8,15,  8, 8,15,  8, 6,15,  6, 8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,15,  8, 6,15,  6, 6,15,  6, 4,15,  4, 6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,15,  6, 4,15,  4, 4,15,  4, 2,15,  2, 4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0,
  4,15,  4, 2,15,  2, 2,15,  2, 0,15,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10, 9, 10, 8, 9,  8, 8, 9,  8, 6, 9,  6, 8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 12,11, 12,10,11, 10,10,11, 10, 8,11,  8,10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10, 9, 10, 8, 9,  8, 8, 9,  8, 6, 9,  6, 8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 11,10, 10, 9,10,  8, 9,10,  8, 7,10,  6, 9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 10, 9,  8, 8, 9,  6, 8, 9,  6, 6, 9,  4, 8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 14,13, 14,12,13, 12,12,13, 12,10,13, 10,12,13, 12,10,13, 10,10,13, 10, 8,13,  8,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 12,13, 12,10,13, 10,10,13, 10, 8,13,  8,10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,13, 10, 8,13,  8, 8,13,  8, 6,13,  6, 8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,13,  8, 6,13,  6, 6,13,  6, 4,13,  4, 6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,13,  6, 4,13,  4, 4,13,  4, 2,13,  2, 4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0,
  4,13,  4, 2,13,  2, 2,13,  2, 0,13,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10, 9, 10, 8, 9,  8, 8, 9,  8, 6, 9,  6, 8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 12,11, 12,10,11, 10,10,11, 10, 8,11,  8,10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 10,11, 10, 8,11,  8, 8,11,  8, 6,11,  6, 8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8,11,  8, 6,11,  6, 6,11,  6, 4,11,  4, 6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6,11,  6, 4,11,  4, 4,11,  4, 2,11,  2, 4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0,
  4,11,  4, 2,11,  2, 2,11,  2, 0,11,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
 10, 9, 10, 8, 9,  8, 8, 9,  8, 6, 9,  6, 8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  8, 6, 9,  6, 6, 9,  6, 4, 9,  4, 6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 9,  6, 4, 9,  4, 4, 9,  4, 2, 9,  2, 4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0,
  4, 9,  4, 2, 9,  2, 2, 9,  2, 0, 9,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 7,  8, 6, 7,  6, 6, 7,  6, 4, 7,  4, 6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  6, 7,  6, 4, 7,  4, 4, 7,  4, 2, 7,  2, 4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0,
  4, 7,  4, 2, 7,  2, 2, 7,  2, 0, 7,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 5,  6, 4, 5,  4, 4, 5,  4, 2, 5,  2, 4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0,
  4, 5,  4, 2, 5,  2, 2, 5,  2, 0, 5,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  4, 3,  4, 2, 3,  2, 2, 3,  2, 0, 3,  0, 2, 1,  2, 0, 1,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 11,10, 10, 9,10,  8, 9,10,  8, 7,10,  6, 9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,10,  8, 7,10,  6, 7,10,  6, 5,10,  4, 7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,10,  6, 5,10,  4, 5,10,  4, 3,10,  2, 5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  5,10,  4, 3,10,  2, 3,10,  2, 1,10,  0, 3,10,  2, 1,10,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  9, 8,  8, 7, 8,  6, 7, 8,  6, 5, 8,  4, 7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  6, 5, 8,  4, 5, 8,  4, 3, 8,  2, 5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  5, 8,  4, 3, 8,  2, 3, 8,  2, 1, 8,  0, 3, 8,  2, 1, 8,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
 10, 9,  8, 8, 9,  6, 8, 9,  6, 6, 9,  4, 8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  8, 9,  6, 6, 9,  4, 6, 9,  4, 4, 9,  2, 6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 9,  4, 4, 9,  2, 4, 9,  2, 2, 9,  0, 4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2,
  4, 9,  2, 2, 9,  0, 2, 9,  0, 0, 9, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  8, 7,  6, 6, 7,  4, 6, 7,  4, 4, 7,  2, 6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  6, 7,  4, 4, 7,  2, 4, 7,  2, 2, 7,  0, 4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2,
  4, 7,  2, 2, 7,  0, 2, 7,  0, 0, 7, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 5,  4, 4, 5,  2, 4, 5,  2, 2, 5,  0, 4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2,
  4, 5,  2, 2, 5,  0, 2, 5,  0, 0, 5, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  9, 8,  6, 7, 8,  4, 7, 8,  4, 5, 8,  2, 7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 8,  4, 5, 8,  2, 5, 8,  2, 3, 8,  0, 5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  5, 8,  2, 3, 8,  0, 3, 8,  0, 1, 8, -2, 3, 8,  0, 1, 8, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  7, 6,  4, 5, 6,  2, 5, 6,  2, 3, 6,  0, 5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  5, 6,  2, 3, 6,  0, 3, 6,  0, 1, 6, -2, 3, 6,  0, 1, 6, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  5, 4,  2, 3, 4,  0, 3, 4,  0, 1, 4, -2, 3, 4,  0, 1, 4, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  8, 7,  4, 6, 7,  2, 6, 7,  2, 4, 7,  0, 6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  6, 7,  2, 4, 7,  0, 4, 7,  0, 2, 7, -2, 4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4,
  4, 7,  0, 2, 7, -2, 2, 7, -2, 0, 7, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  6, 5,  2, 4, 5,  0, 4, 5,  0, 2, 5, -2, 4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4,
  4, 5,  0, 2, 5, -2, 2, 5, -2, 0, 5, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  4, 3,  0, 2, 3, -2, 2, 3, -2, 0, 3, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  7, 6,  2, 5, 6,  0, 5, 6,  0, 3, 6, -2, 5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  5, 6,  0, 3, 6, -2, 3, 6, -2, 1, 6, -4, 3, 6, -2, 1, 6, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  5, 4,  0, 3, 4, -2, 3, 4, -2, 1, 4, -4, 3, 4, -2, 1, 4, -4, 1, 0, -4,-1, 0, -6,
  3, 2, -2, 1, 2, -4, 1, 0, -4,-1, 0, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  6, 5,  0, 4, 5, -2, 4, 5, -2, 2, 5, -4, 4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6,
  4, 5, -2, 2, 5, -4, 2, 5, -4, 0, 5, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  4, 3, -2, 2, 3, -4, 2, 3, -4, 0, 3, -6, 2, 1, -4, 0, 1, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  5, 4, -2, 3, 4, -4, 3, 4, -4, 1, 4, -6, 3, 4, -4, 1, 4, -6, 1, 0, -6,-1, 0, -8,
  3, 2, -4, 1, 2, -6, 1, 0, -6,-1, 0, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  4, 3, -4, 2, 3, -6, 2, 3, -6, 0, 3, -8, 2, 1, -6, 0, 1, -8, 1, 0, -8,-1, 0,-10,
  3, 2, -6, 1, 2, -8, 1, 0, -8,-1, 0,-10, 2, 1, -8, 0, 1,-10, 1, 0,-10,-1, 0,-12,
 13,12, 12,11,12, 10,11,12, 10, 9,12,  8,11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
 11,12, 10, 9,12,  8, 9,12,  8, 7,12,  6, 9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  9,12,  8, 7,12,  6, 7,12,  6, 5,12,  4, 7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  7,12,  6, 5,12,  4, 5,12,  4, 3,12,  2, 5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  5,12,  4, 3,12,  2, 3,12,  2, 1,12,  0, 3,12,  2, 1,12,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  3, 2,  0, 1, 2, -2, 1, 0, -2,-1, 0, -4, 2, 1, -2, 0, 1, -4, 1, 0, -4,-1, 0, -6,
  7, 6,  6, 5, 6,  4, 5, 6,  4, 3, 6,  2, 5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  5, 6,  4, 3, 6,  2, 3, 6,  2, 1, 6,  0, 3, 6,  2, 1, 6,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  5, 4,  4, 3, 4,  2, 3, 4,  2, 1, 4,  0, 3, 4,  2, 1, 4,  0, 1, 0,  0,-1, 0, -2,
  3, 2,  2, 1, 2,  0, 1, 0,  0,-1, 0, -2, 2, 1,  0, 0, 1, -2, 1, 0, -2,-1, 0, -4,
  4, 3,  2, 2, 3,  0, 2, 3,  0, 0, 3, -2, 2, 1,  0, 0, 1, -2