#!/bin/sh

BASEDIR=$1
DOMAIN_ROOT=$2
ADMIN_PORT=$3
ADMIN_USER=$4
PASSWORD_FILE=$5
INSTANCE_PORT=$6
DOMAIN=$7

# Only create domain if domain doesn't exist
if [ ! -d $DOMAIN_ROOT/$DOMAIN ]; then
   $BASEDIR/bin/asadmin create-domain --domaindir $DOMAIN_ROOT --adminport $ADMIN_PORT --user $ADMIN_USER --passwordfile $PASSWORD_FILE --instanceport $INSTANCE_PORT $DOMAIN   
   result=$?
   if [ $result -ne 0 ]; then
      echo "Could not create default domain $DOMAIN at $DOMAIN_ROOT.\n"
      echo "Create required domains manually using asadmin2 \n"
      exit 1
   fi
fi

exit 0

