/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.jxtamgmt;

import com.sun.enterprise.jxtamgmt.LWRMulticast;
import com.sun.enterprise.jxtamgmt.LWRMulticastTest;
import java.awt.EventQueue;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.text.MessageFormat;
import javax.swing.BorderFactory;
import javax.swing.GroupLayout;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSpinner;
import javax.swing.JTextArea;
import javax.swing.JTextField;
import javax.swing.LayoutStyle;
import javax.swing.SpinnerNumberModel;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.MessageElement;
import net.jxta.pipe.PipeMsgEvent;
import net.jxta.pipe.PipeMsgListener;

public class LWRMulticastTestUI
extends JFrame
implements PipeMsgListener {
    private LWRMulticastTest mcastTest = null;
    final SpinnerNumberModel numMsgsSpinnerModel;
    final SpinnerNumberModel numRepeatSpinnerModel;
    final SpinnerNumberModel numSendersSpinnerModel;
    private JTextField groupNameTextField;
    private JTextField instanceNameTextField;
    private JLabel jLabel1;
    private JLabel jLabel2;
    private JLabel jLabel3;
    private JLabel jLabel4;
    private JLabel jLabel5;
    private JLabel jLabel6;
    private JPanel jPanel1;
    private JPanel jPanel2;
    private JScrollPane jScrollPane1;
    private JTextField messageTextField;
    private JLabel nodeIDLabel;
    private JSpinner numMsgsSpinner;
    private JSpinner numRepeatSpinner;
    private JSpinner numSendersSpinner;
    private JButton sendButton;
    private JButton startButton;
    private JTextArea statusTextArea;

    public LWRMulticastTestUI() {
        this.initComponents();
        this.numRepeatSpinnerModel = new SpinnerNumberModel(1, 1, 10000, 1);
        this.numRepeatSpinner.setModel(this.numRepeatSpinnerModel);
        this.numMsgsSpinnerModel = new SpinnerNumberModel(1, 1, 100, 1);
        this.numMsgsSpinner.setModel(this.numMsgsSpinnerModel);
        this.numSendersSpinnerModel = new SpinnerNumberModel(1, 1, 100, 1);
        this.numSendersSpinner.setModel(this.numSendersSpinnerModel);
        this.start();
        this.updateComponents();
    }

    private void updateComponents() {
        this.groupNameTextField.setText(LWRMulticastTest.getGroupName());
        this.instanceNameTextField.setText(LWRMulticastTest.getInstanceName());
        String nodeID = LWRMulticastTest.getNodeID();
        if (nodeID != null) {
            this.nodeIDLabel.setText(nodeID);
            this.nodeIDLabel.setToolTipText(nodeID);
            this.startButton.setEnabled(false);
        } else {
            this.nodeIDLabel.setText("<none>");
            this.startButton.setEnabled(true);
        }
    }

    private void start() {
        if (LWRMulticastTest.startManager()) {
            this.mcastTest = new LWRMulticastTest(this);
        }
    }

    private void sendMessage() {
        if (this.mcastTest == null) {
            return;
        }
        int nr = this.numRepeatSpinnerModel.getNumber().intValue();
        int ns = this.numSendersSpinnerModel.getNumber().intValue();
        int nm = this.numMsgsSpinnerModel.getNumber().intValue();
        String msg = "";
        for (int i = 0; i < nr; ++i) {
            msg = msg + this.messageTextField.getText();
        }
        int nacks = 0;
        long startTime = System.nanoTime();
        for (int i = 0; i < nm; ++i) {
            nacks += this.mcastTest.sendMessage(msg, ns);
        }
        this.statusTextArea.append(MessageFormat.format("Received  {0} ack(s) in {1} milliseconds \n", nacks, (System.nanoTime() - startTime) / 1000000L));
        int pos = this.statusTextArea.getText().length();
        this.statusTextArea.setCaretPosition(pos);
    }

    public void pipeMsgEvent(PipeMsgEvent event) {
        Message message = event.getMessage();
        if (message == null) {
            return;
        }
        this.statusTextArea.append(MessageFormat.format("Received message sequence : {0}\n", LWRMulticast.getSequenceID(message)));
        Message.ElementIterator iter = this.mcastTest.getMessageElements(message);
        while (iter.hasNext()) {
            MessageElement el = iter.next();
            this.statusTextArea.append("   >> " + el.getElementName() + "::" + el.toString() + "\n");
        }
        int pos = this.statusTextArea.getText().length();
        this.statusTextArea.setCaretPosition(pos);
    }

    private void initComponents() {
        this.jPanel1 = new JPanel();
        this.jLabel1 = new JLabel();
        this.jLabel2 = new JLabel();
        this.jLabel3 = new JLabel();
        this.nodeIDLabel = new JLabel();
        this.groupNameTextField = new JTextField();
        this.instanceNameTextField = new JTextField();
        this.startButton = new JButton();
        this.jPanel2 = new JPanel();
        this.messageTextField = new JTextField();
        this.sendButton = new JButton();
        this.numMsgsSpinner = new JSpinner();
        this.jLabel4 = new JLabel();
        this.jLabel5 = new JLabel();
        this.numSendersSpinner = new JSpinner();
        this.numRepeatSpinner = new JSpinner();
        this.jLabel6 = new JLabel();
        this.jScrollPane1 = new JScrollPane();
        this.statusTextArea = new JTextArea();
        this.setDefaultCloseOperation(0);
        this.addWindowListener(new WindowAdapter(){

            public void windowClosing(WindowEvent evt) {
                LWRMulticastTestUI.this.formWindowClosing(evt);
            }
        });
        this.jPanel1.setBorder(BorderFactory.createTitledBorder("Network Manager"));
        this.jLabel1.setText("Group Name");
        this.jLabel2.setText("Instance Name");
        this.jLabel3.setText("Node ID");
        this.nodeIDLabel.setText(" ");
        this.groupNameTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LWRMulticastTestUI.this.groupNameTextFieldActionPerformed(evt);
            }
        });
        this.instanceNameTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LWRMulticastTestUI.this.instanceNameTextFieldActionPerformed(evt);
            }
        });
        this.startButton.setText("Start");
        this.startButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LWRMulticastTestUI.this.startButtonActionPerformed(evt);
            }
        });
        GroupLayout jPanel1Layout = new GroupLayout(this.jPanel1);
        this.jPanel1.setLayout(jPanel1Layout);
        jPanel1Layout.setHorizontalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.jLabel2, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel3, -1, -1, Short.MAX_VALUE).addComponent(this.jLabel1, -1, -1, Short.MAX_VALUE)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING, false).addComponent(this.instanceNameTextField).addComponent(this.groupNameTextField).addComponent(this.nodeIDLabel, -2, 245, -2)).addContainerGap(-1, Short.MAX_VALUE)).addGroup(GroupLayout.Alignment.TRAILING, jPanel1Layout.createSequentialGroup().addContainerGap(297, Short.MAX_VALUE).addComponent(this.startButton).addContainerGap()));
        jPanel1Layout.setVerticalGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel1Layout.createSequentialGroup().addContainerGap().addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel1).addComponent(this.groupNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.jLabel2).addComponent(this.instanceNameTextField, -2, -1, -2)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel1Layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jLabel3).addComponent(this.nodeIDLabel)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.startButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.jPanel2.setBorder(BorderFactory.createTitledBorder("Messages"));
        this.messageTextField.setText("abcdefghijklmnopqrstuvwxyz0123456789");
        this.messageTextField.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LWRMulticastTestUI.this.messageTextFieldActionPerformed(evt);
            }
        });
        this.sendButton.setText("Send");
        this.sendButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                LWRMulticastTestUI.this.sendButtonActionPerformed(evt);
            }
        });
        this.jLabel4.setText("#Msgs");
        this.jLabel5.setText("# Senders");
        this.jLabel6.setText("Repeat");
        GroupLayout jPanel2Layout = new GroupLayout(this.jPanel2);
        this.jPanel2.setLayout(jPanel2Layout);
        jPanel2Layout.setHorizontalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addContainerGap().addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(GroupLayout.Alignment.TRAILING, jPanel2Layout.createSequentialGroup().addComponent(this.jLabel6).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED, -1, Short.MAX_VALUE).addComponent(this.numRepeatSpinner, -2, 52, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel4).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numMsgsSpinner, -2, 55, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jLabel5).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.numSendersSpinner, -2, 46, -2)).addComponent(this.messageTextField, -1, 357, Short.MAX_VALUE).addComponent(this.sendButton, GroupLayout.Alignment.TRAILING)).addContainerGap()));
        jPanel2Layout.setVerticalGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(jPanel2Layout.createSequentialGroup().addComponent(this.messageTextField, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addGroup(jPanel2Layout.createParallelGroup(GroupLayout.Alignment.BASELINE).addComponent(this.numSendersSpinner, -2, -1, -2).addComponent(this.jLabel5).addComponent(this.numMsgsSpinner, -2, -1, -2).addComponent(this.jLabel4).addComponent(this.numRepeatSpinner, -2, -1, -2).addComponent(this.jLabel6)).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.sendButton).addContainerGap(-1, Short.MAX_VALUE)));
        this.statusTextArea.setColumns(20);
        this.statusTextArea.setEditable(false);
        this.statusTextArea.setRows(5);
        this.jScrollPane1.setViewportView(this.statusTextArea);
        GroupLayout layout = new GroupLayout(this.getContentPane());
        this.getContentPane().setLayout(layout);
        layout.setHorizontalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addComponent(this.jScrollPane1, -1, 382, Short.MAX_VALUE).addContainerGap()).addGroup(GroupLayout.Alignment.TRAILING, layout.createSequentialGroup().addGroup(layout.createParallelGroup(GroupLayout.Alignment.TRAILING).addComponent(this.jPanel2, GroupLayout.Alignment.LEADING, -1, 382, Short.MAX_VALUE).addComponent(this.jPanel1, -1, -1, Short.MAX_VALUE)).addContainerGap()))));
        layout.setVerticalGroup(layout.createParallelGroup(GroupLayout.Alignment.LEADING).addGroup(layout.createSequentialGroup().addContainerGap().addComponent(this.jPanel1, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jPanel2, -2, -1, -2).addPreferredGap(LayoutStyle.ComponentPlacement.RELATED).addComponent(this.jScrollPane1, -1, 138, Short.MAX_VALUE).addContainerGap()));
        this.pack();
    }

    private void messageTextFieldActionPerformed(ActionEvent evt) {
        this.sendMessage();
    }

    private void instanceNameTextFieldActionPerformed(ActionEvent evt) {
        LWRMulticastTest.setInstanceName(this.instanceNameTextField.getText());
        this.updateComponents();
    }

    private void groupNameTextFieldActionPerformed(ActionEvent evt) {
        LWRMulticastTest.setGroupName(this.groupNameTextField.getText());
        this.updateComponents();
    }

    private void formWindowClosing(WindowEvent evt) {
        if (this.mcastTest != null) {
            this.mcastTest.close();
        }
        LWRMulticastTest.stopManager();
        System.exit(0);
    }

    private void sendButtonActionPerformed(ActionEvent evt) {
        this.sendMessage();
    }

    private void startButtonActionPerformed(ActionEvent evt) {
        this.start();
        this.updateComponents();
    }

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            public void run() {
                new LWRMulticastTestUI().setVisible(true);
            }
        });
    }
}

