/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.ee.cms.impl.common;

import com.sun.enterprise.ee.cms.core.FailureNotificationSignal;
import com.sun.enterprise.ee.cms.core.FailureRecoverySignal;
import com.sun.enterprise.ee.cms.core.FailureSuspectedSignal;
import com.sun.enterprise.ee.cms.core.JoinNotificationSignal;
import com.sun.enterprise.ee.cms.core.MessageSignal;
import com.sun.enterprise.ee.cms.core.PlannedShutdownSignal;
import com.sun.enterprise.ee.cms.core.Signal;
import com.sun.enterprise.ee.cms.impl.common.Router;
import com.sun.enterprise.ee.cms.impl.common.SignalPacket;
import com.sun.enterprise.ee.cms.logging.GMSLogDomain;
import java.util.concurrent.BlockingQueue;
import java.util.logging.Level;
import java.util.logging.Logger;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SignalHandler
implements Runnable {
    private final BlockingQueue<SignalPacket> signalQueue;
    private final Router router;
    private Logger logger = GMSLogDomain.getLogger("ShoalLogger");
    private volatile boolean interrupted = false;

    public SignalHandler(BlockingQueue<SignalPacket> packetQueue, Router router) {
        this.signalQueue = packetQueue;
        this.router = router;
    }

    @Override
    public void run() {
        while (!this.interrupted) {
            try {
                SignalPacket signalPacket = this.signalQueue.take();
                if (signalPacket == null) continue;
                Signal[] signals = signalPacket.getSignals();
                if (signals != null) {
                    this.handleSignals(signals);
                    continue;
                }
                this.handleSignal(signalPacket.getSignal());
            }
            catch (InterruptedException e) {
                this.logger.log(Level.FINEST, e.getLocalizedMessage());
                this.interrupted = true;
            }
        }
    }

    private void handleSignal(Signal signal) {
        this.analyzeSignal(signal);
    }

    private void handleSignals(Signal[] signals) {
        for (Signal signal : signals) {
            this.analyzeSignal(signal);
        }
    }

    private void analyzeSignal(Signal signal) {
        if (signal instanceof FailureRecoverySignal) {
            this.router.notifyFailureRecoveryAction((FailureRecoverySignal)signal);
        } else if (signal instanceof FailureNotificationSignal) {
            this.router.notifyFailureNotificationAction((FailureNotificationSignal)signal);
        } else if (signal instanceof MessageSignal) {
            this.router.notifyMessageAction((MessageSignal)signal);
        } else if (signal instanceof JoinNotificationSignal) {
            this.router.notifyJoinNotificationAction((JoinNotificationSignal)signal);
        } else if (signal instanceof PlannedShutdownSignal) {
            this.router.notifyPlannedShutdownAction((PlannedShutdownSignal)signal);
        } else if (signal instanceof FailureSuspectedSignal) {
            this.router.notifyFailureSuspectedAction((FailureSuspectedSignal)signal);
        }
    }
}

