/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.util.fileStreamer;

import com.sun.jsftemplating.util.fileStreamer.BaseContext;
import com.sun.jsftemplating.util.fileStreamer.ContentSource;
import com.sun.jsftemplating.util.fileStreamer.FileStreamer;
import java.io.IOException;
import java.io.OutputStream;
import javax.faces.context.FacesContext;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletResponse;

public class FacesStreamerContext
extends BaseContext {
    public static final String FACES_CONTEXT = "facesContext";
    public static final String CONTENT_SOURCE_ID = "contentSourceId";
    public static final String DEFAULT_CONTENT_SOURCE_ID = "resourceCS";

    public FacesStreamerContext(FacesContext ctx) {
        this.setFacesContext(ctx);
    }

    public ContentSource getContentSource() {
        ContentSource src = (ContentSource)this.getAttribute("_contentSource");
        if (src != null) {
            return src;
        }
        String id = (String)this.getFacesContext().getExternalContext().getRequestParameterMap().get(CONTENT_SOURCE_ID);
        if (id == null) {
            id = DEFAULT_CONTENT_SOURCE_ID;
        }
        if ((src = FileStreamer.getFileStreamer().getContentSource(id)) == null) {
            throw new RuntimeException("The ContentSource with id '" + id + "' is not registered!");
        }
        this.setAttribute("_contentSource", src);
        return src;
    }

    public void writeHeader(ContentSource source) {
        String contentType;
        ServletResponse resp = (ServletResponse)this.getFacesContext().getExternalContext().getResponse();
        long longTime = source.getLastModified(this);
        if (longTime != -1L) {
            ((HttpServletResponse)resp).setDateHeader("Last-Modified", longTime);
        }
        if ((contentType = (String)this.getAttribute("ContentType")) == null) {
            String ext = (String)this.getAttribute("extension");
            if (ext != null) {
                contentType = FileStreamer.getMimeType(ext);
            }
            if (contentType == null) {
                contentType = FileStreamer.getDefaultMimeType();
            }
        }
        ((HttpServletResponse)resp).setHeader("Content-type", contentType);
    }

    public OutputStream getOutputStream() throws IOException {
        ServletResponse resp = (ServletResponse)this.getFacesContext().getExternalContext().getResponse();
        return resp.getOutputStream();
    }

    public FacesContext getFacesContext() {
        return (FacesContext)this.getAttribute(FACES_CONTEXT);
    }

    protected void setFacesContext(FacesContext ctx) {
        this.setAttribute(FACES_CONTEXT, ctx);
    }
}

