/*
 * Decompiled with CFR 0.152.
 */
package com.sun.jsftemplating.layout;

import com.sun.jsftemplating.el.PageSessionResolver;
import com.sun.jsftemplating.layout.LayoutDefinitionException;
import com.sun.jsftemplating.layout.LayoutViewRoot;
import com.sun.jsftemplating.layout.descriptors.LayoutComponent;
import com.sun.jsftemplating.layout.descriptors.LayoutDefinition;
import com.sun.jsftemplating.layout.descriptors.LayoutElement;
import com.sun.jsftemplating.layout.descriptors.LayoutFacet;
import com.sun.jsftemplating.layout.descriptors.Resource;
import com.sun.jsftemplating.util.LogUtil;
import com.sun.jsftemplating.util.fileStreamer.FacesStreamerContext;
import com.sun.jsftemplating.util.fileStreamer.FileStreamer;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.Serializable;
import java.io.Writer;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Map;
import javax.faces.FactoryFinder;
import javax.faces.application.StateManager;
import javax.faces.application.ViewHandler;
import javax.faces.component.UIComponent;
import javax.faces.component.UIViewRoot;
import javax.faces.context.ExternalContext;
import javax.faces.context.FacesContext;
import javax.faces.context.ResponseWriter;
import javax.faces.render.RenderKit;
import javax.faces.render.RenderKitFactory;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class LayoutViewHandler
extends ViewHandler {
    public static final String ENCODING_TYPE = "com.sun.jsftemplating.ENCODING";
    public static final String AJAX_REQ_KEY = "ajaxReq";
    public static final String RESTORE_VIEW_ID = "_resViewID";
    public static final String DEFAULT_RESOURCE_PREFIX = "/resource";
    public static final String RESOURCE_PREFIX = "com.sun.jsftemplating.RESOURCE_PREFIX";
    private List<String> _resourcePrefix = null;
    private ViewHandler _oldViewHandler = null;
    static final String AJAX_REQ_TARGET_KEY = "_ajaxReqTarget";

    public LayoutViewHandler(ViewHandler oldViewHandler) {
        this._oldViewHandler = oldViewHandler;
    }

    public UIViewRoot createView(FacesContext context, String viewId) {
        String path = this.getResourcePath(viewId);
        if (path != null) {
            return this.serveResource(context, path);
        }
        Locale locale = null;
        String renderKitId = null;
        if (context.getViewRoot() != null) {
            locale = context.getViewRoot().getLocale();
            renderKitId = context.getViewRoot().getRenderKitId();
        }
        LayoutViewRoot viewRoot = new LayoutViewRoot();
        viewRoot.setViewId(viewId);
        viewRoot.setLayoutDefinitionKey(viewId);
        if (locale == null) {
            locale = this.calculateLocale(context);
        }
        viewRoot.setLocale(locale);
        if (renderKitId == null) {
            renderKitId = this.calculateRenderKitId(context);
        }
        viewRoot.setRenderKitId(renderKitId);
        UIViewRoot currentViewRoot = context.getViewRoot();
        context.setViewRoot((UIViewRoot)viewRoot);
        LayoutDefinition def = null;
        try {
            def = viewRoot.getLayoutDefinition(context);
        }
        catch (LayoutDefinitionException ex) {
            if (LogUtil.configEnabled()) {
                LogUtil.config("JSFT0005", viewId);
                if (LogUtil.finestEnabled()) {
                    LogUtil.finest("File (" + viewId + ") not found!", ex);
                }
            }
            if (currentViewRoot != null) {
                context.setViewRoot(currentViewRoot);
            }
            return this._oldViewHandler.createView(context, viewId);
        }
        catch (RuntimeException ex) {
            if (currentViewRoot != null) {
                context.setViewRoot(currentViewRoot);
            }
            throw ex;
        }
        if (def != null) {
            Iterator<Resource> it = def.getResources().iterator();
            Resource resource = null;
            while (it.hasNext()) {
                resource = it.next();
                resource.getFactory().getResource(context, resource);
            }
            LayoutViewHandler.buildUIComponentTree(context, (UIComponent)viewRoot, def);
        }
        if (currentViewRoot != null) {
            context.setViewRoot(currentViewRoot);
        }
        return viewRoot;
    }

    public UIViewRoot serveResource(FacesContext context, String path) {
        LayoutViewRoot root;
        block11: {
            context.responseComplete();
            root = new LayoutViewRoot();
            root.setRenderKitId("dummy");
            FacesStreamerContext fsContext = new FacesStreamerContext(context);
            fsContext.setAttribute("filePath", path);
            Object obj = context.getExternalContext().getResponse();
            HttpServletResponse resp = null;
            if (obj instanceof HttpServletResponse) {
                resp = (HttpServletResponse)obj;
                long mod = fsContext.getContentSource().getLastModified(fsContext);
                if (mod != -1L) {
                    long ifModifiedSince = ((HttpServletRequest)context.getExternalContext().getRequest()).getDateHeader("If-Modified-Since");
                    if (ifModifiedSince < mod / 1000L * 1000L) {
                        resp.setDateHeader("Last-Modified", mod);
                    } else {
                        resp.setStatus(304);
                        return root;
                    }
                }
            }
            try {
                FileStreamer.getFileStreamer().streamContent(fsContext);
            }
            catch (FileNotFoundException ex) {
                if (LogUtil.infoEnabled()) {
                    LogUtil.info("JSFT0004", path);
                }
                if (resp != null) {
                    try {
                        resp.sendError(404);
                    }
                    catch (IOException ioEx) {}
                }
            }
            catch (IOException ex) {
                if (!LogUtil.infoEnabled()) break block11;
                LogUtil.info("JSFT0004", path);
                if (!LogUtil.fineEnabled()) break block11;
                LogUtil.fine("Resource (" + path + ") not available!", ex);
            }
        }
        return root;
    }

    public static String getEncoding(FacesContext ctx) {
        String encType = null;
        if (ctx != null) {
            ExternalContext extCtx;
            ServletRequest request;
            UIViewRoot root = ctx.getViewRoot();
            Map<String, Serializable> map = PageSessionResolver.getPageSession(ctx, root);
            if (map != null) {
                encType = (String)((Object)map.get(ENCODING_TYPE));
            }
            if (encType == null || encType.equals("")) {
                encType = ctx.getExternalContext().getInitParameter(ENCODING_TYPE);
            }
            if ((encType == null || encType.equals("")) && ((encType = (request = (ServletRequest)(extCtx = ctx.getExternalContext()).getRequest()).getCharacterEncoding()) == null || encType.equals(""))) {
                encType = "UTF-8";
            }
        }
        return encType;
    }

    public String getResourcePath(String viewId) {
        ExternalContext extCtx = FacesContext.getCurrentInstance().getExternalContext();
        String servletPath = extCtx.getRequestServletPath();
        Iterator<String> it = this.getResourcePrefixes().iterator();
        while (it.hasNext()) {
            if (!servletPath.equals(it.next())) continue;
            return extCtx.getRequestPathInfo();
        }
        return null;
    }

    public List<String> getResourcePrefixes() {
        if (this._resourcePrefix == null) {
            ArrayList<String> list = new ArrayList<String>();
            String initParam = (String)FacesContext.getCurrentInstance().getExternalContext().getInitParameterMap().get(RESOURCE_PREFIX);
            if (initParam != null) {
                list.add(initParam);
            }
            list.add(DEFAULT_RESOURCE_PREFIX);
            this._resourcePrefix = list;
        }
        return this._resourcePrefix;
    }

    public void setResourcePrefixes(List<String> prefix) {
        this._resourcePrefix = prefix;
    }

    public static void buildUIComponentTree(FacesContext context, UIComponent parent, LayoutElement elt) {
        Iterator<LayoutElement> it = elt.getChildLayoutElements().iterator();
        UIComponent child = null;
        while (it.hasNext()) {
            LayoutElement childElt = it.next();
            if (childElt instanceof LayoutFacet && !((LayoutFacet)childElt).isRendered()) {
                LayoutViewHandler.buildUIComponentTree(context, parent, childElt);
            }
            if (childElt instanceof LayoutComponent) {
                child = ((LayoutComponent)childElt).getChild(context, parent);
                LayoutViewHandler.buildUIComponentTree(context, child, childElt);
                continue;
            }
            LayoutViewHandler.buildUIComponentTree(context, parent, childElt);
        }
    }

    public UIViewRoot restoreView(FacesContext context, String viewId) {
        Map map = context.getExternalContext().getRequestMap();
        if (map.get(RESTORE_VIEW_ID) != null) {
            return this.createView(context, viewId);
        }
        map.put(RESTORE_VIEW_ID, viewId);
        UIViewRoot root = this._oldViewHandler.restoreView(context, viewId);
        return root;
    }

    public void renderView(FacesContext context, UIViewRoot viewToRender) throws IOException {
        LayoutDefinition def = null;
        if (viewToRender instanceof LayoutViewRoot) {
            def = ((LayoutViewRoot)viewToRender).getLayoutDefinition(context);
        }
        if (def == null) {
            this._oldViewHandler.renderView(context, viewToRender);
        } else {
            ResponseWriter writer = this.setupResponseWriter(context);
            writer.startDocument();
            UIComponent target = (UIComponent)context.getExternalContext().getRequestMap().get(AJAX_REQ_TARGET_KEY);
            if (target != null) {
                LayoutViewHandler.renderComponent(context, target);
            } else {
                def.encode(context, (UIComponent)viewToRender);
            }
            writer.endDocument();
        }
    }

    private static void renderComponent(FacesContext context, UIComponent comp) throws IOException {
        if (!comp.isRendered()) {
            return;
        }
        comp.encodeBegin(context);
        if (comp.getRendersChildren()) {
            comp.encodeChildren(context);
        } else {
            UIComponent child2 = null;
            for (UIComponent child2 : comp.getChildren()) {
                LayoutViewHandler.renderComponent(context, child2);
            }
        }
        comp.encodeEnd(context);
    }

    private ResponseWriter setupResponseWriter(FacesContext context) throws IOException {
        ResponseWriter writer = context.getResponseWriter();
        if (writer != null) {
            return writer;
        }
        ExternalContext extCtx = context.getExternalContext();
        ServletResponse response = (ServletResponse)extCtx.getResponse();
        ServletRequest request = (ServletRequest)extCtx.getRequest();
        RenderKitFactory renderFactory = (RenderKitFactory)FactoryFinder.getFactory((String)"javax.faces.render.RenderKitFactory");
        RenderKit renderKit = renderFactory.getRenderKit(context, context.getViewRoot().getRenderKitId());
        String contentTypeList = null;
        String userContentType = "text/html";
        boolean responseCTSet = false;
        if (userContentType != null && userContentType.length() > 0) {
            response.setContentType(userContentType);
            responseCTSet = true;
        } else {
            contentTypeList = (String)extCtx.getRequestHeaderMap().get("Accept");
            if (contentTypeList == null) {
                contentTypeList = "text/html;q=1.0";
            }
        }
        String encType = LayoutViewHandler.getEncoding(context);
        response.setCharacterEncoding(encType);
        writer = renderKit.createResponseWriter((Writer)new OutputStreamWriter((OutputStream)response.getOutputStream(), encType), contentTypeList, encType);
        context.setResponseWriter(writer);
        response.setContentType(writer.getContentType());
        return writer;
    }

    public void writeState(FacesContext context) throws IOException {
        UIViewRoot root = context.getViewRoot();
        if (root == null || !(root instanceof LayoutViewRoot) || ((LayoutViewRoot)root).getLayoutDefinition(context) == null) {
            this._oldViewHandler.writeState(context);
        } else {
            StateManager stateManager = context.getApplication().getStateManager();
            StateManager.SerializedView view = stateManager.saveSerializedView(context);
            stateManager.writeState(context, view);
        }
    }

    public String getResourceURL(FacesContext context, String path) {
        return this._oldViewHandler.getResourceURL(context, path);
    }

    public String getActionURL(FacesContext context, String viewId) {
        return this._oldViewHandler.getActionURL(context, viewId);
    }

    public Locale calculateLocale(FacesContext context) {
        return this._oldViewHandler.calculateLocale(context);
    }

    public String calculateRenderKitId(FacesContext context) {
        return this._oldViewHandler.calculateRenderKitId(context);
    }
}

