/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.transform.elements;

import com.sun.enterprise.tools.upgrade.transform.elements.BaseElement;
import java.util.StringTokenizer;
import java.util.logging.Level;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.w3c.dom.Text;

public class JVMOptions
extends BaseElement {
    private String JAVA_EXT_DIRS = "-Djava.ext.dirs";
    private String JDBC_DRIVERS = "-Djdbc.drivers";

    public void transform(Element element, Element parentSource, Element parentResult) {
        NodeList jvmOptions = parentResult.getElementsByTagName("jvm-options");
        Element jvmOption = null;
        Object modPropValue = null;
        Object modSrcTxtData = null;
        Object oldTextNode = null;
        Object newTextNode = null;
        String srcTxtDt = this.getTextNodeData(element);
        String[] sourceTextData = this.parseTextData(srcTxtDt);
        if (sourceTextData == null) {
            if (this.canTransfer(srcTxtDt, "")) {
                for (int lh = 0; lh < jvmOptions.getLength(); ++lh) {
                    String tgTxtDt = this.getTextNodeData((Element)jvmOptions.item(lh));
                    String[] targetTextData = this.parseTextData(tgTxtDt);
                    if (targetTextData != null || !srcTxtDt.equals(tgTxtDt)) continue;
                    jvmOption = (Element)jvmOptions.item(lh);
                    break;
                }
                if (jvmOption == null) {
                    jvmOption = parentResult.getOwnerDocument().createElement("jvm-options");
                    Text textNode = jvmOption.getOwnerDocument().createTextNode(srcTxtDt);
                    jvmOption.appendChild(textNode);
                    parentResult.appendChild(jvmOption);
                }
            } else {
                this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.transform.jvmoptions.notTransferred", (Object)srcTxtDt));
            }
            return;
        }
        if (srcTxtDt.trim().equals("-Djdbc.drivers=com.pointbase.jdbc.jdbcUniversalDriver")) {
            return;
        }
        if (this.canTransfer(sourceTextData[0], sourceTextData[1])) {
            for (int lh = 0; lh < jvmOptions.getLength(); ++lh) {
                String tgTxtDt = this.getTextNodeData((Element)jvmOptions.item(lh));
                if (srcTxtDt.equals(tgTxtDt)) {
                    jvmOption = (Element)jvmOptions.item(lh);
                    break;
                }
                String[] targetTextData = this.parseTextData(tgTxtDt);
                if (sourceTextData == null || targetTextData == null || !sourceTextData[0].equals(targetTextData[0])) continue;
                jvmOption = (Element)jvmOptions.item(lh);
                break;
            }
            if (jvmOption == null) {
                if (sourceTextData[1].indexOf(commonInfoModel.getSourceInstallDir()) == -1) {
                    jvmOption = parentResult.getOwnerDocument().createElement("jvm-options");
                    Text textNode = jvmOption.getOwnerDocument().createTextNode(srcTxtDt);
                    jvmOption.appendChild(textNode);
                    parentResult.appendChild(jvmOption);
                }
            }
        } else {
            this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.transform.jvmoptions.notTransferred", (Object)sourceTextData[0]));
        }
    }

    private String[] parseTextData(String fullStr) {
        String[] parsedStrings = null;
        StringTokenizer stk = new StringTokenizer(fullStr, "=");
        if (stk.hasMoreTokens() && stk.countTokens() == 2) {
            parsedStrings = new String[]{stk.nextToken(), stk.nextToken()};
        }
        return parsedStrings;
    }

    private String getTextNodeData(Element element) {
        NodeList children = element.getChildNodes();
        for (int index = 0; index < children.getLength(); ++index) {
            if (children.item(index).getNodeType() != 3) continue;
            return children.item(index).getNodeValue();
        }
        return "";
    }

    private boolean canTransfer(String optionName, String optionValue) {
        if (optionName.indexOf("Dorg.xml.sax.parser") != -1 || optionName.indexOf("Dorg.xml.sax.driver") != -1 || optionName.indexOf("Dcom.sun.jdo.api.persistence.model.multipleClassLoaders") != -1 || optionName.indexOf("Djava.util.logging.manager") != -1 || optionName.indexOf("Dcom.sun.aas.imqLib") != -1 || optionName.indexOf("Dcom.sun.aas.imqBin") != -1 || optionName.indexOf("Dcom.sun.aas.webServicesLib") != -1 || optionName.indexOf("Djavax.rmi.CORBA.UtilClass") != -1 || optionName.indexOf("Dcom.sun.aas.configRoot") != -1) {
            return false;
        }
        if (optionName.indexOf("Xbootclasspath") != -1 || optionName.indexOf("Xloggc") != -1 || optionName.indexOf("Xms") != -1 || optionName.indexOf("Xmx") != -1 || optionName.indexOf("Xss") != -1) {
            return false;
        }
        if (commonInfoModel.isPlatformEdition(commonInfoModel.getSourceEdition()) && (optionName.indexOf("Djavax.net.ssl.trustStore") != -1 || optionName.indexOf("Djavax.net.ssl.keyStore") != -1)) {
            return false;
        }
        String repOpValue = commonInfoModel.getSourceInstallDir().replace('\\', '/');
        if (optionValue.indexOf(repOpValue) != -1 || optionValue.indexOf(commonInfoModel.getSourceInstallDir()) != -1) {
            return false;
        }
        return !commonInfoModel.isEnterpriseEdition(commonInfoModel.getSourceEdition()) || optionName.indexOf("javax.net.ssl") == -1;
    }

    public String insertDerbyJars(String propValue) {
        String prefixValue = propValue.substring(0, propValue.lastIndexOf("${path.separator}"));
        String suffixValue = propValue.substring(propValue.lastIndexOf("${path.separator}"), propValue.length());
        return prefixValue + "${path.separator}/${com.sun.aas.derbyRoot}/lib" + suffixValue;
    }
}

