/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.miscconfig;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.IOException;
import java.lang.reflect.Method;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.helpers.DefaultHandler;

public class InitConfTransfer {
    private CommonInfoModel commonInfo;
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.miscconfig");
    private Logger logger = CommonInfoModel.getDefaultLogger();

    public InitConfTransfer(CommonInfoModel cim) {
        this.commonInfo = cim;
    }

    public void transform() {
        this.logger.log(Level.INFO, this.stringManager.getString("upgrade.configTransfers.initconf.startMessage"));
        String fileName = this.commonInfo.getSourceInitConfFileName();
        BufferedReader reader = null;
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        factory.setNamespaceAware(true);
        try {
            DocumentBuilder builderDomainXml = factory.newDocumentBuilder();
            builderDomainXml.setEntityResolver((DefaultHandler)Class.forName("com.sun.enterprise.config.serverbeans.ServerValidationHandler").newInstance());
            Document resultDoc = builderDomainXml.parse(new File(this.commonInfo.getTargetConfigXMLFile()));
            reader = new BufferedReader(new FileReader(fileName));
            while (reader.ready()) {
                String line = reader.readLine();
                String key = null;
                String value = null;
                StringTokenizer st = new StringTokenizer(line, " ", false);
                if (!st.hasMoreTokens()) continue;
                key = st.nextToken();
                if (!st.hasMoreTokens()) continue;
                value = st.nextToken();
                try {
                    Method m = this.getClass().getMethod("transform" + key, Document.class, String.class);
                    m.invoke((Object)this, resultDoc, value);
                }
                catch (NoSuchMethodException nsm) {
                    this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.configTransfers.initconf.unsupportedElement") + key);
                }
                catch (Exception e) {
                    this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.configTransfers.initconf.exception") + e.getLocalizedMessage());
                }
            }
            TransformerFactory tFactory = TransformerFactory.newInstance();
            Transformer transformer = tFactory.newTransformer();
            if (resultDoc.getDoctype() != null) {
                String systemValue = resultDoc.getDoctype().getSystemId();
                transformer.setOutputProperty("doctype-system", systemValue);
                String pubValue = resultDoc.getDoctype().getPublicId();
                transformer.setOutputProperty("doctype-public", pubValue);
            }
            DOMSource source = new DOMSource(resultDoc);
            StreamResult result = new StreamResult(new FileOutputStream(this.commonInfo.getTargetConfigXMLFile()));
            transformer.transform(source, result);
        }
        catch (IOException ioe) {
            this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.configTransfers.initconf.iofailure") + ioe.getLocalizedMessage());
        }
        catch (Exception e) {
            this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.configTransfers.initconf.exception") + e.getLocalizedMessage());
        }
        if (reader != null) {
            try {
                reader.close();
            }
            catch (Exception e) {
                this.logger.log(Level.WARNING, this.stringManager.getString("upgrade.configTransfers.initconf.iofailure") + e.getLocalizedMessage());
            }
        }
    }

    public void transformServerName(Document domainXML, String value) {
    }

    public void transformServerID(Document domainXML, String value) {
    }

    public void transformExtraPath(Document domainXML, String value) {
    }

    public void transformInit(Document domainXML, String value) {
    }

    public void transformNetsiteRoot(Document domainXML, String value) {
    }

    public void transformDNS(Document domainXML, String value) {
        this.logger.finest("DNS = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList httpList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(httpList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("http-protocol")).item(0)) == null) continue;
            if (value.equalsIgnoreCase("off")) {
                element.setAttribute("dns-lookup-enabled", "false");
                continue;
            }
            element.setAttribute("dns-lookup-enabled", "true");
        }
    }

    public void transformAsyncDNS(Document domainXML, String value) {
    }

    public void transformConnQueueSize(Document domainXML, String value) {
        this.logger.finest("ConnQueueSize = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList subList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(subList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("connection-pool")).item(0)) == null) continue;
            element.setAttribute("queue-size-in-bytes", value);
        }
    }

    public void transformHeaderBufferSize(Document domainXML, String value) {
        this.logger.finest("HeaderBufferSize = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList subList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(subList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("request-processing")).item(0)) == null) continue;
            element.setAttribute("header-buffer-size-bytes", value);
        }
    }

    public void transformIOTimeout(Document domainXML, String value) {
        this.logger.finest("IOTimeout = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList subList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(subList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("request-processing")).item(0)) == null) continue;
            element.setAttribute("request-timeout-in-seconds", value);
        }
    }

    public void transformKeepAliveThreads(Document domainXML, String value) {
        this.logger.finest("KeepAliveThreads = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList subList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(subList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("keep-alive")).item(0)) == null) continue;
            element.setAttribute("keep-alive-thread-count", value);
        }
    }

    public void transformKeepAliveTimeout(Document domainXML, String value) {
        this.logger.finest("KeepAliveTimeout = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList subList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(subList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("keep-alive")).item(0)) == null) continue;
            element.setAttribute("timeout-in-seconds", value);
        }
    }

    public void transformKernelThreads(Document domainXML, String value) {
    }

    public void transformListenQ(Document domainXML, String value) {
        this.logger.finest("ListenQ = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList subList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(subList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("connection-pool")).item(0)) == null) continue;
            element.setAttribute("max-pending-count", value);
        }
    }

    public void transformRcvBufSize(Document domainXML, String value) {
        this.logger.finest("RcvBufSize = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList subList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(subList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("connection-pool")).item(0)) == null) continue;
            element.setAttribute("receive-buffer-size-bytes", value);
        }
    }

    public void transformMaxKeepAliveConnections(Document domainXML, String value) {
        this.logger.finest("MaxKeepAliveConnections = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList subList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(subList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("keep-alive")).item(0)) == null) continue;
            element.setAttribute("max-keep-alive-connections", value);
        }
    }

    public void transformRqThrottle(Document domainXML, String value) {
        this.logger.finest("RqThrottle = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList subList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(subList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("request-processing")).item(0)) == null) continue;
            element.setAttribute("thread-count", value);
        }
    }

    public void transformRqThrottleMin(Document domainXML, String value) {
        this.logger.finest("RqThrottleMin = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList subList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(subList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("request-processing")).item(0)) == null) continue;
            element.setAttribute("initial-thread-count", value);
        }
    }

    public void transformSndBufSize(Document domainXML, String value) {
        this.logger.finest("SndBufSize = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList subList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(subList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("connection-pool")).item(0)) == null) continue;
            element.setAttribute("send-buffer-size-bytes", value);
        }
    }

    public void transformStackSize(Document domainXML, String value) {
        String name = "stack-size";
        this.logger.finest("StackSize = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config")) continue;
            NodeList httpServiceNodes = configElement.getElementsByTagName("http-service");
            Element httpServiceElement = (Element)httpServiceNodes.item(0);
            NodeList resultProperties = httpServiceElement.getElementsByTagName("property");
            Element resultProperty = null;
            if (resultProperties != null) {
                for (int index = 0; index < resultProperties.getLength(); ++index) {
                    if (!((Element)resultProperties.item(index)).getAttribute("name").equals(name)) continue;
                    resultProperty = (Element)resultProperties.item(index);
                    resultProperty.getAttributeNode("value").setValue(value);
                    break;
                }
            }
            if (resultProperty != null) continue;
            resultProperty = httpServiceElement.getOwnerDocument().createElement("property");
            resultProperty.setAttribute("name", name);
            resultProperty.setAttribute("value", value);
            httpServiceElement.appendChild(resultProperty);
        }
    }

    public void transformStrictHttpHeaders(Document domainXML, String value) {
    }

    public void transformTerminateTimeout(Document domainXML, String value) {
    }

    public void transformUser(Document domainXML, String value) {
    }

    public void transformTempDir(Document domainXML, String value) {
    }

    public void transformThreadIncrement(Document domainXML, String value) {
        this.logger.finest("ThreadIncrement = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList subList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(subList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("request-processing")).item(0)) == null) continue;
            element.setAttribute("thread-increment", value);
        }
    }

    public void transformNativePoolStackSize(Document domainXML, String value) {
    }

    public void transformNativePoolMaxThreads(Document domainXML, String value) {
    }

    public void transformNativePoolMinThreads(Document domainXML, String value) {
    }

    public void transformNativePoolQueueSize(Document domainXML, String value) {
    }

    public void transformErrorLogDateFormat(Document domainXML, String value) {
    }

    public void transformLogFlushInterval(Document domainXML, String value) {
    }

    public void transformPidLog(Document domainXML, String value) {
    }

    public void transformSecurity(Document domainXML, String value) {
        this.logger.finest("Security = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList httpList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(httpList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("http-protocol")).item(0)) == null) continue;
            if (value.equalsIgnoreCase("off")) {
                element.setAttribute("ssl-enabled", "false");
                continue;
            }
            element.setAttribute("ssl-enabled", "true");
        }
    }

    public void transformSSLCacheEntries(Document domainXML, String value) {
        String name = "ssl-cache-entries";
        this.logger.finest("SSLCacheEntries = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config")) continue;
            NodeList httpServiceNodes = configElement.getElementsByTagName("http-service");
            Element httpServiceElement = (Element)httpServiceNodes.item(0);
            NodeList resultProperties = httpServiceElement.getElementsByTagName("property");
            Element resultProperty = null;
            if (resultProperties != null) {
                for (int index = 0; index < resultProperties.getLength(); ++index) {
                    if (!((Element)resultProperties.item(index)).getAttribute("name").equals(name)) continue;
                    resultProperty = (Element)resultProperties.item(index);
                    resultProperty.getAttributeNode("value").setValue(value);
                    break;
                }
            }
            if (resultProperty != null) continue;
            resultProperty = httpServiceElement.getOwnerDocument().createElement("property");
            resultProperty.setAttribute("name", name);
            resultProperty.setAttribute("value", value);
            httpServiceElement.appendChild(resultProperty);
        }
    }

    public void transformSSLClientAuthDataLimit(Document domainXML, String value) {
        String name = "ssl-client-auth-data-limit";
        this.logger.finest("SSLClientAuthDataLimit = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config")) continue;
            NodeList httpServiceNodes = configElement.getElementsByTagName("http-service");
            Element httpServiceElement = (Element)httpServiceNodes.item(0);
            NodeList resultProperties = httpServiceElement.getElementsByTagName("property");
            Element resultProperty = null;
            if (resultProperties != null) {
                for (int index = 0; index < resultProperties.getLength(); ++index) {
                    if (!((Element)resultProperties.item(index)).getAttribute("name").equals(name)) continue;
                    resultProperty = (Element)resultProperties.item(index);
                    resultProperty.getAttributeNode("value").setValue(value);
                    break;
                }
            }
            if (resultProperty != null) continue;
            resultProperty = httpServiceElement.getOwnerDocument().createElement("property");
            resultProperty.setAttribute("name", name);
            resultProperty.setAttribute("value", value);
            httpServiceElement.appendChild(resultProperty);
        }
    }

    public void transformSSLClientAuthTimeout(Document domainXML, String value) {
        String name = "ssl-client-auth-timeout";
        this.logger.finest("SSLClientAuthTimeout = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config")) continue;
            NodeList httpServiceNodes = configElement.getElementsByTagName("http-service");
            Element httpServiceElement = (Element)httpServiceNodes.item(0);
            NodeList resultProperties = httpServiceElement.getElementsByTagName("property");
            Element resultProperty = null;
            if (resultProperties != null) {
                for (int index = 0; index < resultProperties.getLength(); ++index) {
                    if (!((Element)resultProperties.item(index)).getAttribute("name").equals(name)) continue;
                    resultProperty = (Element)resultProperties.item(index);
                    resultProperty.getAttributeNode("value").setValue(value);
                    break;
                }
            }
            if (resultProperty != null) continue;
            resultProperty = httpServiceElement.getOwnerDocument().createElement("property");
            resultProperty.setAttribute("name", name);
            resultProperty.setAttribute("value", value);
            httpServiceElement.appendChild(resultProperty);
        }
    }

    public void transformSSLSessionTimeout(Document domainXML, String value) {
        String name = "ssl-session-timeout";
        this.logger.finest("SSLSessionTimeout = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config")) continue;
            NodeList httpServiceNodes = configElement.getElementsByTagName("http-service");
            Element httpServiceElement = (Element)httpServiceNodes.item(0);
            NodeList resultProperties = httpServiceElement.getElementsByTagName("property");
            Element resultProperty = null;
            if (resultProperties != null) {
                for (int index = 0; index < resultProperties.getLength(); ++index) {
                    if (!((Element)resultProperties.item(index)).getAttribute("name").equals(name)) continue;
                    resultProperty = (Element)resultProperties.item(index);
                    resultProperty.getAttributeNode("value").setValue(value);
                    break;
                }
            }
            if (resultProperty != null) continue;
            resultProperty = httpServiceElement.getOwnerDocument().createElement("property");
            resultProperty.setAttribute("name", name);
            resultProperty.setAttribute("value", value);
            httpServiceElement.appendChild(resultProperty);
        }
    }

    public void transformSSL3SessionTimeout(Document domainXML, String value) {
        String name = "ssl3-session-timeout";
        this.logger.finest("SSL3SessionTimeout = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config")) continue;
            NodeList httpServiceNodes = configElement.getElementsByTagName("http-service");
            Element httpServiceElement = (Element)httpServiceNodes.item(0);
            NodeList resultProperties = httpServiceElement.getElementsByTagName("property");
            Element resultProperty = null;
            if (resultProperties != null) {
                for (int index = 0; index < resultProperties.getLength(); ++index) {
                    if (!((Element)resultProperties.item(index)).getAttribute("name").equals(name)) continue;
                    resultProperty = (Element)resultProperties.item(index);
                    resultProperty.getAttributeNode("value").setValue(value);
                    break;
                }
            }
            if (resultProperty != null) continue;
            resultProperty = httpServiceElement.getOwnerDocument().createElement("property");
            resultProperty.setAttribute("name", name);
            resultProperty.setAttribute("value", value);
            httpServiceElement.appendChild(resultProperty);
        }
    }

    public void transformHTTPVersion(Document domainXML, String value) {
        this.logger.finest("HTTPVersion = " + value);
        Element docEle = domainXML.getDocumentElement();
        NodeList nodeList = docEle.getElementsByTagName("config");
        for (int i = 0; i < nodeList.getLength(); ++i) {
            NodeList httpServiceNodes;
            Element httpServiceElement;
            NodeList httpList;
            Element element;
            Element configElement = (Element)nodeList.item(i);
            String attrValue = configElement.getAttribute("name");
            if (!attrValue.equals(this.commonInfo.getCurrentSourceInstance() + "-config") || (element = (Element)(httpList = (httpServiceElement = (Element)(httpServiceNodes = configElement.getElementsByTagName("http-service")).item(0)).getElementsByTagName("http-protocol")).item(0)) == null) continue;
            element.setAttribute("http-version", value);
        }
    }
}

