/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.gui;

import com.sun.enterprise.tools.upgrade.common.CommonInfoModel;
import com.sun.enterprise.tools.upgrade.gui.FlowLabel;
import com.sun.enterprise.tools.upgrade.gui.HeaderPanel;
import com.sun.enterprise.tools.upgrade.gui.util.DialogEvent;
import com.sun.enterprise.tools.upgrade.gui.util.DialogListener;
import com.sun.enterprise.util.i18n.StringManager;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Insets;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.KeyAdapter;
import java.awt.event.KeyEvent;
import java.io.File;
import java.util.Vector;
import java.util.logging.Logger;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JFileChooser;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JPasswordField;
import javax.swing.JTextField;

public class DataCollectionPanel
extends JPanel {
    private FlowLabel flowContentLabel;
    private FlowLabel sourceHelpLabel;
    private JLabel sourceDirLabel;
    private JLabel destDirLabel;
    private JTextField sourceDirTextField;
    private JTextField destDirTextField;
    private JButton sourceDirectoryBrowseButton;
    private JButton destDirBrowseButton;
    private JPanel containerPanel;
    private JCheckBox upgradeCertificates;
    private JTextField adminUserTextField;
    private JPasswordField adminPWTextField;
    private JPasswordField masterPWTextField;
    private JFileChooser fileChooser = null;
    private Vector dialogListeners = new Vector();
    private CommonInfoModel commonInfoModel;
    private StringManager stringManager = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.gui");
    private Logger logger = CommonInfoModel.getDefaultLogger();

    public DataCollectionPanel(CommonInfoModel coInfoModel) {
        this.commonInfoModel = coInfoModel;
        this.initialize();
    }

    public String getSourceDirectoryPath() {
        return this.sourceDirTextField.getText();
    }

    public String getDestinationDirectoryPath() {
        return this.destDirTextField.getText();
    }

    public String getAdminUserName() {
        return this.adminUserTextField.getText();
    }

    public String getAdminPassword() {
        return this.adminPWTextField.getText();
    }

    public String getMasterPassword() {
        return this.masterPWTextField.getText();
    }

    public boolean isUpgradeCertificatesSelected() {
        return this.upgradeCertificates.isSelected();
    }

    public void addDialogListener(DialogListener listener) {
        this.dialogListeners.addElement(listener);
    }

    public void removeDialogListener(DialogListener listener) {
        this.dialogListeners.removeElement(listener);
    }

    private void initialize() {
        this.initComponents();
        this.setLayout(new BorderLayout());
        HeaderPanel headerPanel = new HeaderPanel(this.stringManager.getString("upgrade.gui.detailspanel.headerPanel"));
        headerPanel.setInsets(new Insets(12, 10, 5, 10));
        this.add((Component)headerPanel, "North");
        this.add((Component)this.containerPanel, "Center");
        this.sourceDirectoryBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataCollectionPanel.this.sourceActionPerformed(evt);
            }
        });
        this.destDirBrowseButton.addActionListener(new ActionListener(){

            public void actionPerformed(ActionEvent evt) {
                DataCollectionPanel.this.destActionPerformed(evt);
            }
        });
        this.getfileChooser().setFileSelectionMode(1);
        KeyAdapter keyAdapter = new KeyAdapter(){

            public void keyReleased(KeyEvent ke) {
                DataCollectionPanel.this.processDialogEvent();
            }
        };
        this.sourceDirTextField.addKeyListener(keyAdapter);
        this.destDirTextField.addKeyListener(keyAdapter);
        String sourceDir = this.commonInfoModel.getSourceInstallDir();
        String targetDir = this.commonInfoModel.getTargetDomainRoot();
        if (sourceDir != null && !sourceDir.equals("")) {
            this.sourceDirTextField.setText(sourceDir);
        }
        if (targetDir != null && !targetDir.equals("")) {
            this.destDirTextField.setText(targetDir);
        }
        String adminUserName = this.commonInfoModel.getAdminUserName();
        String adminPassword = this.commonInfoModel.getAdminPassword();
        this.adminUserTextField.addKeyListener(keyAdapter);
        this.adminPWTextField.addKeyListener(keyAdapter);
        this.masterPWTextField.addKeyListener(keyAdapter);
        if (adminUserName != null && !adminUserName.equals("")) {
            this.adminUserTextField.setText(adminUserName);
        }
        if (adminPassword != null && !adminPassword.equals("")) {
            this.adminPWTextField.setText(adminPassword);
        }
    }

    private void initComponents() {
        this.flowContentLabel = new FlowLabel();
        this.sourceHelpLabel = new FlowLabel();
        this.sourceDirLabel = new JLabel();
        this.sourceDirTextField = new JTextField();
        this.sourceDirectoryBrowseButton = new JButton();
        this.destDirLabel = new JLabel();
        this.destDirTextField = new JTextField();
        this.destDirBrowseButton = new JButton();
        this.containerPanel = new JPanel();
        this.containerPanel.setLayout(new GridBagLayout());
        this.flowContentLabel.setText(this.stringManager.getString("upgrade.gui.detailspanel.flowContentLable"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 0);
        gridBagConstraints.weightx = 1.0;
        this.containerPanel.add((Component)this.flowContentLabel, gridBagConstraints);
        this.sourceDirLabel.setText(this.stringManager.getString("upgrade.gui.detailspanel.sourceDirLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 3, 10);
        gridBagConstraints.weightx = 1.0;
        this.containerPanel.add((Component)this.sourceDirLabel, gridBagConstraints);
        this.sourceDirTextField.setToolTipText(this.stringManager.getString("upgrade.gui.detailspanel.sourceHelpLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 5);
        gridBagConstraints.weightx = 1.0;
        this.containerPanel.add((Component)this.sourceDirTextField, gridBagConstraints);
        this.sourceDirectoryBrowseButton.setText(this.stringManager.getString("upgrade.gui.detailspanel.browseButtonText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.insets = new Insets(0, 5, 10, 10);
        this.containerPanel.add((Component)this.sourceDirectoryBrowseButton, gridBagConstraints);
        this.destDirLabel.setText(this.stringManager.getString("upgrade.gui.detailspanel.targetDirLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 3, 10);
        gridBagConstraints.weightx = 1.0;
        this.containerPanel.add((Component)this.destDirLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 5);
        gridBagConstraints.weightx = 1.0;
        this.containerPanel.add((Component)this.destDirTextField, gridBagConstraints);
        this.destDirBrowseButton.setText(this.stringManager.getString("upgrade.gui.detailspanel.browseButtonText"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 4;
        gridBagConstraints.insets = new Insets(0, 5, 10, 5);
        this.containerPanel.add((Component)this.destDirBrowseButton, gridBagConstraints);
        this.upgradeCertificates = new JCheckBox(this.stringManager.getString("upgrade.gui.detailspanel.transferCertCheckBoxText"), false);
        this.upgradeCertificates.setVisible(false);
        this.upgradeCertificates.setSelected(false);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 5;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 10, 5);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.containerPanel.add((Component)this.upgradeCertificates, gridBagConstraints);
        JPanel adminUserPwPanel = this.getAdminUserPasswordPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 6;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 0, 3, 10);
        gridBagConstraints.weightx = 1.0;
        gridBagConstraints.weighty = 0.0;
        this.containerPanel.add((Component)adminUserPwPanel, gridBagConstraints);
        if (this.commonInfoModel.isPlatformEdition(this.commonInfoModel.getSourceEdition())) {
            JPanel dummyPanel = new JPanel();
            gridBagConstraints = new GridBagConstraints();
            gridBagConstraints.gridx = 0;
            gridBagConstraints.gridy = 7;
            gridBagConstraints.gridheight = 1;
            gridBagConstraints.gridwidth = 2;
            gridBagConstraints.fill = 1;
            gridBagConstraints.insets = new Insets(0, 10, 3, 10);
            gridBagConstraints.weightx = 1.0;
            gridBagConstraints.weighty = 1.0;
            this.containerPanel.add((Component)dummyPanel, gridBagConstraints);
        }
    }

    private JPanel getAdminUserPasswordPanel() {
        JPanel panel = new JPanel();
        JLabel admiUserLabel = new JLabel();
        JLabel admiPWLabel = new JLabel();
        this.adminUserTextField = new JTextField();
        this.adminPWTextField = new JPasswordField();
        panel.setLayout(new GridBagLayout());
        admiUserLabel.setText(this.stringManager.getString("upgrade.gui.detailspanel.adminUserLabel"));
        GridBagConstraints gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 3, 20);
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)admiUserLabel, gridBagConstraints);
        admiPWLabel.setText(this.stringManager.getString("upgrade.gui.detailspanel.adminPWLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 0;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 20, 3, 10);
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)admiPWLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 5, 20);
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.adminUserTextField, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 1;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 5, 10);
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.adminPWTextField, gridBagConstraints);
        JLabel masterPWLabel = new JLabel();
        this.masterPWTextField = new JPasswordField();
        masterPWLabel.setText(this.stringManager.getString("upgrade.gui.detailspanel.masterPWLabel"));
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 2;
        gridBagConstraints.gridwidth = 2;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(10, 10, 3, 5);
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)masterPWLabel, gridBagConstraints);
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 0;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 10, 10, 5);
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)this.masterPWTextField, gridBagConstraints);
        JPanel dummyPanel = new JPanel();
        gridBagConstraints = new GridBagConstraints();
        gridBagConstraints.gridx = 1;
        gridBagConstraints.gridy = 3;
        gridBagConstraints.gridwidth = 1;
        gridBagConstraints.gridheight = 1;
        gridBagConstraints.fill = 2;
        gridBagConstraints.insets = new Insets(0, 20, 10, 5);
        gridBagConstraints.weightx = 1.0;
        panel.add((Component)dummyPanel, gridBagConstraints);
        return panel;
    }

    private void sourceActionPerformed(ActionEvent evt) {
        this.getfileChooser().setCurrentDirectory(new File(this.sourceDirTextField.getText()));
        int returnedValue = this.getfileChooser().showOpenDialog(this);
        if (returnedValue == 0) {
            this.sourceDirTextField.setText(String.valueOf(this.getfileChooser().getSelectedFile()));
            this.processDialogEvent();
        }
    }

    private void destActionPerformed(ActionEvent evt) {
        this.getfileChooser().setCurrentDirectory(new File(this.destDirTextField.getText()));
        int returnedValue = this.getfileChooser().showOpenDialog(this);
        if (returnedValue == 0) {
            this.destDirTextField.setText(String.valueOf(this.getfileChooser().getSelectedFile()));
            this.processDialogEvent();
        }
    }

    private JFileChooser getfileChooser() {
        if (this.fileChooser == null) {
            this.fileChooser = new JFileChooser();
            this.fileChooser.setName("fileChooser");
            this.fileChooser.setBounds(668, 49, 500, 300);
            this.fileChooser.setDialogTitle(this.stringManager.getString("upgrade.gui.detailspanel.fileChooseTitle"));
        }
        return this.fileChooser;
    }

    private void processDialogEvent() {
        DialogEvent de = new DialogEvent(this, 7);
        for (int i = 0; i < this.dialogListeners.size(); ++i) {
            ((DialogListener)this.dialogListeners.elementAt(i)).dialogProcessed(de);
        }
    }
}

