/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.common.arguments;

import com.sun.enterprise.tools.upgrade.common.UpgradeUtils;
import com.sun.enterprise.tools.upgrade.common.arguments.ARG_noprompt;
import com.sun.enterprise.tools.upgrade.common.arguments.ArgumentHandler;
import com.sun.enterprise.tools.upgrade.common.arguments.ParsedArgument;

public class ARG_passwordfile
extends ArgumentHandler {
    public ARG_passwordfile(ParsedArgument pa) {
        super(pa);
        String msg = this.sm.getString("enterprise.tools.upgrade.cli.argument_missing", (Object)"--passwordfile+/-f");
        if (this.parameters.isEmpty()) {
            this.helpUsage(msg);
            System.exit(1);
        }
        String pwdFile = (String)this.parameters.firstElement();
        this.commonInfo.setPasswordsFromFile(pwdFile);
        String adminUser = this.commonInfo.getAdminUserName();
        if (adminUser == null) {
            adminUser = ARG_noprompt.defaultAdminUser;
            this.commonInfo.setAdminUserName(adminUser);
        }
        this.interactiveMap.put("adminuser", this.commonInfo.getAdminUserName());
        this.interactiveMap.put("masterpassword", this.commonInfo.getMasterPassword());
        this.interactiveMap.put("adminpassword", this.commonInfo.getAdminPassword());
        String adminPassword = this.commonInfo.getAdminPassword();
        String masterPassword = null;
        String sourceEdition = this.commonInfo.getSourceEdition();
        if (sourceEdition != null && !"".equals(sourceEdition)) {
            masterPassword = this.commonInfo.getMasterPassword();
        }
        if (!UpgradeUtils.getUpgradeUtils(this.commonInfo).validateUserDetails(adminUser, adminPassword, masterPassword)) {
            this._logger.severe(this.sm.getString("enterprise.tools.upgrade.cli.wrong_adminuser_or_adminpassword_or_masterpassword"));
            System.exit(1);
        }
    }
}

