/*
 * Decompiled with CFR 0.152.
 */
package com.sun.enterprise.tools.upgrade.certconversion;

import com.sun.enterprise.tools.upgrade.certconversion.PrintStream;
import com.sun.enterprise.tools.upgrade.logging.LogService;
import com.sun.enterprise.util.i18n.StringManager;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import java.util.logging.Level;
import java.util.logging.Logger;

public class ProcessAdaptor {
    private static Logger _logger = LogService.getLogger("com.sun.enterprise.tools.upgrade");
    private static StringManager sm = StringManager.getManager((String)"com.sun.enterprise.tools.upgrade.certconversion");

    public static int executeProcess(String str, OutputStream outputStream) {
        String[] args = str.split(" ");
        return ProcessAdaptor.executeProcess(args, outputStream);
    }

    public static int executeProcess(String[] str, OutputStream outputStream) {
        int exitVal = -1;
        try {
            Process p = Runtime.getRuntime().exec(str);
            PrintStream errorOut = new PrintStream(p.getErrorStream(), outputStream);
            PrintStream resultOut = new PrintStream(p.getInputStream(), outputStream);
            errorOut.start();
            resultOut.start();
            errorOut.join();
            resultOut.join();
            exitVal = p.waitFor();
            p.destroy();
            return exitVal;
        }
        catch (InterruptedException ie) {
            _logger.log(Level.WARNING, sm.getString("enterprise.tools.upgrade.certconversion.process_execution_error"), ie);
        }
        catch (SecurityException se) {
            _logger.log(Level.WARNING, sm.getString("enterprise.tools.upgrade.certconversion.process_execution_error"), se);
        }
        catch (IOException ioe) {
            _logger.log(Level.WARNING, sm.getString("enterprise.tools.upgrade.certconversion.process_execution_error"), ioe);
        }
        return exitVal;
    }

    public static int executeProcess(String str, Writer writer) {
        String[] args = str.split(" ");
        int exitVal = ProcessAdaptor.executeProcess(args, writer);
        return exitVal;
    }

    public static int executeProcess(String[] str, Writer writer) {
        int exitVal = -1;
        try {
            Process p = Runtime.getRuntime().exec(str);
            PrintStream errorOut = new PrintStream(p.getErrorStream(), writer);
            PrintStream resultOut = new PrintStream(p.getInputStream(), writer);
            errorOut.start();
            resultOut.start();
            errorOut.join();
            resultOut.join();
            exitVal = p.waitFor();
            p.destroy();
            return exitVal;
        }
        catch (InterruptedException ie) {
            _logger.log(Level.WARNING, sm.getString("enterprise.tools.upgrade.certconversion.process_execution_error"), ie);
        }
        catch (SecurityException se) {
            _logger.log(Level.WARNING, sm.getString("enterprise.tools.upgrade.certconversion.process_execution_error"), se);
        }
        catch (IOException ioe) {
            _logger.log(Level.WARNING, sm.getString("enterprise.tools.upgrade.certconversion.process_execution_error"), ioe);
        }
        return exitVal;
    }
}

