/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.xindice.core.filer;

import java.io.File;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import net.jxta.impl.xindice.core.DBException;
import net.jxta.impl.xindice.core.data.Key;
import net.jxta.impl.xindice.core.data.Record;
import net.jxta.impl.xindice.core.data.RecordSet;
import net.jxta.impl.xindice.core.data.Value;
import net.jxta.impl.xindice.core.filer.Filer;
import net.jxta.impl.xindice.core.filer.FilerException;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public final class MemFiler
implements Filer {
    private Map<Key, Record> hashTable = null;
    private Map<Long, Key> posTable = null;
    private boolean opened = false;
    private boolean readOnly = false;
    private long position = 0L;

    public MemFiler() {
        this.hashTable = Collections.synchronizedMap(new HashMap());
        this.posTable = Collections.synchronizedMap(new HashMap());
    }

    public MemFiler(Map<Key, Record> hashTable, boolean readOnly) {
        this.hashTable = hashTable;
        this.readOnly = readOnly;
    }

    public MemFiler(Map<Key, Record> hashTable) {
        this(hashTable, false);
    }

    public void setLocation(File root, String location) {
    }

    @Override
    public String getName() {
        return "MemFiler";
    }

    private void checkOpened() throws DBException {
        if (!this.opened) {
            throw new FilerException(247, "Filer is closed");
        }
    }

    private void checkReadOnly() throws DBException {
        if (this.readOnly) {
            throw new FilerException(246, "Filer is read-only");
        }
    }

    @Override
    public boolean create() {
        this.hashTable.clear();
        return true;
    }

    @Override
    public boolean open() {
        this.opened = true;
        return this.opened;
    }

    @Override
    public boolean isOpened() {
        return this.opened;
    }

    @Override
    public boolean exists() {
        return true;
    }

    @Override
    public boolean drop() {
        this.hashTable.clear();
        this.opened = false;
        return !this.opened;
    }

    @Override
    public boolean close() {
        this.opened = false;
        return !this.opened;
    }

    @Override
    public void flush() {
    }

    @Override
    public Record readRecord(Key key) throws DBException {
        if (key == null || key.getLength() == 0) {
            return null;
        }
        this.checkOpened();
        return this.hashTable.get(key);
    }

    @Override
    public Record readRecord(long pos) throws DBException {
        if (pos < 0L) {
            return null;
        }
        this.checkOpened();
        Key key = this.posTable.get(pos);
        return this.hashTable.get(key);
    }

    @Override
    public long writeRecord(Key key, Value value) throws DBException {
        if (key == null || key.getLength() == 0) {
            throw new FilerException(571, "Invalid key: '" + key + "'");
        }
        if (value == null) {
            throw new FilerException(571, "Invalid null value");
        }
        this.checkOpened();
        this.checkReadOnly();
        this.hashTable.put(key, new Record(key, value));
        this.posTable.put(this.position, key);
        long result = this.position++;
        return result;
    }

    @Override
    public boolean deleteRecord(Key key) throws DBException {
        if (key == null || key.getLength() == 0) {
            return false;
        }
        this.checkOpened();
        this.checkReadOnly();
        return this.hashTable.remove(key) != null;
    }

    @Override
    public long getRecordCount() throws DBException {
        this.checkOpened();
        return this.hashTable.size();
    }

    @Override
    public RecordSet getRecordSet() throws DBException {
        this.checkOpened();
        return new MemRecordSet();
    }

    private class MemRecordSet
    implements RecordSet {
        private Iterator<Record> it;

        private MemRecordSet() {
            this.it = MemFiler.this.hashTable.values().iterator();
        }

        public synchronized boolean hasMoreRecords() throws DBException {
            return this.it.hasNext();
        }

        public synchronized Record getNextRecord() throws DBException {
            MemFiler.this.checkOpened();
            return this.it.next();
        }

        public synchronized Value getNextValue() throws DBException {
            MemFiler.this.checkOpened();
            return this.it.next().getValue();
        }

        public synchronized Key getNextKey() {
            return this.it.next().getKey();
        }
    }
}

