/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.impl.rendezvous;

import java.util.Enumeration;
import java.util.logging.Level;
import java.util.logging.Logger;
import net.jxta.discovery.DiscoveryService;
import net.jxta.document.Advertisement;
import net.jxta.endpoint.EndpointAddress;
import net.jxta.endpoint.EndpointService;
import net.jxta.endpoint.Message;
import net.jxta.endpoint.Messenger;
import net.jxta.endpoint.OutgoingMessageEvent;
import net.jxta.endpoint.OutgoingMessageEventListener;
import net.jxta.id.ID;
import net.jxta.impl.endpoint.EndpointUtils;
import net.jxta.impl.util.TimeUtils;
import net.jxta.logging.Logging;
import net.jxta.peergroup.PeerGroup;
import net.jxta.protocol.PeerAdvertisement;
import net.jxta.protocol.RouteAdvertisement;

public abstract class PeerConnection
implements OutgoingMessageEventListener {
    private static final transient Logger LOG = Logger.getLogger(PeerConnection.class.getName());
    protected final PeerGroup group;
    protected final EndpointService endpoint;
    protected final ID peerid;
    protected String peerName = null;
    protected volatile boolean connected = true;
    protected long leasedTil = -1L;
    protected Messenger cachedMessenger = null;

    public PeerConnection(PeerGroup group, EndpointService endpoint, ID peerid) {
        this.group = group;
        this.endpoint = endpoint;
        this.peerid = peerid;
        this.peerName = peerid.toString();
    }

    public boolean equals(Object obj) {
        return obj instanceof PeerConnection && this.peerid.equals(((PeerConnection)obj).peerid);
    }

    public int hashCode() {
        return this.peerid.hashCode();
    }

    public String toString() {
        return this.getPeerName() + (this.connected ? " C" : " c") + " : " + Long.toString(TimeUtils.toRelativeTimeMillis(this.leasedTil));
    }

    public void messageSendFailed(OutgoingMessageEvent event) {
        if (event.getFailure() == null) {
            return;
        }
        this.setConnected(false);
    }

    public void messageSendSucceeded(OutgoingMessageEvent event) {
    }

    public ID getPeerID() {
        return this.peerid;
    }

    public String getPeerName() {
        return this.peerName;
    }

    protected void setPeerName(String name) {
        this.peerName = name;
    }

    protected void setLease(long leaseDuration) {
        this.leasedTil = TimeUtils.toAbsoluteTimeMillis(leaseDuration);
    }

    public long getLeaseEnd() {
        return this.leasedTil;
    }

    protected void connect(long leaseDuration) {
        this.setLease(leaseDuration);
        this.setConnected(true);
    }

    public boolean isConnected() {
        this.connected &= TimeUtils.toRelativeTimeMillis(this.leasedTil) >= 0L;
        return this.connected;
    }

    public void setConnected(boolean isConnected) {
        this.connected = isConnected;
    }

    @Deprecated
    protected Messenger getCachedMessenger() {
        Messenger result = this.cachedMessenger;
        if (null == result || result.isClosed()) {
            PeerAdvertisement padv = null;
            DiscoveryService discovery = this.group.getDiscoveryService();
            if (null != discovery) {
                try {
                    Enumeration<Advertisement> each = discovery.getLocalAdvertisements(0, "PID", this.peerid.toString());
                    if (each.hasMoreElements()) {
                        padv = (PeerAdvertisement)each.nextElement();
                    }
                }
                catch (Exception ignored) {
                    // empty catch block
                }
            }
            result = this.getCachedMessenger(padv);
        }
        return result;
    }

    protected synchronized Messenger getCachedMessenger(PeerAdvertisement padv) {
        if (null != padv && !this.peerid.equals(padv.getPeerID())) {
            throw new IllegalArgumentException("Peer Advertisement does not match connection");
        }
        if (null != padv && null != padv.getName()) {
            this.setPeerName(padv.getName());
        }
        if (null != this.cachedMessenger && !this.cachedMessenger.isClosed()) {
            return this.cachedMessenger;
        }
        this.cachedMessenger = null;
        if (this.isConnected()) {
            if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
                LOG.fine("Getting new cached Messenger for " + this.peerName);
            }
            RouteAdvertisement hint = null;
            if (null != padv) {
                hint = EndpointUtils.extractRouteAdv(padv);
            }
            EndpointAddress destAddress = new EndpointAddress(this.peerid, null, null);
            this.cachedMessenger = this.endpoint.getMessenger(destAddress, hint);
            if (null == this.cachedMessenger) {
                this.setConnected(false);
            }
        } else if (Logging.SHOW_FINE && LOG.isLoggable(Level.FINE)) {
            LOG.fine("connection closed : NOT getting new cached Messenger for " + this.peerName);
        }
        return this.cachedMessenger;
    }

    public boolean sendMessage(Message msg, String service, String param) {
        Messenger messenger = this.getCachedMessenger();
        if (null != messenger) {
            messenger.sendMessage(msg, service, param, this);
            return true;
        }
        return false;
    }
}

