/*
 * Decompiled with CFR 0.152.
 */
package net.jxta.id;

import java.io.ObjectStreamException;
import java.io.Serializable;
import java.lang.ref.Reference;
import java.lang.ref.WeakReference;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import java.net.URL;
import java.util.Map;
import java.util.WeakHashMap;
import net.jxta.id.IDFactory;
import net.jxta.id.NullID;

public abstract class ID
implements Serializable {
    private static final Map<ID, WeakReference<ID>> interned = new WeakHashMap<ID, WeakReference<ID>>(1000);
    public static final String URIEncodingName = "urn";
    public static final String URNNamespace = "jxta";
    public static final ID nullID = new NullID().intern();

    public static ID create(URI fromURI) {
        try {
            return IDFactory.fromURI(fromURI);
        }
        catch (URISyntaxException badid) {
            IllegalArgumentException failure = new IllegalArgumentException();
            failure.initCause(badid);
            throw failure;
        }
    }

    protected ID() {
    }

    public String toString() {
        return this.toURI().toString();
    }

    private Object readResolve() throws ObjectStreamException {
        return this.intern();
    }

    public abstract String getIDFormat();

    public abstract Object getUniqueValue();

    @Deprecated
    public URL getURL() {
        try {
            return IDFactory.jxtaURL(URIEncodingName, "", "jxta:" + this.getUniqueValue());
        }
        catch (MalformedURLException caught) {
            IllegalStateException failure = new IllegalStateException("Environment incorrectly intialized.");
            failure.initCause(caught);
            throw failure;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected ID intern() {
        Class<ID> clazz = ID.class;
        synchronized (ID.class) {
            Reference common = interned.get(this);
            ID result = null;
            if (null != common) {
                result = (ID)common.get();
            }
            if (null == result) {
                interned.put(this, new WeakReference<ID>(this));
                result = this;
            }
            // ** MonitorExit[var1_1] (shouldn't be in output)
            return result;
        }
    }

    public URI toURI() {
        return URI.create("urn:jxta:" + this.getUniqueValue());
    }
}

