/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.modeler;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.w3c.dom.NodeList;
import org.xml.sax.SAXException;
import org.xml.sax.SAXParseException;

class ConfigReader {
    ConfigReader() {
    }

    static NodeList getMBeans(String url, String dLocation) throws IOException {
        Document doc = ConfigReader.getDocument(url, dLocation);
        NodeList root = doc.getElementsByTagName("mbeans-descriptors");
        Element e = (Element)root.item(0);
        NodeList mbeans = e.getElementsByTagName("mbean");
        return mbeans;
    }

    static NodeList getRelations(String url, String dLocation) throws IOException {
        Document doc = ConfigReader.getDocument(url, dLocation);
        NodeList root = doc.getElementsByTagName("relation-descriptors");
        Element e = (Element)root.item(0);
        NodeList relations = e.getElementsByTagName("relation");
        return relations;
    }

    static Document getDocument(String url, String defaultLocation) throws IOException {
        Document doc = null;
        InputStream in = null;
        try {
            DocumentBuilderFactory dbf = DocumentBuilderFactory.newInstance();
            dbf.setValidating(false);
            DocumentBuilder db = dbf.newDocumentBuilder();
            try {
                ClassLoader cl = ConfigReader.class.getClassLoader();
                in = cl.getResourceAsStream(url);
            }
            catch (Exception e) {
                // empty catch block
            }
            if (in == null) {
                in = new FileInputStream(defaultLocation + url);
            }
            doc = db.parse(in);
        }
        catch (ParserConfigurationException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXParseException e) {
            throw new IOException(e.getMessage());
        }
        catch (SAXException e) {
            throw new IOException(e.getMessage());
        }
        finally {
            if (in != null) {
                try {
                    in.close();
                }
                catch (Exception ex) {}
            }
        }
        return doc;
    }

    static NodeList getMBeanAttrMappings(Element e) {
        NodeList attr = null;
        if (e != null) {
            attr = e.getElementsByTagName("attribute");
        }
        return attr;
    }

    static String getMBeanObjectName(Element mbean, boolean isProxy) {
        NodeList descriptors = mbean.getElementsByTagName("descriptor");
        Element d = (Element)descriptors.item(0);
        NodeList fields = d.getElementsByTagName("field");
        Element f = null;
        f = !isProxy ? (Element)fields.item(0) : (Element)fields.item(1);
        String objectName = f.getAttribute("value").trim();
        return objectName;
    }
}

