/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.delegate;

import com.sun.cmm.cim.OperationalStatus;
import com.sun.mfwk.agent.appserv.connection.ConnectionRegistry;
import com.sun.mfwk.agent.appserv.delegate.BaseHandler;
import com.sun.mfwk.agent.appserv.delegate.HandlerException;
import com.sun.mfwk.agent.appserv.util.Utils;
import java.io.IOException;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;
import java.util.logging.Level;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class ServerStatusHandler
extends BaseHandler {
    public Object handleAttribute(ObjectName peer, String attribute, MBeanServerConnection mbs) throws HandlerException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException, IOException {
        try {
            ConnectionRegistry registry = ConnectionRegistry.getInstance();
            MBeanServerConnection connection = registry.getConnection("server", (String)this.getMappingQueryService().getProperty("domain.name"));
            Object status = connection.invoke(new ObjectName("com.sun.appserv:name=domain-status"), "getstate", new String[]{peer.getKeyProperty("name")}, new String[]{"java.lang.String"});
            int code = (Integer)status;
            Utils.log(Level.FINEST, "status = " + code);
            Set<OperationalStatus> s = Collections.synchronizedSet(new HashSet());
            switch (code) {
                case 1: {
                    s.add(OperationalStatus.OK);
                    break;
                }
                case 0: {
                    s.add(OperationalStatus.STARTING);
                    break;
                }
                case 2: {
                    s.add(OperationalStatus.STOPPED);
                }
                case 3: {
                    s.add(OperationalStatus.STOPPING);
                    break;
                }
                default: {
                    s.add(OperationalStatus.UNKNOWN);
                }
            }
            return s;
        }
        catch (Exception ex) {
            throw new HandlerException(ex);
        }
    }
}

