/*
 * Decompiled with CFR 0.152.
 */
package com.sun.mfwk.agent.appserv.delegate;

import com.sun.mfwk.agent.appserv.delegate.BaseHandler;
import com.sun.mfwk.agent.appserv.delegate.HandlerException;
import com.sun.mfwk.agent.appserv.util.Utils;
import java.io.IOException;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.logging.Level;
import javax.management.AttributeNotFoundException;
import javax.management.InstanceNotFoundException;
import javax.management.MBeanException;
import javax.management.MBeanServerConnection;
import javax.management.ObjectName;
import javax.management.ReflectionException;

public class OutboundAssociationsHandler
extends BaseHandler {
    public Object handleAttribute(ObjectName peer, String attribute, MBeanServerConnection mbs) throws HandlerException, AttributeNotFoundException, MBeanException, ReflectionException, InstanceNotFoundException, IOException {
        Set<ObjectName> objectNames;
        long outboundAssociations = 0L;
        try {
            String serverName = peer.getKeyProperty("name");
            ObjectName connectionManagerPattern = new ObjectName("com.sun.appserv:*,category=monitor,type=connection-manager,server=" + serverName);
            objectNames = mbs.queryNames(connectionManagerPattern, null);
            Iterator<ObjectName> iterator = objectNames.iterator();
            HashSet<ObjectName> outboundConnections = new HashSet<ObjectName>();
            ObjectName connectionManager = null;
            String connectionManagerName = null;
            while (iterator.hasNext()) {
                connectionManager = iterator.next();
                connectionManagerName = connectionManager.getKeyProperty("name");
                if (!connectionManagerName.startsWith("orb.Connections.Outbound")) continue;
                outboundConnections.add(connectionManager);
            }
            outboundAssociations = Utils.getAttributeSum(mbs, outboundConnections, "connectionsinuse-count");
            ObjectName connectorConnectionPoolPattern = new ObjectName("com.sun.appserv:*,category=monitor,type=connector-connection-pool,server=" + serverName);
            objectNames = mbs.queryNames(connectorConnectionPoolPattern, null);
            outboundAssociations += Utils.getAttributeSum(mbs, objectNames, "numconnused-current");
            ObjectName jdbcConnectionPoolPattern = new ObjectName("com.sun.appserv:*,category=monitor,type=jdbc-connection-pool,server=" + serverName);
            objectNames = mbs.queryNames(jdbcConnectionPoolPattern, null);
        }
        catch (Exception exception) {
            Utils.log(Level.SEVERE, "Error while getting Outbound Associations", exception);
            throw new HandlerException(exception);
        }
        return new Long(outboundAssociations += Utils.getAttributeSum(mbs, objectNames, "numconnused-current"));
    }
}

